/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.AbstractPartition;
import org.apache.directory.server.core.partition.impl.btree.ServerEntryCursorAdaptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.search.Optimizer;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.UsageEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BTreePartition<ID>
extends AbstractPartition {
    protected SearchEngine<Entry, ID> searchEngine;
    protected Optimizer optimizer;
    protected String id;
    protected int cacheSize = -1;
    protected Dn suffix;
    protected URI partitionPath;
    private Set<Index<?, Entry, ID>> indexedAttributes = new HashSet();

    protected BTreePartition() {
    }

    public URI getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(URI partitionPath) {
        this.partitionPath = partitionPath;
    }

    public void setIndexedAttributes(Set<Index<?, Entry, ID>> indexedAttributes) {
        this.indexedAttributes = indexedAttributes;
    }

    public void addIndexedAttributes(Index<?, Entry, ID> ... indexes) {
        for (Index<?, Entry, ID> index : indexes) {
            this.indexedAttributes.add(index);
        }
    }

    public Set<Index<?, Entry, ID>> getIndexedAttributes() {
        return this.indexedAttributes;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public SearchEngine<Entry, ID> getSearchEngine() {
        return this.searchEngine;
    }

    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        Dn dn = deleteContext.getDn();
        ID id = this.getEntryId(dn);
        if (id == null) {
            throw new LdapNoSuchObjectException(I18n.err(I18n.ERR_699, dn));
        }
        if (this.getChildCount(id) > 0) {
            LdapContextNotEmptyException cnee = new LdapContextNotEmptyException(I18n.err(I18n.ERR_700, dn));
            throw cnee;
        }
        this.delete(id);
    }

    @Override
    public abstract void add(AddOperationContext var1) throws LdapException;

    @Override
    public abstract void modify(ModifyOperationContext var1) throws LdapException;

    @Override
    public EntryFilteringCursor list(ListOperationContext listContext) throws LdapException {
        return new BaseEntryFilteringCursor(new ServerEntryCursorAdaptor<ID>(this, this.list(this.getEntryId(listContext.getDn()))), listContext);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        try {
            SearchControls searchCtls = searchContext.getSearchControls();
            Dn dn = searchContext.getDn();
            AliasDerefMode derefMode = searchContext.getAliasDerefMode();
            ExprNode filter = searchContext.getFilter();
            IndexCursor<ID, Entry, ID> underlying = this.searchEngine.cursor(dn, derefMode, filter, searchCtls);
            return new BaseEntryFilteringCursor(new ServerEntryCursorAdaptor<ID>(this, underlying), searchContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), e);
        }
    }

    @Override
    public ClonedServerEntry lookup(LookupOperationContext lookupContext) throws LdapException {
        ID id = this.getEntryId(lookupContext.getDn());
        if (id == null) {
            return null;
        }
        ClonedServerEntry entry = this.lookup(id);
        if (lookupContext.hasNoAttribute()) {
            entry.clear();
            return entry;
        }
        if (lookupContext.hasAllUser()) {
            if (lookupContext.hasAllOperational()) {
                return entry;
            }
            for (AttributeType attributeType : entry.getOriginalEntry().getAttributeTypes()) {
                String oid = attributeType.getOid();
                if (attributeType.getUsage() == UsageEnum.USER_APPLICATIONS || lookupContext.getAttrsId().contains(oid)) continue;
                entry.removeAttributes(attributeType);
            }
        } else if (lookupContext.hasAllOperational()) {
            for (AttributeType attributeType : entry.getOriginalEntry().getAttributeTypes()) {
                if (attributeType.getUsage() != UsageEnum.USER_APPLICATIONS) continue;
                entry.removeAttributes(attributeType);
            }
        } else if (lookupContext.getAttrsId().size() == 0) {
            for (AttributeType attributeType : entry.getOriginalEntry().getAttributeTypes()) {
                if (attributeType.getUsage() == UsageEnum.USER_APPLICATIONS) continue;
                entry.removeAttributes(attributeType);
            }
        } else {
            for (AttributeType attributeType : entry.getOriginalEntry().getAttributeTypes()) {
                String oid = attributeType.getOid();
                if (lookupContext.getAttrsId().contains(oid)) continue;
                entry.removeAttributes(attributeType);
            }
        }
        return entry;
    }

    @Override
    public boolean hasEntry(EntryOperationContext hasEntryContext) throws LdapException {
        return null != this.getEntryId(hasEntryContext.getDn());
    }

    @Override
    public abstract void rename(RenameOperationContext var1) throws LdapException;

    @Override
    public abstract void move(MoveOperationContext var1) throws LdapException;

    @Override
    public abstract void moveAndRename(MoveAndRenameOperationContext var1) throws LdapException;

    @Override
    public abstract void sync() throws Exception;

    public abstract void addIndexOn(Index<?, Entry, ID> var1) throws Exception;

    public abstract boolean hasUserIndexOn(AttributeType var1) throws Exception;

    public abstract boolean hasSystemIndexOn(AttributeType var1) throws Exception;

    public abstract Index<String, Entry, ID> getPresenceIndex();

    public abstract Index<ID, Entry, ID> getOneLevelIndex();

    public abstract Index<ID, Entry, ID> getSubLevelIndex();

    public abstract Index<ID, Entry, ID> getOneAliasIndex();

    public abstract Index<ID, Entry, ID> getSubAliasIndex();

    public abstract Index<String, Entry, ID> getAliasIndex();

    @Override
    public void setSuffix(Dn suffix) throws LdapInvalidDnException {
        this.suffix = suffix;
        if (this.schemaManager != null) {
            this.suffix.apply(this.schemaManager);
        }
    }

    @Override
    public Dn getSuffix() {
        return this.suffix;
    }

    public abstract Index<?, Entry, ID> getUserIndex(AttributeType var1) throws Exception;

    public abstract Index<?, Entry, ID> getSystemIndex(AttributeType var1) throws Exception;

    public abstract ID getEntryId(Dn var1) throws LdapException;

    public abstract Dn getEntryDn(ID var1) throws Exception;

    public abstract ClonedServerEntry lookup(ID var1) throws LdapException;

    public abstract void delete(ID var1) throws LdapException;

    public abstract IndexCursor<ID, Entry, ID> list(ID var1) throws LdapException;

    public abstract int getChildCount(ID var1) throws LdapException;

    public abstract void setProperty(String var1, String var2) throws Exception;

    public abstract String getProperty(String var1) throws Exception;

    public abstract Iterator<String> getUserIndices();

    public abstract Iterator<String> getSystemIndices();

    public abstract int count() throws Exception;
}

