/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition;

import javax.naming.InvalidNameException;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapOtherException;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public abstract class AbstractPartition
implements Partition {
    protected boolean initialized;
    protected SchemaManager schemaManager;
    protected Entry contextEntry;

    protected AbstractPartition() {
    }

    public final void initialize() throws LdapException {
        if (this.initialized) {
            return;
        }
        try {
            this.doInit();
            this.initialized = true;
        }
        catch (Exception e) {
            throw new LdapOtherException(e.getMessage(), e);
        }
        finally {
            if (!this.initialized) {
                try {
                    this.destroy();
                }
                catch (Exception e) {
                    throw new LdapOtherException(e.getMessage(), e);
                }
            }
        }
    }

    protected abstract void doInit() throws InvalidNameException, Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() throws Exception {
        try {
            this.doDestroy();
        }
        finally {
            this.initialized = false;
        }
    }

    protected abstract void doDestroy() throws Exception;

    public boolean isInitialized() {
        return this.initialized;
    }

    public abstract void sync() throws Exception;

    public boolean hasEntry(EntryOperationContext entryContext) throws LdapException {
        try {
            return entryContext.lookup(entryContext.getDn(), ByPassConstants.LOOKUP_BYPASS) != null;
        }
        catch (LdapException e) {
            return false;
        }
    }

    public abstract Entry lookup(LookupOperationContext var1) throws LdapException;

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public Entry getContextEntry() {
        return this.contextEntry;
    }

    public void setContextEntry(Entry contextEntry) {
        this.contextEntry = contextEntry;
    }
}

