/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;

public class MoveOperationContext
extends AbstractChangeOperationContext {
    private Dn oldSuperior;
    private Rdn rdn;
    private Dn newSuperior;
    private Dn newDn;

    public MoveOperationContext(CoreSession session) {
        super(session);
    }

    public MoveOperationContext(CoreSession session, Dn oldDn, Dn newSuperior) {
        super(session, oldDn);
        this.newSuperior = newSuperior;
        this.oldSuperior = oldDn.getParent();
        this.rdn = oldDn.getRdn().clone();
        try {
            this.newDn = newSuperior.add(this.rdn);
        }
        catch (LdapInvalidDnException lide) {
            throw new IllegalArgumentException(lide.getMessage(), lide);
        }
    }

    public MoveOperationContext(CoreSession session, ModifyDnRequest modifyDnRequest) {
        super(session, modifyDnRequest.getName());
        this.newSuperior = modifyDnRequest.getNewSuperior();
        if (this.newSuperior == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_326_NEW_SUPERIROR_CANNOT_BE_NULL, modifyDnRequest));
        }
        this.requestControls = modifyDnRequest.getControls();
        if (modifyDnRequest.getNewRdn() != null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_327_MOVE_AND_RENAME_OPERATION, modifyDnRequest));
        }
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
        this.oldSuperior = modifyDnRequest.getName().getParent();
        this.rdn = modifyDnRequest.getName().getRdn().clone();
        try {
            this.newDn = this.newSuperior.add(this.rdn);
        }
        catch (LdapInvalidDnException lide) {
            throw new IllegalArgumentException(lide.getMessage(), lide);
        }
    }

    public Dn getOldSuperior() {
        return this.oldSuperior;
    }

    public Dn getNewSuperior() {
        return this.newSuperior;
    }

    public Rdn getRdn() {
        return this.rdn;
    }

    public Dn getNewDn() {
        return this.newDn;
    }

    public String getName() {
        return MessageTypeEnum.MODIFYDN_REQUEST.name();
    }

    public String toString() {
        return "ReplaceContext for old Dn '" + this.getDn().getName() + "'" + ", newSuperior '" + this.newSuperior + "'";
    }
}

