/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public abstract class BaseInterceptor
implements Interceptor {
    protected DirectoryService directoryService;
    protected SchemaManager schemaManager;
    protected static final Set<AttributeType> PWD_POLICY_STATE_ATTRIBUTE_TYPES = new HashSet<AttributeType>();
    protected static AttributeType ACCESS_CONTROL_SUBENTRIES_AT;
    protected static AttributeType ADMINISTRATIVE_ROLE_AT;
    protected static AttributeType COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT;
    protected static AttributeType COLLECTIVE_EXCLUSIONS_AT;
    protected static AttributeType ENTRY_ACI_AT;
    protected static AttributeType ENTRY_CSN_AT;
    protected static AttributeType ENTRY_UUID_AT;
    protected static AttributeType MODIFIERS_NAME_AT;
    protected static AttributeType MODIFY_TIMESTAMP_AT;
    protected static AttributeType OBJECT_CLASS_AT;
    protected static AttributeType SUBENTRY_ACI_AT;
    protected static AttributeType SUBSCHEMA_SUBENTRY_AT;
    protected static AttributeType SUBTREE_SPECIFICATION_AT;
    protected static AttributeType TRIGGER_EXECUTION_SUBENTRIES_AT;
    protected static AttributeType UNIQUE_MEMBER_AT;

    public String getName() {
        return this.getClass().getName();
    }

    public static LdapPrincipal getPrincipal() {
        return BaseInterceptor.getContext().getSession().getEffectivePrincipal();
    }

    public static OperationContext getContext() {
        return InvocationStack.getInstance().peek();
    }

    protected BaseInterceptor() {
    }

    public void init(DirectoryService directoryService) throws LdapException {
        this.directoryService = directoryService;
        this.schemaManager = directoryService.getSchemaManager();
        ACCESS_CONTROL_SUBENTRIES_AT = this.schemaManager.getAttributeType("accessControlSubentries");
        ADMINISTRATIVE_ROLE_AT = this.schemaManager.getAttributeType("administrativeRole");
        COLLECTIVE_ATTRIBUTE_SUBENTRIES_AT = this.schemaManager.getAttributeType("collectiveAttributeSubentries");
        COLLECTIVE_EXCLUSIONS_AT = this.schemaManager.getAttributeType("collectiveExclusions");
        ENTRY_ACI_AT = this.schemaManager.getAttributeType("2.5.24.5");
        ENTRY_CSN_AT = this.schemaManager.getAttributeType("entryCSN");
        ENTRY_UUID_AT = this.schemaManager.getAttributeType("entryUUID");
        MODIFIERS_NAME_AT = this.schemaManager.getAttributeType("modifiersName");
        MODIFY_TIMESTAMP_AT = this.schemaManager.getAttributeType("modifyTimestamp");
        OBJECT_CLASS_AT = this.schemaManager.getAttributeType("objectClass");
        SUBENTRY_ACI_AT = this.schemaManager.getAttributeType("2.5.24.6");
        SUBSCHEMA_SUBENTRY_AT = this.schemaManager.getAttributeType("subschemaSubentry");
        SUBTREE_SPECIFICATION_AT = this.schemaManager.getAttributeType("subtreeSpecification");
        TRIGGER_EXECUTION_SUBENTRIES_AT = this.schemaManager.getAttributeType("triggerExecutionSubentries");
        UNIQUE_MEMBER_AT = this.schemaManager.getAttributeType("2.5.4.50");
    }

    public void destroy() {
    }

    public void add(NextInterceptor next, AddOperationContext addContext) throws LdapException {
        next.add(addContext);
    }

    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws LdapException {
        next.delete(deleteContext);
    }

    public Entry getRootDSE(NextInterceptor next, GetRootDSEOperationContext getRootDseContext) throws LdapException {
        return next.getRootDSE(getRootDseContext);
    }

    public boolean hasEntry(NextInterceptor next, EntryOperationContext hasEntryContext) throws LdapException {
        return next.hasEntry(hasEntryContext);
    }

    public EntryFilteringCursor list(NextInterceptor next, ListOperationContext listContext) throws LdapException {
        return next.list(listContext);
    }

    public Entry lookup(NextInterceptor next, LookupOperationContext lookupContext) throws LdapException {
        return next.lookup(lookupContext);
    }

    public void modify(NextInterceptor next, ModifyOperationContext modifyContext) throws LdapException {
        next.modify(modifyContext);
    }

    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        next.moveAndRename(moveAndRenameContext);
    }

    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws LdapException {
        next.rename(renameContext);
    }

    public void move(NextInterceptor next, MoveOperationContext moveContext) throws LdapException {
        next.move(moveContext);
    }

    public EntryFilteringCursor search(NextInterceptor next, SearchOperationContext searchContext) throws LdapException {
        return next.search(searchContext);
    }

    public boolean compare(NextInterceptor next, CompareOperationContext compareContext) throws LdapException {
        return next.compare(compareContext);
    }

    public void bind(NextInterceptor next, BindOperationContext bindContext) throws LdapException {
        next.bind(bindContext);
    }

    public void unbind(NextInterceptor next, UnbindOperationContext unbindContext) throws LdapException {
        next.unbind(unbindContext);
    }
}

