/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.factory;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.InstanceLayout;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.JdbmPartitionFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.core.schema.SchemaPartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.schemaextractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.shared.ldap.schemaloader.LdifSchemaLoader;
import org.apache.directory.shared.ldap.schemamanager.impl.DefaultSchemaManager;
import org.apache.directory.shared.util.exception.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDirectoryServiceFactory
implements DirectoryServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDirectoryServiceFactory.class);
    public static final DirectoryServiceFactory DEFAULT = new DefaultDirectoryServiceFactory();
    private DirectoryService directoryService;
    private PartitionFactory partitionFactory;

    DefaultDirectoryServiceFactory() {
        try {
            this.directoryService = new DefaultDirectoryService();
            this.directoryService.setShutdownHookEnabled(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String typeName = System.getProperty("apacheds.partition.factory");
            if (typeName != null) {
                Class<?> type = Class.forName(typeName);
                this.partitionFactory = (PartitionFactory)type.newInstance();
            } else {
                this.partitionFactory = new JdbmPartitionFactory();
            }
        }
        catch (Exception e) {
            LOG.error("Error instantiating custom partiton factory", e);
            throw new RuntimeException(e);
        }
    }

    public void init(String name) throws Exception {
        if (this.directoryService != null && this.directoryService.isStarted()) {
            return;
        }
        this.build(name);
    }

    private void buildInstanceDirectory(String name) {
        InstanceLayout instanceLayout;
        String instanceDirectory = System.getProperty("workingDirectory");
        if (instanceDirectory == null) {
            instanceDirectory = System.getProperty("java.io.tmpdir") + "/server-work-" + name;
        }
        if ((instanceLayout = new InstanceLayout(instanceDirectory)).getInstanceDirectory().exists()) {
            try {
                FileUtils.deleteDirectory(instanceLayout.getInstanceDirectory());
            }
            catch (IOException e) {
                LOG.warn("couldn't delete the instance directory before initializing the DirectoryService", e);
            }
        }
        this.directoryService.setInstanceLayout(instanceLayout);
    }

    private void initSchema() throws Exception {
        SchemaPartition schemaPartition = this.directoryService.getSchemaService().getSchemaPartition();
        LdifPartition ldifPartition = new LdifPartition();
        File workingDirectory = this.directoryService.getInstanceLayout().getPartitionsDirectory();
        ldifPartition.setPartitionPath(new File(workingDirectory, "schema").toURI());
        File schemaRepository = new File(workingDirectory, "schema");
        DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(workingDirectory);
        try {
            extractor.extractOrCopy();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        schemaPartition.setWrappedPartition(ldifPartition);
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager(loader);
        this.directoryService.setSchemaManager(schemaManager);
        schemaManager.loadAllEnabled();
        schemaPartition.setSchemaManager(schemaManager);
        List<Throwable> errors = schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception(I18n.err(I18n.ERR_317, Exceptions.printErrors(errors)));
        }
    }

    private void initSystemPartition() throws Exception {
        Partition systemPartition = this.partitionFactory.createPartition("system", "ou=system", 500, new File(this.directoryService.getInstanceLayout().getPartitionsDirectory(), "system"));
        systemPartition.setSchemaManager(this.directoryService.getSchemaManager());
        this.partitionFactory.addIndex(systemPartition, "objectClass", 100);
        this.directoryService.setSystemPartition(systemPartition);
    }

    private void build(String name) throws Exception {
        this.directoryService.setInstanceId(name);
        this.buildInstanceDirectory(name);
        this.initSchema();
        this.initSystemPartition();
        this.directoryService.startup();
    }

    public DirectoryService getDirectoryService() throws Exception {
        return this.directoryService;
    }

    public PartitionFactory getPartitionFactory() throws Exception {
        return this.partitionFactory;
    }
}

