/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidSearchFilterException;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.SubstringNode;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.Normalizer;

public class SubstringEvaluator
implements Evaluator {
    public boolean evaluate(ExprNode node, Dn dn, Entry entry) throws LdapException {
        Pattern regex = null;
        SubstringNode snode = (SubstringNode)node;
        AttributeType attributeType = snode.getAttributeType();
        MatchingRule matchingRule = attributeType.getSubstring();
        if (matchingRule == null) {
            matchingRule = attributeType.getEquality();
        }
        Normalizer normalizer = matchingRule.getNormalizer();
        Attribute attr = entry.get(snode.getAttribute());
        if (null == attr) {
            return false;
        }
        try {
            regex = snode.getRegex(normalizer);
        }
        catch (PatternSyntaxException pse) {
            LdapInvalidSearchFilterException ne = new LdapInvalidSearchFilterException(I18n.err(I18n.ERR_248, node));
            ne.initCause(pse);
            throw ne;
        }
        for (Value value : attr) {
            String normValue = normalizer.normalize(value.getString());
            if (!regex.matcher(normValue).matches()) continue;
            return true;
        }
        return false;
    }
}

