/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.changelog;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.changelog.ChangeLog;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.schema.SchemaService;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.ldif.ChangeType;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.ldif.LdifRevertor;
import org.apache.directory.shared.ldap.model.message.controls.ManageDsaITImpl;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeLogInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeLogInterceptor.class);
    private AttributeType entryDeleted;
    private ChangeLog changeLog;
    private SchemaService schemaService;
    private static final String REV_AT_OID = "1.3.6.1.4.1.18060.0.4.1.2.47";

    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.changeLog = directoryService.getChangeLog();
        this.schemaService = directoryService.getSchemaService();
        this.entryDeleted = directoryService.getSchemaManager().getAttributeType("1.3.6.1.4.1.18060.0.4.1.2.31");
    }

    public void add(NextInterceptor next, AddOperationContext addContext) throws LdapException {
        next.add(addContext);
        if (!this.changeLog.isEnabled()) {
            return;
        }
        Entry addEntry = addContext.getEntry();
        if (addEntry.get(REV_AT_OID) != null) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.Add);
        forward.setDn(addContext.getDn());
        Set<AttributeType> list = addEntry.getAttributeTypes();
        for (AttributeType attributeType : list) {
            forward.addAttribute(addEntry.get(attributeType).clone());
        }
        LdifEntry reverse = LdifRevertor.reverseAdd(addContext.getDn());
        addContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverse));
    }

    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws LdapException {
        Entry serverEntry = null;
        if (this.changeLog.isEnabled()) {
            serverEntry = this.getAttributes(deleteContext);
        }
        next.delete(deleteContext);
        if (!this.changeLog.isEnabled()) {
            return;
        }
        if (serverEntry.get(REV_AT_OID) != null) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.Delete);
        forward.setDn(deleteContext.getDn());
        DefaultEntry reverseEntry = new DefaultEntry(serverEntry.getDn());
        boolean isCollectiveSubentry = serverEntry.hasObjectClass("collectiveAttributeSubentry");
        for (Attribute attribute : serverEntry) {
            AttributeType at = (AttributeType)this.schemaService.getSchemaManager().getAttributeTypeRegistry().lookup(attribute.getId());
            if (at.isCollective() && !isCollectiveSubentry) continue;
            reverseEntry.add(attribute.clone());
        }
        LdifEntry reverse = LdifRevertor.reverseDel(deleteContext.getDn(), reverseEntry);
        deleteContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverse));
    }

    private Entry getAttributes(OperationContext opContext) throws LdapException {
        Dn dn = opContext.getDn();
        if (this.schemaService.isSchemaSubentry(dn)) {
            return this.schemaService.getSubschemaEntryCloned();
        }
        Entry serverEntry = opContext.lookup(dn, ByPassConstants.LOOKUP_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        return serverEntry;
    }

    public void modify(NextInterceptor next, ModifyOperationContext modifyContext) throws LdapException {
        boolean isDelete;
        Entry serverEntry = null;
        Modification modification = ServerEntryUtils.getModificationItem(modifyContext.getModItems(), this.entryDeleted);
        boolean bl = isDelete = modification != null;
        if (!isDelete && this.changeLog.isEnabled()) {
            serverEntry = this.getAttributes(modifyContext);
        }
        ArrayList<Modification> clonedMods = new ArrayList<Modification>();
        for (Modification mod : modifyContext.getModItems()) {
            clonedMods.add(mod.clone());
        }
        next.modify(modifyContext);
        if (isDelete || !this.changeLog.isEnabled() || modifyContext.getModItems().size() == 0) {
            if (isDelete) {
                LOG.debug("Bypassing changelog on modify of entryDeleted attribute.");
            }
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.Modify);
        forward.setDn(modifyContext.getDn());
        ArrayList<Modification> mods = new ArrayList<Modification>(clonedMods.size());
        for (Modification modItem : clonedMods) {
            mods.add(modItem);
            forward.addModification(modItem);
        }
        DefaultEntry clientEntry = new DefaultEntry(serverEntry.getDn());
        for (Attribute attribute : serverEntry) {
            clientEntry.add(attribute.clone());
        }
        LdifEntry reverse = LdifRevertor.reverseModify(modifyContext.getDn(), mods, clientEntry);
        modifyContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverse));
    }

    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws LdapException {
        Entry serverEntry = null;
        if (renameContext.getEntry() != null) {
            serverEntry = ((ClonedServerEntry)renameContext.getEntry()).getOriginalEntry();
        }
        next.rename(renameContext);
        if (!this.changeLog.isEnabled()) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.ModRdn);
        forward.setDn(renameContext.getDn());
        forward.setNewRdn(renameContext.getNewRdn().getName());
        forward.setDeleteOldRdn(renameContext.getDeleteOldRdn());
        List<LdifEntry> reverses = LdifRevertor.reverseRename(serverEntry, renameContext.getNewRdn(), renameContext.getDeleteOldRdn());
        renameContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverses));
    }

    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Entry serverEntry = null;
        if (this.changeLog.isEnabled()) {
            serverEntry = moveAndRenameContext.getOriginalEntry();
        }
        next.moveAndRename(moveAndRenameContext);
        if (!this.changeLog.isEnabled()) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.ModDn);
        forward.setDn(moveAndRenameContext.getDn());
        forward.setDeleteOldRdn(moveAndRenameContext.getDeleteOldRdn());
        forward.setNewRdn(moveAndRenameContext.getNewRdn().getName());
        forward.setNewSuperior(moveAndRenameContext.getNewSuperiorDn().getName());
        List<LdifEntry> reverses = LdifRevertor.reverseMoveAndRename(serverEntry, moveAndRenameContext.getNewSuperiorDn(), moveAndRenameContext.getNewRdn(), false);
        if (moveAndRenameContext.isReferralIgnored()) {
            forward.addControl(new ManageDsaITImpl());
            LdifEntry reversedEntry = reverses.get(0);
            reversedEntry.addControl(new ManageDsaITImpl());
        }
        moveAndRenameContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverses));
    }

    public void move(NextInterceptor next, MoveOperationContext moveContext) throws LdapException {
        next.move(moveContext);
        if (!this.changeLog.isEnabled()) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.ModDn);
        forward.setDn(moveContext.getDn());
        forward.setNewSuperior(moveContext.getNewSuperior().getName());
        LdifEntry reverse = LdifRevertor.reverseMove(moveContext.getNewSuperior(), moveContext.getDn());
        moveContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal(), forward, reverse));
    }
}

