/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.LinkedAvlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvlTreeImpl<K>
implements AvlTree<K> {
    private LinkedAvlNode<K> root;
    private Comparator<K> comparator;
    private LinkedAvlNode<K> first;
    private LinkedAvlNode<K> last;
    private int size;

    public AvlTreeImpl(Comparator<K> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<K> getComparator() {
        return this.comparator;
    }

    @Override
    public K insert(K key) {
        int c;
        LinkedAvlNode<K> parent = null;
        if (this.root == null) {
            this.root = new LinkedAvlNode<K>(key);
            this.first = this.root;
            this.last = this.root;
            ++this.size;
            return null;
        }
        LinkedAvlNode<K> node = new LinkedAvlNode<K>(key);
        LinkedAvlNode<K> temp = this.root;
        ArrayList<LinkedAvlNode<K>> treePath = new ArrayList<LinkedAvlNode<K>>();
        while (temp != null) {
            treePath.add(0, temp);
            parent = temp;
            c = this.comparator.compare(key, temp.getKey());
            if (c == 0) {
                return key;
            }
            if (c < 0) {
                temp.isLeft = true;
                temp = temp.getLeft();
                continue;
            }
            temp.isLeft = false;
            temp = temp.getRight();
        }
        c = this.comparator.compare(key, parent.getKey());
        if (c < 0) {
            parent.setLeft(node);
        } else {
            parent.setRight(node);
        }
        this.insertInList(node, parent, c);
        treePath.add(0, node);
        this.balance(treePath);
        ++this.size;
        return null;
    }

    private void removeFromList(LinkedAvlNode<K> node) {
        if (node.next == null && node.previous == null) {
            this.last = null;
            this.first = null;
        } else if (node.next == null) {
            node.previous.next = null;
            this.last = node.previous;
        } else if (node.previous == null) {
            node.next.previous = null;
            this.first = node.next;
        } else {
            node.previous.next = node.next;
            node.next.previous = node.previous;
        }
    }

    private void insertInList(LinkedAvlNode<K> node, LinkedAvlNode<K> parentNode, int pos) {
        if (pos < 0) {
            if (this.last == null) {
                this.last = parentNode;
            }
            if (parentNode.previous == null) {
                this.first = node;
            } else {
                parentNode.previous.next = node;
                node.previous = parentNode.previous;
            }
            node.next = parentNode;
            parentNode.previous = node;
        } else if (pos > 0) {
            if (parentNode.next == null) {
                this.last = node;
            } else {
                parentNode.next.previous = node;
                node.next = parentNode.next;
            }
            node.previous = parentNode;
            parentNode.next = node;
        }
    }

    @Override
    public K remove(K key) {
        LinkedAvlNode<K> temp = null;
        LinkedAvlNode y = null;
        List<LinkedAvlNode<Object>> treePath = new ArrayList<LinkedAvlNode<K>>();
        if ((treePath = this.find(key, this.root, treePath)) == null) {
            return null;
        }
        temp = treePath.remove(0);
        this.removeFromList(temp);
        if (temp.isLeaf()) {
            if (temp == this.root) {
                this.root = null;
                --this.size;
                return key;
            }
            if (!treePath.isEmpty()) {
                this.detachNodes(temp, treePath.get(0));
            }
        } else if (temp.left != null) {
            List leftTreePath = this.findMax(temp.left);
            y = leftTreePath.remove(0);
            if (leftTreePath.isEmpty()) {
                this.detachNodes(y, temp);
            } else {
                this.detachNodes(y, leftTreePath.remove(0));
            }
            leftTreePath.addAll(treePath);
            treePath = leftTreePath;
            y.right = temp.right;
            if (temp == this.root) {
                y.left = temp.left;
                this.root = y;
            } else {
                this.replaceNode(temp, y, treePath.get(0));
            }
        } else if (temp.right != null) {
            List rightTreePath = this.findMin(temp.right);
            y = rightTreePath.remove(0);
            if (rightTreePath.isEmpty()) {
                this.detachNodes(y, temp);
            } else {
                this.detachNodes(y, rightTreePath.remove(0));
            }
            rightTreePath.addAll(treePath);
            treePath = rightTreePath;
            y.right = temp.right;
            if (temp == this.root) {
                y.right = temp.right;
                this.root = y;
            } else {
                this.replaceNode(temp, y, treePath.get(0));
            }
        }
        treePath.add(0, y);
        this.balance(treePath);
        --this.size;
        return key;
    }

    private void balance(List<LinkedAvlNode<K>> treePath) {
        LinkedAvlNode<K> parentNode = null;
        int size = treePath.size();
        for (LinkedAvlNode<K> node : treePath) {
            int balFactor = this.getBalance(node);
            if (node != this.root && treePath.indexOf(node) < size - 1) {
                parentNode = treePath.get(treePath.indexOf(node) + 1);
            }
            if (balFactor > 1) {
                if (this.getBalance(node.right) <= -1) {
                    this.rotateSingleRight(node.right, node);
                    this.rotateSingleLeft(node, parentNode);
                    continue;
                }
                this.rotateSingleLeft(node, parentNode);
                continue;
            }
            if (balFactor >= -1) continue;
            if (this.getBalance(node.left) >= 1) {
                this.rotateSingleLeft(node.left, node);
                this.rotateSingleRight(node, parentNode);
                continue;
            }
            this.rotateSingleRight(node, parentNode);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    void setSize(int size) {
        this.size = size;
    }

    void setRoot(LinkedAvlNode<K> root) {
        this.root = root;
    }

    void setFirst(LinkedAvlNode<K> first) {
        this.first = first;
        ++this.size;
    }

    void setLast(LinkedAvlNode<K> last) {
        this.last = last;
    }

    @Override
    public LinkedAvlNode<K> getRoot() {
        return this.root;
    }

    @Override
    public List<K> getKeys() {
        ArrayList keys = new ArrayList();
        LinkedAvlNode<Object> node = this.first;
        while (node != null) {
            keys.add(node.key);
            node = node.next;
        }
        return keys;
    }

    @Override
    public void printTree() {
        if (this.isEmpty()) {
            System.out.println("Tree is empty");
            return;
        }
        this.getRoot().setDepth(0);
        System.out.println(this.getRoot());
        this.visit(this.getRoot().getRight(), this.getRoot());
        this.visit(this.getRoot().getLeft(), this.getRoot());
    }

    @Override
    public LinkedAvlNode<K> getFirst() {
        return this.first;
    }

    @Override
    public LinkedAvlNode<K> getLast() {
        return this.last;
    }

    private void rotateSingleLeft(LinkedAvlNode<K> node, LinkedAvlNode<K> parentNode) {
        LinkedAvlNode temp = node.right;
        node.right = temp.left;
        temp.left = node;
        if (node == this.root) {
            this.root = temp;
        } else if (parentNode != null) {
            if (parentNode.left == node) {
                parentNode.left = temp;
            } else if (parentNode.right == node) {
                parentNode.right = temp;
            }
        }
    }

    private void rotateSingleRight(LinkedAvlNode<K> node, LinkedAvlNode<K> parentNode) {
        LinkedAvlNode temp = node.left;
        node.left = temp.right;
        temp.right = node;
        if (node == this.root) {
            this.root = temp;
        } else if (parentNode != null) {
            if (parentNode.left == node) {
                parentNode.left = temp;
            } else if (parentNode.right == node) {
                parentNode.right = temp;
            }
        } else if (this.root != null && this.root.left == node) {
            this.root.left = temp;
        }
    }

    private void detachNodes(LinkedAvlNode<K> node, LinkedAvlNode<K> parentNode) {
        if (parentNode != null) {
            if (node == parentNode.left) {
                parentNode.left = node.left;
            } else if (node == parentNode.right) {
                parentNode.right = node.left;
            }
        }
    }

    private void replaceNode(LinkedAvlNode<K> deleteNode, LinkedAvlNode<K> replaceNode, LinkedAvlNode<K> parentNode) {
        if (parentNode != null) {
            replaceNode.left = deleteNode.left;
            if (deleteNode == parentNode.left) {
                parentNode.left = replaceNode;
            } else if (deleteNode == parentNode.right) {
                parentNode.right = replaceNode;
            }
        }
    }

    private List<LinkedAvlNode<K>> find(K key, LinkedAvlNode<K> startNode, List<LinkedAvlNode<K>> path) {
        if (startNode == null) {
            return null;
        }
        path.add(0, startNode);
        int c = this.comparator.compare(key, startNode.key);
        if (c == 0) {
            return path;
        }
        if (c > 0) {
            return this.find(key, startNode.right, path);
        }
        if (c < 0) {
            return this.find(key, startNode.left, path);
        }
        return null;
    }

    @Override
    public LinkedAvlNode<K> findGreater(K key) {
        LinkedAvlNode<K> result = this.fetchNonNullNode(key, this.root, this.root);
        if (result == null) {
            return null;
        }
        if (this.comparator.compare(key, result.key) < 0) {
            return result;
        }
        return result.next;
    }

    @Override
    public LinkedAvlNode<K> findGreaterOrEqual(K key) {
        LinkedAvlNode<K> result = this.fetchNonNullNode(key, this.root, this.root);
        if (result == null) {
            return null;
        }
        if (this.comparator.compare(key, result.key) <= 0) {
            return result;
        }
        return result.next;
    }

    @Override
    public LinkedAvlNode<K> findLess(K key) {
        LinkedAvlNode<K> result = this.fetchNonNullNode(key, this.root, this.root);
        if (result == null) {
            return null;
        }
        if (this.comparator.compare(key, result.key) > 0) {
            return result;
        }
        return result.previous;
    }

    @Override
    public LinkedAvlNode<K> findLessOrEqual(K key) {
        LinkedAvlNode<K> result = this.fetchNonNullNode(key, this.root, this.root);
        if (result == null) {
            return null;
        }
        if (this.comparator.compare(key, result.key) >= 0) {
            return result;
        }
        return result.previous;
    }

    private LinkedAvlNode<K> fetchNonNullNode(K key, LinkedAvlNode<K> startNode, LinkedAvlNode<K> parent) {
        if (startNode == null) {
            return parent;
        }
        int c = this.comparator.compare(key, startNode.key);
        parent = startNode;
        if (c > 0) {
            return this.fetchNonNullNode(key, startNode.right, parent);
        }
        if (c < 0) {
            return this.fetchNonNullNode(key, startNode.left, parent);
        }
        return startNode;
    }

    @Override
    public LinkedAvlNode<K> find(K key) {
        return this.find(key, this.root);
    }

    private LinkedAvlNode<K> find(K key, LinkedAvlNode<K> startNode) {
        if (startNode == null) {
            return null;
        }
        int c = this.comparator.compare(key, startNode.key);
        if (c > 0) {
            startNode.isLeft = false;
            return this.find(key, startNode.right);
        }
        if (c < 0) {
            startNode.isLeft = true;
            return this.find(key, startNode.left);
        }
        return startNode;
    }

    private List<LinkedAvlNode<K>> findMax(LinkedAvlNode<K> startNode) {
        LinkedAvlNode<Object> x = startNode;
        LinkedAvlNode<K> y = null;
        if (x == null) {
            return null;
        }
        while (x.right != null) {
            x.isLeft = false;
            y = x;
            x = x.right;
        }
        ArrayList<LinkedAvlNode<K>> path = new ArrayList<LinkedAvlNode<K>>(2);
        path.add(x);
        if (y != null) {
            path.add(y);
        }
        return path;
    }

    private List<LinkedAvlNode<K>> findMin(LinkedAvlNode<K> startNode) {
        LinkedAvlNode<Object> x = startNode;
        LinkedAvlNode<K> y = null;
        if (x == null) {
            return null;
        }
        while (x.left != null) {
            x.isLeft = true;
            y = x;
            x = x.left;
        }
        ArrayList<LinkedAvlNode<K>> path = new ArrayList<LinkedAvlNode<K>>(2);
        path.add(x);
        if (y != null) {
            path.add(y);
        }
        return path;
    }

    private int getBalance(LinkedAvlNode<K> node) {
        if (node == null) {
            return 0;
        }
        return node.getBalance();
    }

    private void visit(LinkedAvlNode<K> node, LinkedAvlNode<K> parentNode) {
        if (node == null) {
            return;
        }
        if (!node.isLeaf()) {
            node.setDepth(parentNode.getDepth() + 1);
        }
        for (int i = 0; i < parentNode.getDepth(); ++i) {
            System.out.print("|  ");
        }
        String type = "";
        if (node == parentNode.left) {
            type = "L";
        } else if (node == parentNode.right) {
            type = "R";
        }
        System.out.println("|--" + node + type);
        if (node.getRight() != null) {
            this.visit(node.getRight(), node);
        }
        if (node.getLeft() != null) {
            this.visit(node.getLeft(), node);
        }
    }
}

