/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.LinkedAvlNode;
import org.apache.directory.server.core.avltree.Position;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvlTreeCursor<E>
extends AbstractCursor<E> {
    private AvlTree<E> tree;
    private LinkedAvlNode<E> node;
    private Position position = Position.BEFORE_FIRST;

    public AvlTreeCursor(AvlTree<E> tree) {
        this.tree = tree;
    }

    @Override
    public void after(E element) throws Exception {
        this.checkNotClosed("after");
        if (element == null) {
            this.afterLast();
            return;
        }
        this.node = this.tree.findGreater(element);
        this.position = this.node == null ? Position.AFTER_LAST : Position.BEFORE_NODE;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast");
        this.node = null;
        this.position = Position.AFTER_LAST;
    }

    @Override
    public boolean available() {
        return this.position == Position.ON_NODE;
    }

    @Override
    public void before(E element) throws Exception {
        this.checkNotClosed("before");
        if (element == null) {
            this.beforeFirst();
            return;
        }
        this.node = this.tree.findLess(element);
        this.position = this.node == null ? Position.BEFORE_FIRST : Position.AFTER_NODE;
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst");
        this.node = null;
        this.position = Position.BEFORE_FIRST;
    }

    @Override
    public boolean first() throws Exception {
        this.checkNotClosed("first");
        this.node = this.tree.getFirst();
        if (this.node == null) {
            this.position = Position.BEFORE_FIRST;
            return false;
        }
        this.position = Position.ON_NODE;
        return true;
    }

    @Override
    public E get() throws Exception {
        this.checkNotClosed("get");
        if (this.position == Position.ON_NODE) {
            return this.node.getKey();
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean last() throws Exception {
        this.checkNotClosed("last");
        this.node = this.tree.getLast();
        if (this.node == null) {
            this.position = Position.AFTER_LAST;
            return false;
        }
        this.position = Position.ON_NODE;
        return true;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next");
        switch (this.position) {
            case BEFORE_FIRST: {
                return this.first();
            }
            case BEFORE_NODE: {
                this.position = Position.ON_NODE;
                return true;
            }
            case ON_NODE: 
            case AFTER_NODE: {
                this.node = this.node.next;
                if (this.node == null) {
                    this.afterLast();
                    return false;
                }
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_LAST: {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected position " + (Object)((Object)this.position));
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous");
        switch (this.position) {
            case BEFORE_FIRST: {
                return false;
            }
            case BEFORE_NODE: 
            case ON_NODE: {
                this.node = this.node.previous;
                if (this.node == null) {
                    this.beforeFirst();
                    return false;
                }
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_NODE: {
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_LAST: {
                return this.last();
            }
        }
        throw new IllegalStateException("Unexpected position " + (Object)((Object)this.position));
    }
}

