/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.aci.protectedItem.MaxValueCountElem;
import org.apache.directory.shared.ldap.aci.protectedItem.MaxValueCountItem;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxValueCountFilter
implements ACITupleFilter {
    @Override
    public Collection<ACITuple> filter(AciContext aciContext, OperationScope scope, Entry userEntry) throws LdapException {
        if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) {
            return aciContext.getAciTuples();
        }
        if (aciContext.getAciTuples().size() == 0) {
            return aciContext.getAciTuples();
        }
        Iterator<ACITuple> i = aciContext.getAciTuples().iterator();
        block0: while (i.hasNext()) {
            ACITuple tuple = i.next();
            if (!tuple.isGrant()) continue;
            for (ProtectedItem item : tuple.getProtectedItems()) {
                MaxValueCountItem mvc;
                if (!(item instanceof MaxValueCountItem) || !this.isRemovable(mvc = (MaxValueCountItem)item, aciContext.getAttributeType(), aciContext.getEntryView())) continue;
                i.remove();
                continue block0;
            }
        }
        return aciContext.getAciTuples();
    }

    private boolean isRemovable(MaxValueCountItem mvc, AttributeType attributeType, Entry entryView) throws LdapException {
        Iterator<MaxValueCountElem> k = mvc.iterator();
        while (k.hasNext()) {
            Attribute attr;
            int attrCount;
            MaxValueCountElem mvcItem = k.next();
            if (!attributeType.equals(mvcItem.getAttributeType()) || (attrCount = (attr = entryView.get(attributeType)) == null ? 0 : attr.size()) <= mvcItem.getMaxCount()) continue;
            return true;
        }
        return false;
    }
}

