/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.directory.server.core.admin.AdministrativePointInterceptor;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authz.AciAuthorizationInterceptor;
import org.apache.directory.server.core.authz.DefaultAuthorizationInterceptor;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.authz.support.HighestPrecedenceFilter;
import org.apache.directory.server.core.authz.support.MaxImmSubFilter;
import org.apache.directory.server.core.authz.support.MaxValueCountFilter;
import org.apache.directory.server.core.authz.support.MicroOperationFilter;
import org.apache.directory.server.core.authz.support.MostSpecificProtectedItemFilter;
import org.apache.directory.server.core.authz.support.MostSpecificUserClassFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.authz.support.RelatedProtectedItemFilter;
import org.apache.directory.server.core.authz.support.RelatedUserClassFilter;
import org.apache.directory.server.core.authz.support.RestrictedByFilter;
import org.apache.directory.server.core.event.EventInterceptor;
import org.apache.directory.server.core.event.ExpressionEvaluator;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.core.operational.OperationalAttributeInterceptor;
import org.apache.directory.server.core.schema.SchemaInterceptor;
import org.apache.directory.server.core.subtree.RefinementEvaluator;
import org.apache.directory.server.core.subtree.RefinementLeafEvaluator;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.core.subtree.SubtreeEvaluator;
import org.apache.directory.server.core.trigger.TriggerInterceptor;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public class ACDFEngine {
    private final ACITupleFilter[] filters;
    public static final Collection<String> USER_LOOKUP_BYPASS;

    public ACDFEngine(SchemaManager schemaManager) {
        ExpressionEvaluator entryEvaluator = new ExpressionEvaluator(schemaManager);
        SubtreeEvaluator subtreeEvaluator = new SubtreeEvaluator(schemaManager);
        RefinementEvaluator refinementEvaluator = new RefinementEvaluator(new RefinementLeafEvaluator(schemaManager));
        this.filters = new ACITupleFilter[]{new RelatedUserClassFilter(subtreeEvaluator), new RelatedProtectedItemFilter(refinementEvaluator, entryEvaluator, schemaManager), new MaxValueCountFilter(), new MaxImmSubFilter(schemaManager), new RestrictedByFilter(), new MicroOperationFilter(), new HighestPrecedenceFilter(), new MostSpecificUserClassFilter(), new MostSpecificProtectedItemFilter()};
    }

    public void checkPermission(AciContext aciContext) throws LdapException {
        if (!this.hasPermission(aciContext)) {
            throw new LdapNoPermissionException();
        }
    }

    public boolean hasPermission(AciContext aciContext) throws LdapException {
        if (aciContext.getEntryDn() == null) {
            throw new IllegalArgumentException("entryName");
        }
        Entry userEntry = aciContext.getOperationContext().lookup(aciContext.getUserDn(), USER_LOOKUP_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        OperationScope scope = aciContext.getAttributeType() == null ? OperationScope.ENTRY : (aciContext.getAttrValue() == null ? OperationScope.ATTRIBUTE_TYPE : OperationScope.ATTRIBUTE_TYPE_AND_VALUE);
        aciContext.setAciTuples(new ArrayList<ACITuple>(aciContext.getAciTuples()));
        for (ACITupleFilter filter : this.filters) {
            if (aciContext.getAciTuples().size() == 0) {
                return false;
            }
            aciContext.setAciTuples(filter.filter(aciContext, scope, userEntry));
        }
        if (aciContext.getAciTuples().size() == 0) {
            return false;
        }
        for (ACITuple tuple : aciContext.getAciTuples()) {
            if (tuple.isGrant()) continue;
            return false;
        }
        return true;
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add(NormalizationInterceptor.class.getName());
        c.add(AuthenticationInterceptor.class.getName());
        c.add(AciAuthorizationInterceptor.class.getName());
        c.add(DefaultAuthorizationInterceptor.class.getName());
        c.add(AdministrativePointInterceptor.class.getName());
        c.add(OperationalAttributeInterceptor.class.getName());
        c.add(SchemaInterceptor.class.getName());
        c.add(SubentryInterceptor.class.getName());
        c.add(EventInterceptor.class.getName());
        c.add(TriggerInterceptor.class.getName());
        USER_LOOKUP_BYPASS = Collections.unmodifiableCollection(c);
    }
}

