/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn.ppolicy;

import org.apache.directory.server.core.authn.ppolicy.PasswordPolicyException;
import org.apache.directory.server.core.authn.ppolicy.PasswordValidator;

public class DefaultPasswordValidator
implements PasswordValidator {
    public static final DefaultPasswordValidator INSTANCE = new DefaultPasswordValidator();

    public void validate(String password, String entryRdnVal) throws PasswordPolicyException {
        this.checkUsernameSubstring(password, entryRdnVal);
    }

    private void checkUsernameSubstring(String password, String username) throws PasswordPolicyException {
        if (username == null || username.trim().length() == 0) {
            return;
        }
        String[] tokens = username.split("[^a-zA-Z]");
        for (int ii = 0; ii < tokens.length; ++ii) {
            if (!password.matches("(?i).*" + tokens[ii] + ".*")) continue;
            throw new PasswordPolicyException("Password shouldn't contain parts of the username", 5);
        }
    }
}

