/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.jaas.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoginModule
implements LoginModule {
    private static final String USER_FILE = "org.apache.activemq.jaas.properties.user";
    private static final String GROUP_FILE = "org.apache.activemq.jaas.properties.group";
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean debug;
    private boolean reload = true;
    private static String usersFile;
    private static String groupsFile;
    private static Properties users;
    private static Properties groups;
    private String user;
    private Set<Principal> principals = new HashSet<Principal>();
    private File baseDir;
    private boolean loginSucceeded;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        FileInputStream in;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.loginSucceeded = false;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        if (options.get("reload") != null) {
            this.reload = "true".equalsIgnoreCase((String)options.get("reload"));
        }
        if (this.reload || users == null) {
            this.setBaseDir();
            usersFile = (String)options.get(USER_FILE) + "";
            File uf = new File(this.baseDir, usersFile);
            try {
                users = new Properties();
                in = new FileInputStream(uf);
                users.load(in);
                in.close();
            }
            catch (IOException ioe) {
                LOG.warn("Unable to load user properties file " + uf);
            }
            if (this.debug) {
                LOG.debug("Using usersFile=" + usersFile);
            }
        }
        if (this.reload || groups == null) {
            this.setBaseDir();
            groupsFile = (String)options.get(GROUP_FILE) + "";
            File gf = new File(this.baseDir, groupsFile);
            try {
                groups = new Properties();
                in = new FileInputStream(gf);
                groups.load(in);
                in.close();
            }
            catch (IOException ioe) {
                LOG.warn("Unable to load group properties file " + gf);
            }
            if (this.debug) {
                LOG.debug("Using groupsFile=" + groupsFile);
            }
        }
    }

    private void setBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("java.security.auth.login.config") != null ? new File(System.getProperty("java.security.auth.login.config")).getParentFile() : new File(".");
            if (this.debug) {
                LOG.debug("Using basedir=" + this.baseDir);
            }
        }
    }

    @Override
    public boolean login() throws LoginException {
        String password;
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if ((password = users.getProperty(this.user)) == null) {
            throw new FailedLoginException("User does exist");
        }
        if (!password.equals(new String(tmpPassword))) {
            throw new FailedLoginException("Password does not match");
        }
        this.loginSucceeded = true;
        if (this.debug) {
            LOG.debug("login " + this.user);
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean commit() throws LoginException {
        boolean result = this.loginSucceeded;
        if (result) {
            this.principals.add(new UserPrincipal(this.user));
            Enumeration<Object> enumeration = groups.keys();
            block0: while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String[] userList = (groups.getProperty(name) + "").split(",");
                for (int i = 0; i < userList.length; ++i) {
                    if (!this.user.equals(userList[i])) continue;
                    this.principals.add(new GroupPrincipal(name));
                    continue block0;
                }
            }
            this.subject.getPrincipals().addAll(this.principals);
        }
        this.clear();
        if (this.debug) {
            LOG.debug("commit, result: " + result);
        }
        return result;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            LOG.debug("abort");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        this.clear();
        if (this.debug) {
            LOG.debug("logout");
        }
        return true;
    }

    private void clear() {
        this.user = null;
        this.loginSucceeded = false;
    }
}

