/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.unit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.jndi.CoreContextFactory;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapService;
import org.apache.directory.server.ldap.handlers.bind.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.plain.PlainMechanismHandler;
import org.apache.directory.server.ldap.handlers.extended.StartTlsHandler;
import org.apache.directory.server.ldap.handlers.extended.StoredProcedureExtendedOperationHandler;
import org.apache.directory.server.protocol.shared.SocketAcceptor;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.mina.util.AvailablePortFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServerTest.class);
    private static final List<LdifEntry> EMPTY_LIST = Collections.unmodifiableList(new ArrayList(0));
    private static final String CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    protected LdapContext sysRoot;
    protected CoreSession rootDSE;
    protected LdapContext schemaRoot;
    protected boolean doDelete = true;
    protected int port = -1;
    private static int start;
    private static long t0;
    protected static int nbTests;
    protected DirectoryService directoryService;
    protected SocketAcceptor socketAcceptor;
    protected LdapService ldapService;

    protected List<LdifEntry> loadTestLdif(boolean verifyEntries) throws Exception {
        return this.loadLdif(((Object)((Object)this)).getClass().getResourceAsStream(((Object)((Object)this)).getClass().getSimpleName() + ".ldif"), verifyEntries);
    }

    protected List<LdifEntry> loadLdif(InputStream in, boolean verifyEntries) throws Exception {
        if (in == null) {
            return EMPTY_LIST;
        }
        LdifReader ldifReader = new LdifReader(in);
        ArrayList<LdifEntry> entries = new ArrayList<LdifEntry>();
        for (LdifEntry entry : ldifReader) {
            this.rootDSE.add((ServerEntry)new DefaultServerEntry(this.directoryService.getRegistries(), entry.getEntry()));
            if (verifyEntries) {
                this.verify(entry);
                LOG.info("Successfully verified addition of entry {}", (Object)entry.getDn());
            } else {
                LOG.info("Added entry {} without verification", (Object)entry.getDn());
            }
            entries.add(entry);
        }
        return entries;
    }

    protected void verify(LdifEntry entry) throws Exception {
        ClonedServerEntry readEntry = this.rootDSE.lookup(entry.getDn());
        for (EntryAttribute readAttribute : readEntry) {
            String id = readAttribute.getId();
            EntryAttribute origAttribute = entry.getEntry().get(id);
            for (Value value : origAttribute) {
                if (readAttribute.contains(new Value[]{value})) continue;
                LOG.error("Failed to verify entry addition of {}. {} attribute in original entry missing from read entry.", (Object)entry.getDn(), (Object)id);
                throw new AssertionFailedError("Failed to verify entry addition of " + entry.getDn());
            }
        }
    }

    protected LdapContext getWiredContext() throws Exception {
        return this.getWiredContext("uid=admin,ou=system", "secret");
    }

    protected LdapContext getWiredContext(String bindPrincipalDn, String password) throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CTX_FACTORY);
        env.put("java.naming.provider.url", "ldap://localhost:" + this.port);
        env.put("java.naming.security.principal", bindPrincipalDn);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.authentication", "simple");
        return new InitialLdapContext(env, null);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (start == 0) {
            t0 = System.currentTimeMillis();
        }
        ++start;
        this.directoryService = new DefaultDirectoryService();
        this.directoryService.setShutdownHookEnabled(false);
        this.socketAcceptor = new SocketAcceptor(null);
        this.ldapService = new LdapService();
        this.ldapService.setSocketAcceptor(this.socketAcceptor);
        this.ldapService.setDirectoryService(this.directoryService);
        this.port = AvailablePortFinder.getNextAvailable((int)1024);
        this.ldapService.setIpPort(this.port);
        this.setupSaslMechanisms(this.ldapService);
        this.doDelete(this.directoryService.getWorkingDirectory());
        this.configureDirectoryService();
        this.directoryService.startup();
        this.configureLdapServer();
        this.ldapService.addExtendedOperationHandler((ExtendedOperationHandler)new StartTlsHandler());
        this.ldapService.addExtendedOperationHandler((ExtendedOperationHandler)new StoredProcedureExtendedOperationHandler());
        this.ldapService.start();
        this.setContexts("uid=admin,ou=system", "secret");
    }

    private void setupSaslMechanisms(LdapService server) {
        HashMap<String, Object> mechanismHandlerMap = new HashMap<String, Object>();
        mechanismHandlerMap.put("PLAIN", new PlainMechanismHandler());
        CramMd5MechanismHandler cramMd5MechanismHandler = new CramMd5MechanismHandler();
        mechanismHandlerMap.put("CRAM-MD5", cramMd5MechanismHandler);
        DigestMd5MechanismHandler digestMd5MechanismHandler = new DigestMd5MechanismHandler();
        mechanismHandlerMap.put("DIGEST-MD5", digestMd5MechanismHandler);
        GssapiMechanismHandler gssapiMechanismHandler = new GssapiMechanismHandler();
        mechanismHandlerMap.put("GSSAPI", gssapiMechanismHandler);
        NtlmMechanismHandler ntlmMechanismHandler = new NtlmMechanismHandler();
        mechanismHandlerMap.put("NTLM", ntlmMechanismHandler);
        mechanismHandlerMap.put("GSS-SPNEGO", ntlmMechanismHandler);
        this.ldapService.setSaslMechanismHandlers(mechanismHandlerMap);
    }

    protected void configureDirectoryService() throws Exception {
    }

    protected void configureLdapServer() {
    }

    protected void doDelete(File wkdir) throws IOException {
        if (this.doDelete) {
            if (wkdir.exists()) {
                FileUtils.deleteDirectory((File)wkdir);
            }
            if (wkdir.exists()) {
                throw new IOException("Failed to delete: " + wkdir);
            }
        }
    }

    protected void setContexts(String user, String passwd) throws Exception {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put(DirectoryService.JNDI_KEY, this.directoryService);
        env.put("java.naming.security.principal", user);
        env.put("java.naming.security.credentials", passwd);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", CoreContextFactory.class.getName());
        this.setContexts(env);
    }

    protected void setContexts(Hashtable<String, Object> env) throws Exception {
        Hashtable<String, Object> envFinal = new Hashtable<String, Object>(env);
        envFinal.put("java.naming.provider.url", "ou=system");
        this.sysRoot = new InitialLdapContext(envFinal, null);
        envFinal.put("java.naming.provider.url", "");
        this.rootDSE = this.directoryService.getAdminSession();
        envFinal.put("java.naming.provider.url", "ou=schema");
        this.schemaRoot = new InitialLdapContext(envFinal, null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.ldapService.stop();
        try {
            this.directoryService.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sysRoot = null;
    }

    protected void importLdif(InputStream in) throws NamingException {
        try {
            for (LdifEntry ldifEntry : new LdifReader(in)) {
                this.rootDSE.add((ServerEntry)new DefaultServerEntry(this.rootDSE.getDirectoryService().getRegistries(), ldifEntry.getEntry()));
            }
        }
        catch (Exception e) {
            String msg = "failed while trying to parse system ldif file";
            LdapConfigurationException ne = new LdapConfigurationException(msg);
            ne.setRootCause(e);
            throw ne;
        }
    }

    protected void injectEntries(String ldif) throws Exception {
        LdifReader reader = new LdifReader();
        List entries = reader.parseLdif(ldif);
        for (LdifEntry entry : entries) {
            this.rootDSE.add((ServerEntry)new DefaultServerEntry(this.rootDSE.getDirectoryService().getRegistries(), entry.getEntry()));
        }
    }

    static {
        nbTests = 10000;
    }
}

