/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.unit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.configuration.MutableServerStartupConfiguration;
import org.apache.directory.server.core.configuration.ShutdownConfiguration;
import org.apache.directory.server.jndi.ServerContextFactory;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.ldif.Entry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.mina.util.AvailablePortFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerTest
extends TestCase {
    protected LdapContext sysRoot;
    protected LdapContext rootDSE;
    protected boolean doDelete = true;
    protected MutableServerStartupConfiguration configuration = new MutableServerStartupConfiguration();
    protected int port = -1;

    protected void setUp() throws Exception {
        super.setUp();
        this.doDelete(this.configuration.getWorkingDirectory());
        this.port = AvailablePortFinder.getNextAvailable((int)1024);
        this.configuration.setLdapPort(this.port);
        this.configuration.setShutdownHookEnabled(false);
        this.setContexts("uid=admin,ou=system", "secret");
    }

    protected void doDelete(File wkdir) throws IOException {
        if (this.doDelete) {
            if (wkdir.exists()) {
                FileUtils.deleteDirectory((File)wkdir);
            }
            if (wkdir.exists()) {
                throw new IOException("Failed to delete: " + wkdir);
            }
        }
    }

    protected void setContexts(String user, String passwd) throws NamingException {
        Hashtable<String, Object> env = new Hashtable<String, Object>(this.configuration.toJndiEnvironment());
        env.put("java.naming.security.principal", user);
        env.put("java.naming.security.credentials", passwd);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", ServerContextFactory.class.getName());
        this.setContexts(env);
    }

    protected void setContexts(Hashtable<String, Object> env) throws NamingException {
        Hashtable<String, Object> envFinal = new Hashtable<String, Object>(env);
        envFinal.put("java.naming.provider.url", "ou=system");
        this.sysRoot = new InitialLdapContext(envFinal, null);
        envFinal.put("java.naming.provider.url", "");
        this.rootDSE = new InitialLdapContext(envFinal, null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ou=system");
        env.put("java.naming.factory.initial", "org.apache.directory.server.jndi.ServerContextFactory");
        env.putAll(new ShutdownConfiguration().toJndiEnvironment());
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        try {
            new InitialContext(env);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sysRoot = null;
        this.doDelete(this.configuration.getWorkingDirectory());
        this.configuration = new MutableServerStartupConfiguration();
    }

    protected void importLdif(InputStream in) throws NamingException {
        try {
            LdifReader iterator = new LdifReader(in);
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                LdapDN dn = new LdapDN(entry.getDn());
                this.rootDSE.createSubcontext((Name)dn, entry.getAttributes());
            }
        }
        catch (Exception e) {
            String msg = "failed while trying to parse system ldif file";
            LdapConfigurationException ne = new LdapConfigurationException(msg);
            ne.setRootCause(e);
            throw ne;
        }
    }
}

