/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integ;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.util.JndiUtils;
import org.apache.directory.api.util.Network;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerIntegrationUtils
extends IntegrationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServerIntegrationUtils.class);
    private static final String CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final int DEFAULT_PORT = 10389;
    private static final String DEFAULT_ADMIN = "uid=admin,ou=system";
    private static final String DEFAULT_PASSWORD = "secret";

    private static Hashtable<String, Object> setDefaultJNDIEnv(String factoryName, LdapServer ldapServer) {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put(DirectoryService.JNDI_KEY, ldapServer.getDirectoryService());
        env.put("java.naming.provider.url", Network.ldapLoopbackUrl((int)ldapServer.getPort()));
        env.put("java.naming.security.principal", DEFAULT_ADMIN);
        env.put("java.naming.security.credentials", DEFAULT_PASSWORD);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", factoryName);
        return env;
    }

    public static LdapContext getWiredContext(LdapServer ldapServer) throws NamingException {
        return ServerIntegrationUtils.getWiredContext(ldapServer, null);
    }

    public static LdapContext getWiredContext(LdapServer ldapServer, String principalDn, String password) throws NamingException {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapServer.getPort());
        Hashtable<String, Object> env = ServerIntegrationUtils.setDefaultJNDIEnv(CTX_FACTORY, ldapServer);
        env.put("java.naming.security.principal", principalDn);
        env.put("java.naming.security.credentials", password);
        return new InitialLdapContext(env, null);
    }

    public static LdapContext getWiredContext(LdapServer ldapServer, Control[] controls) throws NamingException {
        javax.naming.ldap.Control[] jndiControls;
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapServer.getPort());
        Hashtable<String, Object> env = ServerIntegrationUtils.setDefaultJNDIEnv(CTX_FACTORY, ldapServer);
        try {
            jndiControls = JndiUtils.toJndiControls((LdapApiService)ldapServer.getDirectoryService().getLdapCodecService(), (Control[])controls);
        }
        catch (EncoderException ee) {
            throw new NamingException(ee.getMessage());
        }
        return new InitialLdapContext(env, jndiControls);
    }

    public static LdapContext getWiredContextThrowOnRefferal(LdapServer ldapServer) throws NamingException {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapServer.getPort());
        Hashtable<String, Object> env = ServerIntegrationUtils.setDefaultJNDIEnv(CTX_FACTORY, ldapServer);
        env.put("java.naming.referral", "throw");
        return new InitialLdapContext(env, null);
    }

    public static LdapContext getWiredContextRefferalIgnore(LdapServer ldapServer) throws NamingException {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapServer.getPort());
        Hashtable<String, Object> env = ServerIntegrationUtils.setDefaultJNDIEnv(CTX_FACTORY, ldapServer);
        env.put("java.naming.referral", "ignore");
        return new InitialLdapContext(env, null);
    }

    public static LdapContext getWiredContextFollowOnRefferal(LdapServer ldapServer) throws NamingException {
        LOG.debug("Creating a wired context to local LDAP server on port {}", (Object)ldapServer.getPort());
        Hashtable<String, Object> env = ServerIntegrationUtils.setDefaultJNDIEnv(CTX_FACTORY, ldapServer);
        env.put("java.naming.referral", "follow");
        return new InitialLdapContext(env, null);
    }

    public static LdapConnection getWiredConnection(LdapServer ldapServer) throws LdapException {
        String testServer = System.getProperty("ldap.test.server", null);
        if (testServer == null) {
            return ServerIntegrationUtils.getWiredConnection(ldapServer, DEFAULT_ADMIN, DEFAULT_PASSWORD);
        }
        LOG.debug("ldap.test.server = {}", (Object)testServer);
        String admin = System.getProperty(testServer + ".admin", DEFAULT_ADMIN);
        LOG.debug("{}.admin = {}", (Object)testServer, (Object)admin);
        String password = System.getProperty(testServer + ".password", DEFAULT_PASSWORD);
        LOG.debug("{}.password = {}", (Object)testServer, (Object)password);
        String host = System.getProperty(testServer + ".host", Network.LOOPBACK_HOSTNAME);
        LOG.debug("{}.host = {}", (Object)testServer, (Object)host);
        int port = Integer.parseInt(System.getProperty(testServer + ".port", Integer.toString(10389)));
        LOG.debug("{}.port = {}", (Object)testServer, (Object)port);
        LdapNetworkConnection conn = new LdapNetworkConnection(host, port);
        conn.bind(admin, password);
        return conn;
    }

    public static LDAPConnection getNsdkWiredConnection(LdapServer ldapServer) throws LDAPException {
        String testServer = System.getProperty("ldap.test.server", null);
        if (testServer == null) {
            return ServerIntegrationUtils.getNsdkWiredConnection(ldapServer, DEFAULT_ADMIN, DEFAULT_PASSWORD);
        }
        LOG.debug("ldap.test.server = {}", (Object)testServer);
        String admin = System.getProperty(testServer + ".admin", DEFAULT_ADMIN);
        LOG.debug("{}.admin = {}", (Object)testServer, (Object)admin);
        String password = System.getProperty(testServer + ".password", DEFAULT_PASSWORD);
        LOG.debug("{}.password = {}", (Object)testServer, (Object)password);
        String host = System.getProperty(testServer + ".host", Network.LOOPBACK_HOSTNAME);
        LOG.debug("{}.host = {}", (Object)testServer, (Object)host);
        int port = Integer.parseInt(System.getProperty(testServer + ".port", Integer.toString(10389)));
        LOG.debug("{}.port = {}", (Object)testServer, (Object)port);
        LDAPConnection conn = new LDAPConnection();
        conn.connect(3, host, port, admin, password);
        return conn;
    }

    public static LdapConnection getWiredConnection(LdapServer ldapServer, String principalDn, String password) throws LdapException {
        LdapNetworkConnection connection = new LdapNetworkConnection(Network.LOOPBACK_HOSTNAME, ldapServer.getPort());
        connection.bind(principalDn, password);
        return connection;
    }

    public static LdapConnection getLdapConnection(LdapServer ldapServer) {
        return new LdapNetworkConnection(Network.LOOPBACK_HOSTNAME, ldapServer.getPort());
    }

    public static LDAPConnection getNsdkWiredConnection(LdapServer ldapServer, String principalDn, String password) throws LDAPException {
        LDAPConnection connection = new LDAPConnection();
        connection.connect(3, Network.LOOPBACK_HOSTNAME, ldapServer.getPort(), principalDn, password);
        return connection;
    }

    public static LdapConnection getAdminConnection(LdapServer ldapServer) throws LdapException {
        LdapNetworkConnection connection = new LdapNetworkConnection(Network.LOOPBACK_HOSTNAME, ldapServer.getPort());
        connection.bind(DEFAULT_ADMIN, DEFAULT_PASSWORD);
        return connection;
    }
}

