/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.modifydn;

import javax.naming.ReferralException;
import javax.naming.ldap.LdapContext;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.controls.ManageDsaITImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: uid=akarasulu,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: akarasulu", "cn: Alex Karasulu", "sn: karasulu", "dn: ou=Computers,uid=akarasulu,ou=users,ou=system", "objectClass: organizationalUnit", "objectClass: top", "ou: computers", "description: Computers for Alex", "seeAlso: ou=Machines,uid=akarasulu,ou=users,ou=system", "dn: uid=akarasuluref,ou=users,ou=system", "objectClass: uidObject", "objectClass: referral", "objectClass: top", "uid: akarasuluref", "ref: ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://foo:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://bar:10389/uid=akarasulu,ou=users,ou=system", "dn: uid=elecharny,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: elecharny", "cn: Emmanuel Lecharny", "sn: lecharny"})
public class ModifyDnReferralIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final Logger LOG = LoggerFactory.getLogger(ModifyDnReferralIT.class);

    @Test
    public void testOnReferralWithManageDsaITControl() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)ModifyDnReferralIT.getLdapServer());
        ManageDsaITImpl manageDSAIT = new ManageDsaITImpl();
        manageDSAIT.setCritical(true);
        ModifyDnRequestImpl modifyDnRequest = new ModifyDnRequestImpl();
        modifyDnRequest.setName(new Dn(new String[]{"uid=akarasuluref,ou=users,ou=system"}));
        modifyDnRequest.setNewRdn(new Rdn("uid=ref"));
        modifyDnRequest.setDeleteOldRdn(true);
        modifyDnRequest.addControl((Control)manageDSAIT);
        conn.modifyDn((ModifyDnRequest)modifyDnRequest);
        Entry entry = conn.lookup("uid=ref,ou=users,ou=system", new Control[]{manageDSAIT}, new String[0]);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"uid=ref,ou=users,ou=system", (Object)entry.getDn().getName());
        conn.close();
    }

    @Test
    public void testNewSuperiorOnReferralWithManageDsaITControl() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)ModifyDnReferralIT.getLdapServer());
        ManageDsaITImpl manageDSAIT = new ManageDsaITImpl();
        manageDSAIT.setCritical(true);
        ModifyDnRequestImpl modifyDnRequest = new ModifyDnRequestImpl();
        modifyDnRequest.setName(new Dn(new String[]{"uid=elecharny,ou=users,ou=system"}));
        modifyDnRequest.setNewRdn(new Rdn("uid=newuser"));
        modifyDnRequest.setNewSuperior(new Dn(new String[]{"uid=akarasuluref,ou=users,ou=system"}));
        modifyDnRequest.setDeleteOldRdn(true);
        modifyDnRequest.addControl((Control)manageDSAIT);
        try {
            conn.modifyDn((ModifyDnRequest)modifyDnRequest);
        }
        catch (LdapOperationException le) {
            Assert.assertEquals((Object)ResultCodeEnum.AFFECTS_MULTIPLE_DSAS, (Object)le.getResultCode());
        }
        conn.close();
    }

    @Test
    public void testOnReferral() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)ModifyDnReferralIT.getLdapServer());
        ModifyDnRequestImpl modifyDnRequest = new ModifyDnRequestImpl();
        modifyDnRequest.setName(new Dn(new String[]{"uid=akarasuluref,ou=users,ou=system"}));
        modifyDnRequest.setNewRdn(new Rdn("uid=ref"));
        modifyDnRequest.setDeleteOldRdn(true);
        ModifyDnResponse modifyDnResponse = conn.modifyDn((ModifyDnRequest)modifyDnRequest);
        Assert.assertEquals((Object)ResultCodeEnum.REFERRAL, (Object)modifyDnResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)modifyDnResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://localhost:10389/uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)modifyDnResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://foo:10389/uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)modifyDnResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://bar:10389/uid=akarasulu,ou=users,ou=system"));
        conn.close();
    }

    @Test
    public void testNewSuperiorOnReferral() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)ModifyDnReferralIT.getLdapServer());
        try {
            conn.moveAndRename("uid=elecharny,ou=users,ou=system", "uid=ref,uid=akarasuluref,ou=users,ou=system", true);
        }
        catch (LdapOperationException e) {
            Assert.assertEquals((Object)ResultCodeEnum.AFFECTS_MULTIPLE_DSAS, (Object)e.getResultCode());
        }
        conn.close();
    }

    @Test
    public void testThrowOnReferralWithJndi() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)ModifyDnReferralIT.getLdapServer());
        try {
            ctx.rename("uid=akarasuluref,ou=users,ou=system", "uid=ref,ou=users,ou=system");
            Assert.fail((String)"Should never get here due to ModifyDN failure on ReferralException");
        }
        catch (ReferralException e) {
            Assert.assertEquals((Object)"ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", (Object)e.getReferralInfo());
        }
        ctx.close();
    }

    @Test
    public void testAncestorReferral() throws Exception {
        LOG.debug("");
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)ModifyDnReferralIT.getLdapServer());
        ModifyDnRequestImpl modifyDnRequest = new ModifyDnRequestImpl();
        modifyDnRequest.setName(new Dn(new String[]{"ou=Computers,uid=akarasuluref,ou=users,ou=system"}));
        modifyDnRequest.setNewRdn(new Rdn("ou=Machines"));
        modifyDnRequest.setDeleteOldRdn(true);
        ModifyDnResponse modifyDnResponse = conn.modifyDn((ModifyDnRequest)modifyDnRequest);
        Assert.assertEquals((Object)ResultCodeEnum.REFERRAL, (Object)modifyDnResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)modifyDnResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://localhost:10389/ou=Computers,uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)modifyDnResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://foo:10389/ou=Computers,uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)modifyDnResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://bar:10389/ou=Computers,uid=akarasulu,ou=users,ou=system"));
        conn.close();
    }

    @Test
    public void testNewSuperiorAncestorReferral() throws Exception {
        LOG.debug("");
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)ModifyDnReferralIT.getLdapServer());
        try {
            conn.moveAndRename("uid=elecharny,ou=users,ou=system", "ou=Machines,ou=Computers,uid=akarasuluref,ou=users,ou=system", true);
            Assert.fail((String)"Should never get here to affectsMultipleDSA error result code");
        }
        catch (LdapOperationException e) {
            Assert.assertEquals((Object)ResultCodeEnum.AFFECTS_MULTIPLE_DSAS, (Object)e.getResultCode());
        }
        conn.close();
    }
}

