/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.replication;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.MockDirectoryService;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.replication.ReplicationConsumerConfig;
import org.apache.directory.server.ldap.replication.SyncreplConfiguration;
import org.apache.directory.server.ldap.replication.consumer.ReplicationConsumer;
import org.apache.directory.server.ldap.replication.provider.ReplicationRequestHandler;
import org.apache.directory.server.ldap.replication.provider.SyncReplRequestHandler;
import org.apache.directory.server.replication.MockSyncReplConsumer;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.message.SearchRequestImpl;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class ClientInitialRefreshIT {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static LdapServer providerServer;
    private static SchemaManager schemaManager;
    private static CoreSession providerSession;
    private static AtomicInteger entryCount;

    @BeforeClass
    public static void setUp() throws Exception {
        Class<?> justLoadToSetControlProperties = Class.forName(FrameworkRunner.class.getName());
        ClientInitialRefreshIT.startProvider();
        for (int i = 0; i < 1000; ++i) {
            Entry entry = ClientInitialRefreshIT.createEntry();
            providerSession.add(entry);
        }
    }

    @AfterClass
    public static void tearDown() {
        providerServer.stop();
    }

    private boolean checkEntryExistence(CoreSession session, Dn entryDn) throws Exception {
        boolean replicated = false;
        for (int i = 0; i < 100; ++i) {
            Thread.sleep(100L);
            if (!session.exists(entryDn)) continue;
            replicated = true;
            break;
        }
        return replicated;
    }

    private void waitAndCompareEntries(Dn dn) throws Exception {
        Entry providerEntry = providerSession.lookup(dn, new String[]{"*", "+"});
    }

    private static Entry createEntry() throws Exception {
        String user = "user" + entryCount.incrementAndGet();
        String dn = "cn=" + user + ",dc=example,dc=com";
        DefaultEntry entry = new DefaultEntry(schemaManager, dn, new Object[]{"objectClass", "person", "cn", user, "sn", user});
        return entry;
    }

    @CreateDS(allowAnonAccess=true, name="provider-replication", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")}, contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\nobjectClass: domain\ndc: example"))})
    @CreateLdapServer(transports={@CreateTransport(port=16000, protocol="LDAP")})
    public static void startProvider() throws Exception {
        DirectoryService provDirService = DSAnnotationProcessor.getDirectoryService();
        providerServer = ServerAnnotationProcessor.getLdapServer((DirectoryService)provDirService);
        providerServer.setReplicationReqHandler((ReplicationRequestHandler)new SyncReplRequestHandler());
        providerServer.startReplicationProducer();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    schemaManager = providerServer.getDirectoryService().getSchemaManager();
                    providerSession = providerServer.getDirectoryService().getAdminSession();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
        t.join();
    }

    private boolean waitForSyncReplClient(ReplicationConsumer consumer, int expected) throws Exception {
        System.out.println("\nNbAdded every 100ms : ");
        boolean isFirst = true;
        for (int i = 0; i < 50; ++i) {
            int nbAdded = ((MockSyncReplConsumer)consumer).getNbAdded();
            if (isFirst) {
                isFirst = false;
            } else {
                System.out.print(", ");
            }
            System.out.print(nbAdded);
            if (nbAdded == expected) {
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    private boolean waitUntilLimitSyncReplClient(int limit, ReplicationConsumer ... consumers) throws Exception {
        System.out.println("\nCompleted so far : ");
        boolean isFirst = true;
        int nbConsumers = consumers.length;
        int[] nbAddeds = new int[nbConsumers];
        int nbCompleted = 0;
        for (int i = 0; i < 50; ++i) {
            for (int j = 0; j < nbConsumers; ++j) {
                if (nbAddeds[j] == limit) continue;
                nbAddeds[j] = ((MockSyncReplConsumer)consumers[j]).getNbAdded();
                if (nbAddeds[j] < limit) continue;
                ++nbCompleted;
                System.out.println("(consumer" + (j + 1) + " completed) ");
            }
            if (nbCompleted == nbConsumers) {
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    private ReplicationConsumer createConsumer() throws Exception {
        final MockSyncReplConsumer syncreplClient = new MockSyncReplConsumer();
        final SyncreplConfiguration config = new SyncreplConfiguration();
        config.setRemoteHost("localhost");
        config.setRemotePort(16000);
        config.setReplUserDn("uid=admin,ou=system");
        config.setReplUserPassword("secret".getBytes());
        config.setUseTls(false);
        config.setBaseDn("dc=example,dc=com");
        config.setRefreshInterval(1000L);
        syncreplClient.setConfig((ReplicationConsumerConfig)config);
        Assert.assertTrue((boolean)true);
        Runnable consumerTask = new Runnable(){

            @Override
            public void run() {
                try {
                    String baseDn = config.getBaseDn();
                    SearchRequestImpl searchRequest = new SearchRequestImpl();
                    searchRequest.setBase(new Dn(new String[]{baseDn}));
                    searchRequest.setFilter(config.getFilter());
                    searchRequest.setSizeLimit((long)config.getSearchSizeLimit());
                    searchRequest.setTimeLimit(config.getSearchTimeout());
                    searchRequest.setDerefAliases(config.getAliasDerefMode());
                    searchRequest.setScope(config.getSearchScope());
                    searchRequest.setTypesOnly(false);
                    searchRequest.addAttributes(config.getAttributes());
                    MockDirectoryService directoryService = new MockDirectoryService();
                    directoryService.setSchemaManager(schemaManager);
                    ((MockSyncReplConsumer)syncreplClient).init((DirectoryService)directoryService);
                    syncreplClient.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Thread consumerThread = new Thread(consumerTask);
        consumerThread.setDaemon(true);
        consumerThread.start();
        return syncreplClient;
    }

    private void runConsumer(final ReplicationConsumer consumer) throws Exception {
        Runnable consumerTask = new Runnable(){

            @Override
            public void run() {
                try {
                    consumer.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Thread consumerThread = new Thread(consumerTask);
        consumerThread.setDaemon(true);
        consumerThread.start();
    }

    @Test
    public void testInitialRefreshLoad() throws Exception {
        System.out.println("\n---> Running testInitialRefreshLoad");
        ReplicationConsumer consumer = this.createConsumer();
        Assert.assertTrue((boolean)this.waitForSyncReplClient(consumer, 1001));
        consumer.stop();
        System.out.println("\n<-- Done");
    }

    @Test
    public void testInitialRefreshLoadAndAdd() throws Exception {
        System.out.println("\n---> Running testInitialRefreshLoadAndAdd");
        ReplicationConsumer consumer = this.createConsumer();
        Assert.assertTrue((boolean)this.waitForSyncReplClient(consumer, 1001));
        Entry addedEntry = ClientInitialRefreshIT.createEntry();
        providerSession.add(addedEntry);
        ((MockSyncReplConsumer)consumer).resetNbAdded();
        Assert.assertTrue((boolean)this.waitForSyncReplClient(consumer, 1));
        providerSession.delete(addedEntry.getDn());
        consumer.stop();
        System.out.println("\n<-- Done");
    }

    @Test
    public void testInitialRefreshStopAndGo() throws Exception {
        System.out.println("\n---> Running testInitialRefreshStopAndGo");
        ReplicationConsumer consumer = this.createConsumer();
        this.waitUntilLimitSyncReplClient(200, consumer);
        consumer.stop();
        this.runConsumer(consumer);
        Assert.assertTrue((boolean)this.waitForSyncReplClient(consumer, 1001));
        consumer.stop();
        System.out.println("\n<-- Done");
    }

    @Test
    public void testInitialRefresh4Consumers() throws Exception {
        System.out.println("\n--->Running testInitialRefresh4Consumers");
        ReplicationConsumer consumer1 = this.createConsumer();
        ReplicationConsumer consumer2 = this.createConsumer();
        ReplicationConsumer consumer3 = this.createConsumer();
        ReplicationConsumer consumer4 = this.createConsumer();
        Assert.assertTrue((boolean)this.waitUntilLimitSyncReplClient(1001, consumer1, consumer2, consumer3, consumer4));
        consumer1.stop();
        consumer2.stop();
        consumer3.stop();
        consumer4.stop();
        System.out.println("\n<-- Done");
    }

    static {
        entryCount = new AtomicInteger();
    }
}

