/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.ldapsdk;

import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.shared.ldap.model.message.ModifyResponse;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: cn=Kate Bush,ou=system", "objectClass: person", "objectClass: top", "cn: Kate Bush", "sn: Bush"})
public class IllegalModificationIT
extends AbstractLdapTestUnit {
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final String DN = "cn=Kate Bush,ou=system";

    @Test
    public void testIllegalModification() throws Exception {
        LdapConnection con = ServerIntegrationUtils.getAdminConnection((LdapServer)IllegalModificationIT.getLdapServer());
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(new Dn(new String[]{DN}));
        modReq.add("description", new String[]{""});
        ModifyResponse resp = con.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, (Object)resp.getLdapResult().getResultCode());
        Entry entry = con.lookup(DN);
        Assert.assertEquals((String)"description exists?", null, (Object)entry.get("description"));
        con.close();
    }

    @Test
    public void testIllegalModification2() throws Exception {
        LDAPConnection con = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)IllegalModificationIT.getLdapServer());
        LDAPAttribute attr = new LDAPAttribute("description", "The description");
        LDAPModification mod = new LDAPModification(0, attr);
        attr = new LDAPAttribute("displayName");
        LDAPModification mod2 = new LDAPModification(0, attr);
        try {
            con.modify(DN, new LDAPModification[]{mod, mod2});
            Assert.fail((String)"error expected due to empty attribute value");
        }
        catch (LDAPException e) {
            // empty catch block
        }
        LDAPEntry entry = con.read(DN);
        Assert.assertEquals((String)"displayName exists?", null, (Object)entry.getAttribute("displayName"));
    }
}

