/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.search;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.ManageReferralControl;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.ldif.LdifReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: ou=RemoteUsers,ou=system", "objectClass: top", "objectClass: referral", "objectClass: extensibleObject", "ou: RemoteUsers", "ref: ldap://fermi:10389/ou=users,ou=system", "ref: ldap://hertz:10389/ou=users,dc=example,dc=com", "ref: ldap://maxwell:10389/ou=users,ou=system", "dn: c=France,ou=system", "objectClass: top", "objectClass: country", "c: France", "dn: c=USA,ou=system", "objectClass: top", "objectClass: country", "c: USA", "dn: l=Paris,c=france,ou=system", "objectClass: top", "objectClass: locality", "l: Paris", "dn: l=Jacksonville,c=usa,ou=system", "objectClass: top", "objectClass: locality", "l: Jacksonville", "dn: cn=emmanuel lecharny,l=paris,c=france,ou=system", "objectClass: top", "objectClass: person", "objectClass: residentialPerson", "cn: emmanuel lecharny", "sn: elecharny", "l: Paris", "dn: cn=alex karasulu,l=jacksonville,c=usa,ou=system", "objectClass: top", "objectClass: person", "objectClass: residentialPerson", "cn: alex karasulu", "sn: karasulu", "l: Jacksonville", "dn: ou=Countries,ou=system", "objectClass: top", "objectClass: organizationalUnit", "ou: Countries"})
public class ReferralSearchIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);

    @Before
    public void setupReferrals() throws Exception {
        String ldif = "dn: c=europ,ou=Countries,ou=system\nobjectClass: top\nobjectClass: referral\nobjectClass: extensibleObject\nc: europ\nref: ldap://localhost:" + ReferralSearchIT.getLdapServer().getPort() + "/c=france,ou=system\n\n" + "dn: c=america,ou=Countries,ou=system\n" + "objectClass: top\n" + "objectClass: referral\n" + "objectClass: extensibleObject\n" + "c: america\n" + "ref: ldap://localhost:" + ReferralSearchIT.getLdapServer().getPort() + "/c=usa,ou=system\n\n";
        LdifReader reader = new LdifReader((Reader)new StringReader(ldif));
        while (reader.hasNext()) {
            LdifEntry entry = reader.next();
            ReferralSearchIT.getLdapServer().getDirectoryService().getAdminSession().add((Entry)new DefaultEntry(ReferralSearchIT.getLdapServer().getDirectoryService().getSchemaManager(), entry.getEntry()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchBaseIsReferral() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)ReferralSearchIT.getLdapServer());
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        try {
            ctx.search("ou=RemoteUsers,ou=system", "(objectClass=*)", controls);
            Assert.fail((String)"should never get here");
        }
        catch (ReferralException e) {
            Assert.assertEquals((Object)"ldap://fermi:10389/ou=users,ou=system??sub", (Object)e.getReferralInfo());
            Assert.assertTrue((boolean)e.skipReferral());
            Assert.assertEquals((Object)"ldap://hertz:10389/ou=users,dc=example,dc=com??sub", (Object)e.getReferralInfo());
            Assert.assertTrue((boolean)e.skipReferral());
            Assert.assertEquals((Object)"ldap://maxwell:10389/ou=users,ou=system??sub", (Object)e.getReferralInfo());
            Assert.assertFalse((boolean)e.skipReferral());
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchBaseParentIsReferral() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)ReferralSearchIT.getLdapServer());
        SearchControls controls = new SearchControls();
        controls.setSearchScope(0);
        try {
            ctx.search("cn=alex karasulu,ou=RemoteUsers,ou=system", "(objectClass=*)", controls);
        }
        catch (ReferralException e) {
            Assert.assertEquals((Object)"ldap://fermi:10389/cn=alex%20karasulu,ou=users,ou=system??base", (Object)e.getReferralInfo());
            Assert.assertTrue((boolean)e.skipReferral());
            Assert.assertEquals((Object)"ldap://hertz:10389/cn=alex%20karasulu,ou=users,dc=example,dc=com??base", (Object)e.getReferralInfo());
            Assert.assertTrue((boolean)e.skipReferral());
            Assert.assertEquals((Object)"ldap://maxwell:10389/cn=alex%20karasulu,ou=users,ou=system??base", (Object)e.getReferralInfo());
            Assert.assertFalse((boolean)e.skipReferral());
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchBaseAncestorIsReferral() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)ReferralSearchIT.getLdapServer());
        SearchControls controls = new SearchControls();
        controls.setSearchScope(0);
        try {
            ctx.search("cn=alex karasulu,ou=apache,ou=RemoteUsers,ou=system", "(objectClass=*)", controls);
        }
        catch (ReferralException e) {
            Assert.assertEquals((Object)"ldap://fermi:10389/cn=alex%20karasulu,ou=apache,ou=users,ou=system??base", (Object)e.getReferralInfo());
            Assert.assertTrue((boolean)e.skipReferral());
            Assert.assertEquals((Object)"ldap://hertz:10389/cn=alex%20karasulu,ou=apache,ou=users,dc=example,dc=com??base", (Object)e.getReferralInfo());
            Assert.assertTrue((boolean)e.skipReferral());
            Assert.assertEquals((Object)"ldap://maxwell:10389/cn=alex%20karasulu,ou=apache,ou=users,ou=system??base", (Object)e.getReferralInfo());
            Assert.assertFalse((boolean)e.skipReferral());
        }
        finally {
            ctx.close();
        }
    }

    @Test
    public void testSearchContinuations() throws Exception {
        SearchResult result;
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)ReferralSearchIT.getLdapServer());
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        NamingEnumeration<SearchResult> list = ctx.search("ou=system", "(objectClass=*)", controls);
        HashMap<String, SearchResult> results = new HashMap<String, SearchResult>();
        while (list.hasMore()) {
            result = list.next();
            results.put(result.getName(), result);
        }
        Assert.assertNotNull(results.get("ou=users"));
        ctx.addToEnvironment("java.naming.referral", "throw");
        list = ctx.search("ou=system", "(objectClass=*)", controls);
        results = new HashMap();
        try {
            while (list.hasMore()) {
                result = list.next();
                results.put(result.getName(), result);
            }
        }
        catch (ReferralException e) {
            HashSet<Object> s = new HashSet<Object>();
            s.add(e.getReferralInfo());
            while (e.skipReferral()) {
                try {
                    Context ctx2 = e.getReferralContext();
                    ctx2.list("");
                }
                catch (NamingException ne) {
                    if (!(ne instanceof ReferralException)) break;
                    e = (ReferralException)ne;
                    s.add(e.getReferralInfo());
                }
            }
            Assert.assertEquals((long)5L, (long)s.size());
            Assert.assertTrue((boolean)s.contains("ldap://fermi:10389/ou=users,ou=system??sub"));
            Assert.assertTrue((boolean)s.contains("ldap://hertz:10389/ou=users,dc=example,dc=com??sub"));
            Assert.assertTrue((boolean)s.contains("ldap://maxwell:10389/ou=users,ou=system??sub"));
        }
        Assert.assertNull(results.get("ou=remoteusers"));
        list.close();
        controls.setSearchScope(1);
        list = ctx.search("ou=system", "(objectClass=*)", controls);
        results = new HashMap();
        try {
            while (list.hasMore()) {
                result = list.next();
                results.put(result.getName(), result);
            }
        }
        catch (ReferralException e) {
            Assert.assertEquals((Object)"ldap://fermi:10389/ou=users,ou=system??base", (Object)e.getReferralInfo());
            Assert.assertTrue((boolean)e.skipReferral());
            Assert.assertEquals((Object)"ldap://hertz:10389/ou=users,dc=example,dc=com??base", (Object)e.getReferralInfo());
            Assert.assertTrue((boolean)e.skipReferral());
            Assert.assertEquals((Object)"ldap://maxwell:10389/ou=users,ou=system??base", (Object)e.getReferralInfo());
        }
        list.close();
        ctx.close();
        Assert.assertNull(results.get("ou=remoteusers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchWithReferralThrow() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)ReferralSearchIT.getLdapServer());
        try {
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            ctx.search("c=america,ou=Countries,ou=system", "(cn=alex karasulu)", controls);
            Assert.fail((String)"Should fail here throwing a ReferralException");
        }
        catch (ReferralException re) {
            String referral = (String)re.getReferralInfo();
            Assert.assertEquals((Object)("ldap://localhost:" + ReferralSearchIT.getLdapServer().getPort() + "/c=usa,ou=system??sub"), (Object)referral);
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchBaseWithReferralThrow() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)ReferralSearchIT.getLdapServer());
        SearchControls controls = new SearchControls();
        controls.setSearchScope(0);
        try {
            ctx.search("c=america,ou=Countries,ou=system", "(cn=alex karasulu)", controls);
            Assert.fail((String)"Should fail here throwing a ReferralException");
        }
        catch (ReferralException re) {
            String referral = (String)re.getReferralInfo();
            Assert.assertEquals((Object)("ldap://localhost:" + ReferralSearchIT.getLdapServer().getPort() + "/c=usa,ou=system??base"), (Object)referral);
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchBaseWithReferralThrowAfterRename() throws Exception {
        String referral;
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)ReferralSearchIT.getLdapServer());
        SearchControls controls = new SearchControls();
        controls.setSearchScope(0);
        try {
            ctx.search("c=america,ou=Countries,ou=system", "(cn=alex karasulu)", controls);
            Assert.fail((String)"Should fail here throwing a ReferralException");
        }
        catch (ReferralException re) {
            referral = (String)re.getReferralInfo();
            Assert.assertEquals((Object)("ldap://localhost:" + ReferralSearchIT.getLdapServer().getPort() + "/c=usa,ou=system??base"), (Object)referral);
        }
        ctx.setRequestControls(new Control[]{new ManageReferralControl()});
        ctx.rename("c=america,ou=Countries,ou=system", "c=USA,ou=Countries,ou=system");
        controls.setSearchScope(0);
        ctx.setRequestControls(new Control[0]);
        try {
            ctx.search("c=usa,ou=Countries,ou=system", "(cn=alex karasulu)", controls);
            Assert.fail((String)"Should fail here throwing a ReferralException");
        }
        catch (ReferralException re) {
            referral = (String)re.getReferralInfo();
            Assert.assertEquals((Object)("ldap://localhost:" + ReferralSearchIT.getLdapServer().getPort() + "/c=usa,ou=system??base"), (Object)referral);
        }
        finally {
            ctx.close();
        }
    }
}

