/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.modify;

import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.shared.ldap.model.message.ModifyResponse;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: cn=Kate Bush,ou=system", "objectClass: person", "objectClass: top", "cn: Kate Bush", "sn: Bush"})
public class IllegalModificationIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final String DN = "cn=Kate Bush,ou=system";

    @Test
    public void testIllegalModification() throws Exception {
        LdapConnection con = ServerIntegrationUtils.getAdminConnection((LdapServer)IllegalModificationIT.getLdapServer());
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(new Dn(new String[]{DN}));
        modReq.add("description", new String[]{""});
        ModifyResponse resp = con.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, (Object)resp.getLdapResult().getResultCode());
        Entry entry = con.lookup(DN);
        Assert.assertEquals((String)"description exists?", null, (Object)entry.get("description"));
        con.close();
    }

    @Test
    public void testIllegalModification2() throws Exception {
        LdapConnection con = ServerIntegrationUtils.getWiredConnection((LdapServer)IllegalModificationIT.getLdapServer());
        DefaultModification mod = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "description", new String[]{"The description"});
        DefaultModification mod2 = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "displayName");
        try {
            con.modify(DN, new Modification[]{mod, mod2});
            Assert.fail((String)"error expected due to empty attribute value");
        }
        catch (LdapException e) {
            // empty catch block
        }
        Entry entry = con.lookup(DN);
        Assert.assertEquals((String)"displayName exists?", null, (Object)entry.get("displayName"));
    }
}

