/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.extended;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.ldap.handlers.bind.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.plain.PlainMechanismHandler;
import org.apache.directory.server.ldap.handlers.extended.StoredProcedureExtendedOperationHandler;
import org.apache.directory.server.operations.extended.HelloWorldProcedure;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.ldap.model.schema.normalizers.DeepTrimToLowerNormalizer;
import org.apache.directory.shared.ldap.model.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.ldap.sp.JavaStoredProcUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")}, saslHost="localhost", saslMechanisms={@SaslMechanism(name="PLAIN", implClass=PlainMechanismHandler.class), @SaslMechanism(name="CRAM-MD5", implClass=CramMd5MechanismHandler.class), @SaslMechanism(name="DIGEST-MD5", implClass=DigestMd5MechanismHandler.class), @SaslMechanism(name="GSSAPI", implClass=GssapiMechanismHandler.class), @SaslMechanism(name="NTLM", implClass=NtlmMechanismHandler.class), @SaslMechanism(name="GSS-SPNEGO", implClass=NtlmMechanismHandler.class)}, extendedOpHandlers={StoredProcedureExtendedOperationHandler.class})
public class StoredProcedureIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private LdapContext ctx;
    private LdapContext spCtx;
    private Map<String, OidNormalizer> oids;

    @Before
    public void setUp() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + StoredProcedureIT.getLdapServer().getPort() + "/ou=system");
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        this.ctx = new InitialLdapContext(env, null);
        BasicAttributes spContainer = new BasicAttributes("objectClass", "top", true);
        spContainer.get("objectClass").add("organizationalUnit");
        spContainer.put("ou", "Stored Procedures");
        this.spCtx = (LdapContext)this.ctx.createSubcontext("ou=Stored Procedures", (Attributes)spContainer);
        Assert.assertNotNull((Object)this.spCtx);
        this.oids = new HashMap<String, OidNormalizer>();
        this.oids.put("ou", new OidNormalizer("ou", (Normalizer)new DeepTrimToLowerNormalizer()));
        this.oids.put("organizationalUnitName", new OidNormalizer("ou", (Normalizer)new DeepTrimToLowerNormalizer()));
        this.oids.put("2.5.4.11", new OidNormalizer("ou", (Normalizer)new DeepTrimToLowerNormalizer()));
    }

    @Ignore
    @Test
    public void testExecuteProcedureWithReturnValue() throws Exception {
        String procedureName = HelloWorldProcedure.class.getName() + ":sayHello";
        JavaStoredProcUtils.loadStoredProcedureClass((LdapContext)this.spCtx, HelloWorldProcedure.class);
        Object response = JavaStoredProcUtils.callStoredProcedure((LdapContext)this.ctx, (String)procedureName, (Object[])new Object[0]);
        Assert.assertEquals((Object)"Hello World!", (Object)response);
    }

    @Ignore
    @Test
    public void testExecuteProcedureWithParametersAndReturnValue() throws Exception {
        String procedureName = HelloWorldProcedure.class.getName() + ":sayHelloTo";
        JavaStoredProcUtils.loadStoredProcedureClass((LdapContext)this.spCtx, HelloWorldProcedure.class);
        Object response = JavaStoredProcUtils.callStoredProcedure((LdapContext)this.ctx, (String)procedureName, (Object[])new Object[]{"Ersin"});
        Assert.assertEquals((Object)"Hello Ersin!", (Object)response);
    }
}

