/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.delete;

import javax.naming.NameNotFoundException;
import javax.naming.ReferralException;
import javax.naming.ldap.LdapContext;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.model.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.DeleteRequest;
import org.apache.directory.shared.ldap.model.message.DeleteRequestImpl;
import org.apache.directory.shared.ldap.model.message.DeleteResponse;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.controls.ManageDsaITImpl;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: uid=akarasulu,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: akarasulu", "cn: Alex Karasulu", "sn: karasulu", "dn: ou=Computers,uid=akarasulu,ou=users,ou=system", "objectClass: organizationalUnit", "objectClass: top", "ou: computers", "description: Computers for Alex", "seeAlso: ou=Machines,uid=akarasulu,ou=users,ou=system", "dn: uid=akarasuluref,ou=users,ou=system", "objectClass: uidObject", "objectClass: referral", "objectClass: top", "uid: akarasuluref", "ref: ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://foo:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://bar:10389/uid=akarasulu,ou=users,ou=system"})
public class DeleteIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final Logger LOG = LoggerFactory.getLogger(DeleteIT.class);

    @Test
    public void testNormalDeleteFailContextNotEmpty() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getAdminConnection((LdapServer)DeleteIT.getLdapServer());
        try {
            conn.delete("uid=akarasulu,ou=users,ou=system");
            Assert.fail();
        }
        catch (LdapContextNotEmptyException lcnee) {
            Assert.assertTrue((boolean)true);
        }
        conn.unBind();
        conn.close();
    }

    @Test
    public void testNormalDelete() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getAdminConnection((LdapServer)DeleteIT.getLdapServer());
        conn.delete("ou=computers,uid=akarasulu,ou=users,ou=system");
        try {
            conn.delete("uid=elecharny,ou=users,ou=system");
            Assert.fail();
        }
        catch (LdapNoSuchObjectException lnsoe) {
            Assert.assertTrue((boolean)true);
        }
        conn.unBind();
        conn.close();
    }

    @Test
    public void testDeleteNonExistent() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getAdminConnection((LdapServer)DeleteIT.getLdapServer());
        try {
            conn.delete("uid=elecharny,ou=users,ou=system");
            Assert.fail();
        }
        catch (LdapNoSuchObjectException lnsoe) {
            Assert.assertTrue((boolean)true);
        }
        conn.unBind();
        conn.close();
    }

    @Test
    public void testOnReferralWithManageDsaITControl() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)DeleteIT.getLdapServer());
        ManageDsaITImpl manageDSAIT = new ManageDsaITImpl();
        manageDSAIT.setCritical(true);
        DeleteRequestImpl deleteRequest = new DeleteRequestImpl();
        deleteRequest.setName(new Dn(new String[]{"uid=akarasuluref,ou=users,ou=system"}));
        deleteRequest.addControl((Control)manageDSAIT);
        conn.delete((DeleteRequest)deleteRequest);
        Assert.assertNull((Object)conn.lookup("uid=akarasuluref,ou=users,ou=system", new Control[]{manageDSAIT}, new String[0]));
        conn.close();
    }

    @Test
    public void testOnReferral() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)DeleteIT.getLdapServer());
        DeleteRequestImpl deleteRequest = new DeleteRequestImpl();
        deleteRequest.setName(new Dn(new String[]{"uid=akarasuluref,ou=users,ou=system"}));
        DeleteResponse deleteResponse = conn.delete((DeleteRequest)deleteRequest);
        Assert.assertEquals((Object)ResultCodeEnum.REFERRAL, (Object)deleteResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)deleteResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://localhost:10389/uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)deleteResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://foo:10389/uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)deleteResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://bar:10389/uid=akarasulu,ou=users,ou=system"));
        conn.close();
    }

    @Test
    public void testThrowOnReferralWithJndi() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)DeleteIT.getLdapServer());
        ctx.destroySubcontext("ou=computers,uid=akarasulu,ou=users,ou=system");
        try {
            ctx.lookup("ou=computers,uid=akarasulu,ou=users,ou=system");
            Assert.fail((String)"Should never get here.");
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        try {
            ctx.destroySubcontext("uid=akarasuluref,ou=users,ou=system");
            Assert.fail((String)"Should never get here");
        }
        catch (ReferralException e) {
            Assert.assertEquals((Object)"ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", (Object)e.getReferralInfo());
        }
        ctx.close();
    }

    @Test
    public void testAncestorReferral() throws Exception {
        LOG.debug("");
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)DeleteIT.getLdapServer());
        DeleteRequestImpl deleteRequest = new DeleteRequestImpl();
        deleteRequest.setName(new Dn(new String[]{"ou=Computers,uid=akarasuluref,ou=users,ou=system"}));
        DeleteResponse deleteResponse = conn.delete((DeleteRequest)deleteRequest);
        Assert.assertEquals((Object)ResultCodeEnum.REFERRAL, (Object)deleteResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)deleteResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://localhost:10389/ou=Computers,uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)deleteResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://foo:10389/ou=Computers,uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)deleteResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://bar:10389/ou=Computers,uid=akarasulu,ou=users,ou=system"));
        conn.close();
    }

    @Test
    public void testDeleteWithIllegalName() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getAdminConnection((LdapServer)DeleteIT.getLdapServer());
        try {
            conn.delete("This is an illegal name,dc=example,dc=com");
            Assert.fail((String)"deletion should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        conn.close();
    }
}

