/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.add;

import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.model.cursor.EntryCursor;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class AddingEntriesWithSpecialCharactersInRDNIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);

    private Entry getPersonEntry(String sn, String cn) throws LdapException {
        DefaultEntry entry = new DefaultEntry();
        entry.add("objectClass", new String[]{"person"});
        entry.add("cn", new String[]{cn});
        entry.add("sn", new String[]{sn});
        return entry;
    }

    private Entry getOrgUnitEntry(String ou) throws LdapException {
        DefaultEntry entry = new DefaultEntry();
        entry.add("objectClass", new String[]{"organizationalUnit"});
        entry.add("ou", new String[]{ou});
        return entry;
    }

    @Test
    public void testAddingWithHashRdn() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)AddingEntriesWithSpecialCharactersInRDNIT.getLdapServer());
        Entry personEntry = this.getPersonEntry("Bush", "Kate#Bush");
        String dn = "cn=Kate\\#Bush,ou=system";
        personEntry.setDn(new Dn(new String[]{dn}));
        connection.add(personEntry);
        EntryCursor cursor = connection.search("ou=system", "(cn=Kate#Bush)", SearchScope.SUBTREE, new String[]{"*"});
        boolean entryFound = false;
        while (cursor.next()) {
            Entry entry = (Entry)cursor.get();
            entryFound = true;
            Assert.assertTrue((boolean)personEntry.getDn().equals((Object)entry.getDn()));
            Attribute cn = entry.get("cn");
            Assert.assertNotNull((Object)cn);
            Assert.assertTrue((boolean)cn.contains(new String[]{"Kate#Bush"}));
        }
        cursor.close();
        Assert.assertTrue((String)"entry found", (boolean)entryFound);
        connection.delete(dn);
        connection.close();
    }

    @Test
    public void testAddingWithCommaInRdn() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)AddingEntriesWithSpecialCharactersInRDNIT.getLdapServer());
        Entry entry = this.getPersonEntry("Bush", "Bush, Kate");
        String dn = "cn=Bush\\, Kate,ou=system";
        entry.setDn(new Dn(new String[]{dn}));
        connection.add(entry);
        EntryCursor cursor = connection.search("ou=system", "(cn=Bush, Kate)", SearchScope.SUBTREE, new String[]{"*"});
        boolean entryFound = false;
        while (cursor.next()) {
            Entry sr = (Entry)cursor.get();
            entryFound = true;
            Assert.assertTrue((boolean)entry.getDn().equals((Object)sr.getDn()));
            Attribute cn = sr.get("cn");
            Assert.assertNotNull((Object)cn);
            Assert.assertTrue((boolean)cn.contains(new String[]{"Bush, Kate"}));
        }
        cursor.close();
        Assert.assertTrue((String)"entry found", (boolean)entryFound);
        connection.delete(dn);
        connection.close();
    }

    @Test
    public void testAddingWithQuotesInRdn() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)AddingEntriesWithSpecialCharactersInRDNIT.getLdapServer());
        Entry entry = this.getPersonEntry("Messer", "Mackie \"The Knife\" Messer");
        String dn = "cn=Mackie \\\"The Knife\\\" Messer,ou=system";
        entry.setDn(new Dn(new String[]{dn}));
        connection.add(entry);
        EntryCursor cursor = connection.search("ou=system", "(cn=Mackie \"The Knife\" Messer)", SearchScope.SUBTREE, new String[]{"*"});
        boolean entryFound = false;
        while (cursor.next()) {
            Entry sr = (Entry)cursor.get();
            entryFound = true;
            Assert.assertTrue((boolean)entry.getDn().equals((Object)sr.getDn()));
            Attribute cn = sr.get("cn");
            Assert.assertNotNull((Object)cn);
            Assert.assertTrue((boolean)cn.contains(new String[]{"Mackie \"The Knife\" Messer"}));
        }
        cursor.close();
        Assert.assertTrue((String)"entry found", (boolean)entryFound);
        connection.delete(dn);
        connection.close();
    }

    @Test
    public void testAddingWithBackslashInRdn() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)AddingEntriesWithSpecialCharactersInRDNIT.getLdapServer());
        Entry entry = this.getOrgUnitEntry("AC\\DC");
        String dn = "ou=AC\\\\DC,ou=system";
        entry.setDn(new Dn(new String[]{dn}));
        connection.add(entry);
        EntryCursor cursor = connection.search("ou=system", "(ou=AC\\5CDC)", SearchScope.SUBTREE, new String[]{"*"});
        boolean entryFound = false;
        while (cursor.next()) {
            Entry sr = (Entry)cursor.get();
            entryFound = true;
            Assert.assertTrue((boolean)entry.getDn().equals((Object)sr.getDn()));
            Attribute ou = sr.get("ou");
            Assert.assertNotNull((Object)ou);
            Assert.assertTrue((boolean)ou.contains(new String[]{"AC\\DC"}));
        }
        cursor.close();
        Assert.assertTrue((String)"no entry found", (boolean)entryFound);
        connection.delete(dn);
        connection.close();
    }

    @Test
    public void testAddingWithGreaterSignInRdn() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)AddingEntriesWithSpecialCharactersInRDNIT.getLdapServer());
        Entry entry = this.getOrgUnitEntry("East -> West");
        String dn = "ou=East -\\> West,ou=system";
        entry.setDn(new Dn(new String[]{dn}));
        connection.add(entry);
        EntryCursor cursor = connection.search("ou=system", "(ou=East -> West)", SearchScope.SUBTREE, new String[]{"*"});
        boolean entryFound = false;
        while (cursor.next()) {
            Entry sr = (Entry)cursor.get();
            entryFound = true;
            Assert.assertTrue((boolean)entry.getDn().equals((Object)sr.getDn()));
            Attribute ou = sr.get("ou");
            Assert.assertNotNull((Object)ou);
            Assert.assertTrue((boolean)ou.contains(new String[]{"East -> West"}));
        }
        cursor.close();
        Assert.assertTrue((String)"entry found", (boolean)entryFound);
        connection.delete(dn);
        connection.close();
    }

    @Test
    public void testAddingWithLessSignInRdn() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)AddingEntriesWithSpecialCharactersInRDNIT.getLdapServer());
        Entry entry = this.getOrgUnitEntry("Scissors 8<");
        String dn = "ou=Scissors 8\\<,ou=system";
        entry.setDn(new Dn(new String[]{dn}));
        connection.add(entry);
        EntryCursor cursor = connection.search("ou=system", "(ou=Scissors 8<)", SearchScope.SUBTREE, new String[]{"*"});
        boolean entryFound = false;
        while (cursor.next()) {
            Entry sr = (Entry)cursor.get();
            entryFound = true;
            Assert.assertTrue((boolean)entry.getDn().equals((Object)sr.getDn()));
            Attribute ou = sr.get("ou");
            Assert.assertNotNull((Object)ou);
            Assert.assertTrue((boolean)ou.contains(new String[]{"Scissors 8<"}));
        }
        cursor.close();
        Assert.assertTrue((String)"entry found", (boolean)entryFound);
        connection.delete(dn);
        connection.close();
    }

    @Test
    public void testAddingWithSemicolonInRdn() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)AddingEntriesWithSpecialCharactersInRDNIT.getLdapServer());
        Entry entry = this.getOrgUnitEntry("semicolon group;");
        String dn = "ou=semicolon group\\;,ou=system";
        entry.setDn(new Dn(new String[]{dn}));
        connection.add(entry);
        EntryCursor cursor = connection.search("ou=system", "(ou=semicolon group;)", SearchScope.SUBTREE, new String[]{"*"});
        boolean entryFound = false;
        while (cursor.next()) {
            Entry sr = (Entry)cursor.get();
            entryFound = true;
            Assert.assertTrue((boolean)entry.getDn().equals((Object)sr.getDn()));
            Attribute ou = sr.get("ou");
            Assert.assertNotNull((Object)ou);
            Assert.assertTrue((boolean)ou.contains(new String[]{"semicolon group;"}));
        }
        cursor.close();
        Assert.assertTrue((String)"entry found", (boolean)entryFound);
        connection.delete(dn);
        connection.close();
    }

    @Test
    public void testAddingWithEqualsInRdn() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)AddingEntriesWithSpecialCharactersInRDNIT.getLdapServer());
        Entry entry = this.getOrgUnitEntry("nomen=omen");
        String dn = "ou=nomen\\=omen,ou=system";
        entry.setDn(new Dn(new String[]{dn}));
        connection.add(entry);
        EntryCursor cursor = connection.search("ou=system", "(ou=nomen=omen)", SearchScope.SUBTREE, new String[]{"*"});
        boolean entryFound = false;
        while (cursor.next()) {
            Entry sr = (Entry)cursor.get();
            entryFound = true;
            Assert.assertTrue((boolean)entry.getDn().equals((Object)sr.getDn()));
            Attribute ou = sr.get("ou");
            Assert.assertNotNull((Object)ou);
            Assert.assertTrue((boolean)ou.contains(new String[]{"nomen=omen"}));
        }
        cursor.close();
        Assert.assertTrue((String)"entry found", (boolean)entryFound);
        connection.delete(dn);
        connection.close();
    }

    @Test
    public void testAddRdnWithEscapedSpaces() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)AddingEntriesWithSpecialCharactersInRDNIT.getLdapServer());
        connection.setTimeOut(-1L);
        DefaultEntry entry = new DefaultEntry("cn=\\ User, ou=system", new Object[]{"objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: inetOrgPerson", "cn:  User", "sn:  Name "});
        connection.add((Entry)entry);
        Entry addedEntry = connection.lookup("cn=\\ User, ou=system");
        Assert.assertNotNull((Object)addedEntry);
        Assert.assertEquals((Object)"Name", (Object)addedEntry.get("sn").getString());
        Assert.assertEquals((Object)"User", (Object)addedEntry.get("cn").getString());
        Assert.assertEquals((long)1L, (long)addedEntry.get("cn").size());
        Assert.assertTrue((boolean)addedEntry.contains("cn", new String[]{"User"}));
        Assert.assertFalse((boolean)addedEntry.contains("cn", new String[]{" User"}));
    }
}

