/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.admin;

import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: ou=AAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP1", "administrativeRole: autonomousArea", "", "dn: ou=IAP-CA1,ou=AAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CA1", "administrativeRole: collectiveAttributeInnerArea", "", "dn: ou=IAP-AC1,ou=AAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-AC1", "administrativeRole: accessControlInnerArea", "", "dn: ou=SAP-CA1,ou=AAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CA1", "administrativeRole: collectiveAttributeSpecificArea", "", "dn: ou=SAP-AC1,ou=AAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-AC1", "administrativeRole: accessControlSpecificArea", "", "dn: ou=SAP-CA2,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CA2", "administrativeRole: collectiveAttributeSpecificArea", "", "dn: ou=SAP-AC2,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-AC2", "administrativeRole: accessControlSpecificArea", "", "dn: ou=entry,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: entry", ""})
public class AdministrativePointAddIT
extends AbstractLdapTestUnit {
    private static LdapConnection connection;
    private static SchemaManager schemaManager;

    @Before
    public void init() throws Exception {
        connection = IntegrationUtils.getAdminConnection((DirectoryService)AdministrativePointAddIT.getService());
        schemaManager = AdministrativePointAddIT.getLdapServer().getDirectoryService().getSchemaManager();
    }

    @After
    public void shutdown() throws Exception {
        connection.close();
    }

    private Attribute getAdminRole(String dn) throws Exception {
        Entry lookup = connection.lookup(dn, new String[]{"administrativeRole"});
        Assert.assertNotNull((Object)lookup);
        return lookup.get("administrativeRole");
    }

    @Test
    public void testAddIAP() throws Exception {
        Assert.assertTrue((boolean)AdministrativePointAddIT.getLdapServer().isStarted());
        DefaultEntry entry = new DefaultEntry("ou=IAP-CANew,ou=entry,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CANew", "administrativeRole: collectiveAttributeInnerArea"});
        try {
            connection.add((Entry)entry);
            Assert.fail();
        }
        catch (LdapUnwillingToPerformException lutpe) {
            Assert.assertTrue((boolean)true);
        }
        entry = new DefaultEntry("ou=IAP-CANew,ou=SAP-CA2,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CANew", "administrativeRole: collectiveAttributeInnerArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=IAP-CANew,ou=SAP-CA2,ou=system"));
        entry = new DefaultEntry("ou=IAP-CANew,ou=SAP-AC2,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CANew", "administrativeRole: collectiveAttributeInnerArea"});
        try {
            connection.add((Entry)entry);
            Assert.fail();
        }
        catch (LdapUnwillingToPerformException lutpe) {
            Assert.assertTrue((boolean)true);
        }
        entry = new DefaultEntry("ou=IAP-CANew,ou=AAP1,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CANew", "administrativeRole: collectiveAttributeInnerArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=IAP-CANew,ou=AAP1,ou=system"));
        entry = new DefaultEntry("ou=IAP-CANew,ou=IAP-CA1,ou=AAP1,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CANew", "administrativeRole: collectiveAttributeInnerArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=IAP-CANew,ou=IAP-CA1,ou=AAP1,ou=system"));
        entry = new DefaultEntry("ou=IAP-CANew,ou=IAP-AC1,ou=AAP1,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CANew", "administrativeRole: collectiveAttributeInnerArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=IAP-CANew,ou=IAP-AC1,ou=AAP1,ou=system"));
        entry = new DefaultEntry("ou=IAP-CANew,ou=SAP-CA1,ou=AAP1,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CANew", "administrativeRole: collectiveAttributeInnerArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=IAP-CANew,ou=SAP-CA1,ou=AAP1,ou=system"));
        entry = new DefaultEntry("ou=IAP-CANew,ou=SAP-AC1,ou=AAP1,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CANew", "administrativeRole: collectiveAttributeInnerArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=IAP-CANew,ou=SAP-AC1,ou=AAP1,ou=system"));
    }

    @Test
    public void testAddSAP() throws Exception {
        Assert.assertTrue((boolean)AdministrativePointAddIT.getLdapServer().isStarted());
        DefaultEntry entry = new DefaultEntry("ou=SAP-CANew,ou=entry,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CANew", "administrativeRole: collectiveAttributeSpecificArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=SAP-CANew,ou=entry,ou=system"));
        entry = new DefaultEntry("ou=SAP-CANew,ou=SAP-CA2,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CANew", "administrativeRole: collectiveAttributeSpecificArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=SAP-CANew,ou=SAP-CA2,ou=system"));
        entry = new DefaultEntry("ou=SAP-CANew,ou=SAP-AC2,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CANew", "administrativeRole: collectiveAttributeSpecificArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=SAP-CANew,ou=SAP-AC2,ou=system"));
        entry = new DefaultEntry("ou=SAP-CANew,ou=AAP1,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CANew", "administrativeRole: collectiveAttributeSpecificArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=SAP-CANew,ou=AAP1,ou=system"));
        entry = new DefaultEntry("ou=SAP-CANew,ou=IAP-CA1,ou=AAP1,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CANew", "administrativeRole: collectiveAttributeSpecificArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=SAP-CANew,ou=IAP-CA1,ou=AAP1,ou=system"));
        entry = new DefaultEntry("ou=SAP-CANew,ou=IAP-AC1,ou=AAP1,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CANew", "administrativeRole: collectiveAttributeSpecificArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=SAP-CANew,ou=IAP-AC1,ou=AAP1,ou=system"));
        entry = new DefaultEntry("ou=SAP-CANew,ou=SAP-CA1,ou=AAP1,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CANew", "administrativeRole: collectiveAttributeSpecificArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=SAP-CANew,ou=SAP-CA1,ou=AAP1,ou=system"));
        entry = new DefaultEntry("ou=SAP-CANew,ou=SAP-AC1,ou=AAP1,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CANew", "administrativeRole: collectiveAttributeSpecificArea"});
        connection.add((Entry)entry);
        Assert.assertTrue((boolean)connection.exists("ou=SAP-CANew,ou=SAP-AC1,ou=AAP1,ou=system"));
    }
}

