/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory;

import java.io.File;
import java.util.List;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.impl.avl.AvlIndex;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.shared.ldap.schemaextractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.shared.ldap.schemaloader.LdifSchemaLoader;
import org.apache.directory.shared.ldap.schemamanager.impl.DefaultSchemaManager;
import org.apache.directory.shared.util.exception.Exceptions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class IndexTest {
    private static File dbFileDir;
    private static SchemaManager schemaManager;
    private JdbmIndex<String, Entry> jdbmIndex;
    private AvlIndex<String, Entry> avlIndex;

    @BeforeClass
    public static void init() throws Exception {
        String workingDirectory = System.getProperty("workingDirectory");
        if (workingDirectory == null) {
            String path = IndexTest.class.getResource("").getPath();
            int targetPos = path.indexOf("target");
            workingDirectory = path.substring(0, targetPos + 6);
        }
        File schemaRepository = new File(workingDirectory, "schema");
        DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(new File(workingDirectory));
        extractor.extractOrCopy(true);
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
        schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        boolean loaded = schemaManager.loadAllEnabled();
        if (!loaded) {
            Assert.fail((String)("Schema load failed : " + Exceptions.printErrors((List)schemaManager.getErrors())));
        }
    }

    @Before
    public void setup() throws Exception {
        File tmpIndexFile = File.createTempFile(IndexTest.class.getSimpleName(), "db");
        tmpIndexFile.deleteOnExit();
        dbFileDir = new File(tmpIndexFile.getParentFile(), IndexTest.class.getSimpleName());
        dbFileDir.mkdirs();
        AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry("ou");
        this.jdbmIndex = new JdbmIndex();
        this.jdbmIndex.setWkDirPath(dbFileDir.toURI());
        this.jdbmIndex.init(schemaManager, attributeType);
        this.avlIndex = new AvlIndex();
        this.avlIndex.init(schemaManager, attributeType);
    }

    @Test
    public void testAvlIndex() throws Exception {
        this.doTest((Index<String, Entry, Long>)this.avlIndex);
    }

    @Test
    @Ignore(value="Does not work with JDBM2")
    public void testJdbmIndex() throws Exception {
        this.doTest((Index<String, Entry, Long>)this.jdbmIndex);
    }

    private void doTest(Index<String, Entry, Long> idx) throws Exception {
        String alphabet = "abcdefghijklmnopqrstuvwxyz";
        for (long i = 0L; i < 26L; ++i) {
            String val = alphabet.substring((int)i, (int)(i + 1L));
            idx.add((Object)val, (Object)(i + 1L));
        }
        Assert.assertEquals((long)26L, (long)idx.count());
        IndexCursor cursor1 = idx.forwardCursor();
        cursor1.beforeFirst();
        this.assertHasNext((IndexCursor<String, Entry, Long>)cursor1, 1L);
        this.assertHasNext((IndexCursor<String, Entry, Long>)cursor1, 2L);
        idx.drop((Object)"c", (Object)3L);
        for (long i = 4L; i < 27L; ++i) {
            this.assertHasNext((IndexCursor<String, Entry, Long>)cursor1, i);
        }
        Assert.assertFalse((boolean)cursor1.next());
        cursor1.close();
    }

    private void assertHasNext(IndexCursor<String, Entry, Long> cursor1, long expectedId) throws Exception {
        Assert.assertTrue((boolean)cursor1.next());
        Assert.assertEquals((long)expectedId, (long)((Long)((IndexEntry)cursor1.get()).getId()));
    }
}

