/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.compare;

import javax.naming.NamingEnumeration;
import javax.naming.ReferralException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.ldap.client.api.exception.InvalidConnectionException;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationException;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.CompareRequestImpl;
import org.apache.directory.shared.ldap.model.message.CompareResponse;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.controls.ManageDsaITImpl;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: uid=akarasulu,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: akarasulu", "cn: Alex Karasulu", "sn: karasulu", "dn: ou=Computers,uid=akarasulu,ou=users,ou=system", "objectClass: organizationalUnit", "objectClass: top", "ou: computers", "description: Computers for Alex", "seeAlso: ou=Machines,uid=akarasulu,ou=users,ou=system", "dn: uid=akarasuluref,ou=users,ou=system", "objectClass: uidObject", "objectClass: referral", "objectClass: top", "uid: akarasuluref", "ref: ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://foo:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://bar:10389/uid=akarasulu,ou=users,ou=system"})
public class CompareIT
extends AbstractLdapTestUnit {
    private static final Logger LOG = LoggerFactory.getLogger(CompareIT.class);

    @Test
    public void testNormalCompare() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getAdminConnection((LdapServer)CompareIT.getLdapServer());
        boolean response = conn.compare("uid=akarasulu,ou=users,ou=system", "sn", "karasulu");
        Assert.assertTrue((boolean)response);
        response = conn.compare("uid=akarasulu,ou=users,ou=system", "sn", "lecharny");
        Assert.assertFalse((boolean)response);
        conn.unBind();
        conn.close();
    }

    @Test
    public void testNormalCompareMissingAttribute() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)CompareIT.getLdapServer());
        Assert.assertTrue((boolean)conn.compare("uid=akarasulu,ou=users,ou=system", "sn", "karasulu"));
        try {
            conn.compare("uid=akarasulu,ou=users,ou=system", "mail", "akarasulu@apache.org");
            Assert.fail((String)"Should never get here");
        }
        catch (LdapOperationException e) {
            Assert.assertEquals((Object)ResultCodeEnum.NO_SUCH_ATTRIBUTE, (Object)e.getResultCode());
        }
        conn.close();
    }

    @Test
    public void testOnReferralWithManageDsaITControl() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)CompareIT.getLdapServer());
        Assert.assertTrue((boolean)conn.compare("uid=akarasuluref,ou=users,ou=system", "uid", "akarasuluref"));
        CompareRequestImpl compareRequest = new CompareRequestImpl();
        compareRequest.setName(new Dn(new String[]{"uid=akarasuluref,ou=users,ou=system"}));
        compareRequest.setAttributeId("uid");
        compareRequest.setAssertionValue("elecharny");
        ManageDsaITImpl manageDSAIT = new ManageDsaITImpl();
        manageDSAIT.setCritical(true);
        compareRequest.addControl((Control)manageDSAIT);
        CompareResponse compareResponse = conn.compare((CompareRequest)compareRequest);
        Assert.assertEquals((Object)ResultCodeEnum.COMPARE_FALSE, (Object)compareResponse.getLdapResult().getResultCode());
        conn.close();
    }

    @Test
    public void testOnReferral() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)CompareIT.getLdapServer());
        CompareRequestImpl compareRequest = new CompareRequestImpl();
        compareRequest.setName(new Dn(new String[]{"uid=akarasulu,ou=users,ou=system"}));
        compareRequest.setAttributeId("uid");
        compareRequest.setAssertionValue("akarasulu");
        ManageDsaITImpl manageDSAIT = new ManageDsaITImpl();
        manageDSAIT.setCritical(false);
        compareRequest.addControl((Control)manageDSAIT);
        CompareResponse compareResponse = conn.compare((CompareRequest)compareRequest);
        Assert.assertEquals((Object)ResultCodeEnum.COMPARE_TRUE, (Object)compareResponse.getLdapResult().getResultCode());
        compareRequest = new CompareRequestImpl();
        compareRequest.setName(new Dn(new String[]{"uid=akarasuluREF,ou=users,ou=system"}));
        compareRequest.setAttributeId("uid");
        compareRequest.setAssertionValue("akarasulu");
        compareResponse = conn.compare((CompareRequest)compareRequest);
        Assert.assertEquals((Object)ResultCodeEnum.REFERRAL, (Object)compareResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)compareResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://localhost:10389/uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)compareResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://foo:10389/uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)compareResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://bar:10389/uid=akarasulu,ou=users,ou=system"));
        conn.close();
    }

    @Test
    public void testThrowOnReferralWithJndi() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)CompareIT.getLdapServer());
        SearchControls controls = new SearchControls();
        controls.setReturningAttributes(new String[0]);
        controls.setSearchScope(0);
        NamingEnumeration<SearchResult> answer = ctx.search("uid=akarasulu,ou=users,ou=system", "(uid=akarasulu)", controls);
        Assert.assertTrue((boolean)answer.hasMore());
        SearchResult result = answer.next();
        Assert.assertEquals((Object)"", (Object)result.getName());
        Assert.assertEquals((long)0L, (long)result.getAttributes().size());
        Assert.assertFalse((boolean)answer.hasMore());
        answer.close();
        try {
            answer = ctx.search("uid=akarasuluref,ou=users,ou=system", "(uid=akarasuluref)", controls);
            Assert.fail((String)"Should never get here");
        }
        catch (ReferralException e) {
            Assert.assertEquals((Object)"ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", (Object)e.getReferralInfo());
        }
        ctx.close();
    }

    @Test(expected=InvalidConnectionException.class)
    public void testCompareWithoutAuthentication() throws LdapException {
        CompareIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(false);
        LdapNetworkConnection conn = new LdapNetworkConnection("localhost", CompareIT.getLdapServer().getPort());
        conn.compare("uid=admin,ou=system", "uid", "admin");
        Assert.fail((String)"Compare success without authentication");
    }

    @Test
    public void testAncestorReferral() throws Exception {
        LOG.debug("");
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)CompareIT.getLdapServer());
        CompareRequestImpl compareRequest = new CompareRequestImpl();
        compareRequest.setName(new Dn(new String[]{"ou=Computers,uid=akarasuluref,ou=users,ou=system"}));
        compareRequest.setAttributeId("ou");
        compareRequest.setAssertionValue("Computers");
        CompareResponse compareResponse = conn.compare((CompareRequest)compareRequest);
        Assert.assertEquals((Object)ResultCodeEnum.REFERRAL, (Object)compareResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)compareResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://localhost:10389/ou=Computers,uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)compareResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://foo:10389/ou=Computers,uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)compareResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://bar:10389/ou=Computers,uid=akarasulu,ou=users,ou=system"));
        conn.close();
    }
}

