/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.modify;

import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: cn=Tori Amos,ou=system", "objectClass: person", "objectClass: top", "description: an American singer-songwriter", "cn: Tori Amos", "sn: Amos"})
public class ModifyRemoveIT
extends AbstractLdapTestUnit {
    private static final String BASE = "ou=system";
    private static final String RDN = "cn=Tori Amos";

    @Before
    public void setUp() throws Exception {
        DirContext schemaRoot = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup("ou=schema");
        Attributes krb5kdcAttrs = schemaRoot.getAttributes("cn=Krb5kdc");
        boolean isKrb5KdcDisabled = false;
        if (krb5kdcAttrs.get("m-disabled") != null) {
            isKrb5KdcDisabled = ((String)krb5kdcAttrs.get("m-disabled").get()).equalsIgnoreCase("TRUE");
        }
        if (isKrb5KdcDisabled) {
            BasicAttribute disabled = new BasicAttribute("m-disabled");
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, disabled)};
            schemaRoot.modifyAttributes("cn=Krb5kdc", mods);
        }
    }

    protected Attributes getPersonAttributes(String sn, String cn) {
        BasicAttributes attributes = new BasicAttributes(true);
        BasicAttribute attribute = new BasicAttribute("objectClass");
        attribute.add("top");
        attribute.add("person");
        attributes.put(attribute);
        attributes.put("cn", cn);
        attributes.put("sn", sn);
        return attributes;
    }

    protected Attributes getInetOrgPersonAttributes(String sn, String cn) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute ocls = new BasicAttribute("objectClass");
        ocls.add("top");
        ocls.add("person");
        ocls.add("organizationalPerson");
        ocls.add("inetOrgPerson");
        attrs.put(ocls);
        attrs.put("cn", cn);
        attrs.put("sn", sn);
        return attrs;
    }

    @Test
    public void testRemoveAttemptWithoutChange() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        Attributes tori = ctx.getAttributes(RDN);
        Assert.assertNotNull((Object)tori.get("objectClass"));
        Assert.assertNotNull((Object)tori.get("cn"));
        Assert.assertEquals((long)1L, (long)tori.get("cn").size());
        Assert.assertEquals((Object)"Tori Amos", (Object)tori.get("cn").get());
        Assert.assertNotNull((Object)tori.get("sn"));
        ModificationItem mod = new ModificationItem(1, new BasicAttribute("cn", "foo"));
        ctx.modifyAttributes(RDN, new ModificationItem[]{mod});
        tori = ctx.getAttributes(RDN);
        Assert.assertNotNull((Object)tori.get("objectClass"));
        Assert.assertNotNull((Object)tori.get("cn"));
        Assert.assertEquals((long)2L, (long)tori.get("cn").size());
        Assert.assertEquals((Object)"Tori Amos", (Object)tori.get("cn").get(0));
        Assert.assertEquals((Object)"foo", (Object)tori.get("cn").get(1));
        Assert.assertNotNull((Object)tori.get("sn"));
        mod = new ModificationItem(3, new BasicAttribute("cn", "bar"));
        try {
            ctx.modifyAttributes(RDN, new ModificationItem[]{mod});
            Assert.fail();
        }
        catch (NoSuchAttributeException nsae) {
            Assert.assertTrue((boolean)true);
        }
        tori = ctx.getAttributes(RDN);
        Assert.assertNotNull((Object)tori.get("objectClass"));
        Assert.assertNotNull((Object)tori.get("cn"));
        Assert.assertEquals((long)2L, (long)tori.get("cn").size());
        Assert.assertEquals((Object)"Tori Amos", (Object)tori.get("cn").get(0));
        Assert.assertEquals((Object)"foo", (Object)tori.get("cn").get(1));
        Assert.assertNotNull((Object)tori.get("sn"));
    }

    @Test
    public void testRemoveNotRequiredAttribute() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        Attribute attr = new BasicAttribute("description");
        Attributes attrs = new BasicAttributes(true);
        attrs.put(attr);
        ctx.modifyAttributes(RDN, 3, attrs);
        attrs = ctx.getAttributes(RDN);
        attr = attrs.get("description");
        Assert.assertNull((Object)attr);
    }

    @Test
    public void testRemoveTwoNotRequiredAttributes() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        BasicAttributes tn = new BasicAttributes("telephoneNumber", "12345678", true);
        ctx.modifyAttributes(RDN, 1, (Attributes)tn);
        Attributes attrs = new BasicAttributes(true);
        attrs.put(new BasicAttribute("description"));
        attrs.put(new BasicAttribute("telephoneNumber"));
        ctx.modifyAttributes(RDN, 3, attrs);
        attrs = ctx.getAttributes(RDN);
        Assert.assertNull((Object)attrs.get("description"));
        Assert.assertNull((Object)attrs.get("telephoneNumber"));
        Assert.assertNotNull((Object)attrs.get("cn"));
        Assert.assertNotNull((Object)attrs.get("sn"));
    }

    @Test
    public void testRemoveRequiredAttribute() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        BasicAttribute attr = new BasicAttribute("sn");
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(attr);
        try {
            ctx.modifyAttributes(RDN, 3, (Attributes)attrs);
            Assert.fail((String)"Deletion of required attribute should fail.");
        }
        catch (SchemaViolationException e) {
            // empty catch block
        }
    }

    @Test
    public void testRemovePartOfRdn() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        BasicAttribute attr = new BasicAttribute("cn");
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(attr);
        try {
            ctx.modifyAttributes(RDN, 3, (Attributes)attrs);
            Assert.fail((String)"Deletion of Rdn attribute should fail.");
        }
        catch (SchemaViolationException e) {
            // empty catch block
        }
    }

    @Test
    public void testRemovePartOfRdnNotRequired() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        String newRdn = "description=an American singer-songwriter";
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        ctx.rename(RDN, newRdn);
        BasicAttribute attr = new BasicAttribute("description");
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(attr);
        try {
            ctx.modifyAttributes(newRdn, 3, (Attributes)attrs);
            Assert.fail((String)"Deletion of Rdn attribute should fail.");
        }
        catch (SchemaViolationException e) {
            // empty catch block
        }
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        ctx.rename(newRdn, RDN);
    }

    @Test
    public void testRemoveAttributeNotPresent() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        BasicAttribute attr = new BasicAttribute("telephoneNumber");
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(attr);
        try {
            ctx.modifyAttributes(RDN, 3, (Attributes)attrs);
            Assert.fail((String)"Deletion of attribute, which is not present in the entry, should fail.");
        }
        catch (NoSuchAttributeException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testRemoveAttributeValueNotPresent() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        BasicAttribute attr = new BasicAttribute("telephoneNumber", "12345");
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(attr);
        ctx.modifyAttributes(RDN, 1, (Attributes)attrs);
        BasicAttribute attr2 = new BasicAttribute("telephoneNumber", "7890");
        BasicAttributes attrs2 = new BasicAttributes(true);
        attrs2.put(attr2);
        try {
            ctx.modifyAttributes(RDN, 3, (Attributes)attrs2);
            Assert.fail();
        }
        catch (NoSuchAttributeException nsae) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testRemoveAttributeNotValid() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        BasicAttribute attr = new BasicAttribute("XXX");
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(attr);
        try {
            ctx.modifyAttributes(RDN, 3, (Attributes)attrs);
            Assert.fail((String)"Deletion of an invalid attribute should fail.");
        }
        catch (NoSuchAttributeException e) {
        }
        catch (InvalidAttributeIdentifierException e) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceNonExistingAttribute() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        Attributes attrs = this.getInetOrgPersonAttributes("Bush", "Kate Bush");
        attrs.put("givenname", "Kate");
        String rdn = "cn=Kate Bush";
        ctx.createSubcontext(rdn, attrs);
        BasicAttribute attr = new BasicAttribute("givenname");
        ModificationItem item = new ModificationItem(2, attr);
        ctx.modifyAttributes(rdn, new ModificationItem[]{item});
        SearchControls sctls = new SearchControls();
        sctls.setSearchScope(1);
        String filter = "(cn=Kate Bush)";
        String base = "";
        NamingEnumeration<SearchResult> enm = ctx.search(base, filter, sctls);
        if (enm.hasMore()) {
            SearchResult sr = enm.next();
            attrs = sr.getAttributes();
            Attribute cn = sr.getAttributes().get("cn");
            Assert.assertNotNull((Object)cn);
            Assert.assertTrue((boolean)cn.contains("Kate Bush"));
            Attribute givenName = sr.getAttributes().get("givenname");
            Assert.assertNull((Object)givenName);
        } else {
            Assert.fail((String)"entry not found");
        }
        ctx.destroySubcontext(rdn);
    }

    @Test
    public void testReplaceRdnByEmptyValueAttribute() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        Attributes attrs = this.getPersonAttributes("Bush", "Kate Bush");
        String rdn = "cn=Kate Bush";
        ctx.createSubcontext(rdn, attrs);
        BasicAttribute attr = new BasicAttribute("cn");
        ModificationItem item = new ModificationItem(2, attr);
        try {
            ctx.modifyAttributes(rdn, new ModificationItem[]{item});
            Assert.fail((String)"modify should fail");
        }
        catch (SchemaViolationException e) {
            // empty catch block
        }
        ctx.destroySubcontext(rdn);
    }

    @Test
    public void testRemoveRdnAttribute() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        Attributes attrs = this.getPersonAttributes("Bush", "Kate Bush");
        String rdn = "cn=Kate Bush";
        ctx.createSubcontext(rdn, attrs);
        BasicAttribute attr = new BasicAttribute("cn");
        ModificationItem item = new ModificationItem(3, attr);
        try {
            ctx.modifyAttributes(rdn, new ModificationItem[]{item});
            Assert.fail((String)"modify should fail");
        }
        catch (SchemaViolationException e) {
            // empty catch block
        }
        ctx.destroySubcontext(rdn);
    }

    @Test
    public void testRemoveRdnAttributeValue() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        Attributes attrs = this.getPersonAttributes("Bush", "Kate Bush");
        String rdn = "cn=Kate Bush";
        ctx.createSubcontext(rdn, attrs);
        BasicAttribute attr = new BasicAttribute("cn", "Kate Bush");
        ModificationItem item = new ModificationItem(3, attr);
        try {
            ctx.modifyAttributes(rdn, new ModificationItem[]{item});
            Assert.fail((String)"modify should fail");
        }
        catch (SchemaViolationException e) {
            // empty catch block
        }
        ctx.destroySubcontext(rdn);
    }

    @Test
    public void testDeleteOclAttrWithTopPersonOrganizationalpersonInetorgperson() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        Attributes attrs = this.getInetOrgPersonAttributes("Bush", "Kate Bush");
        String rdn = "cn=Kate Bush";
        ctx.createSubcontext(rdn, attrs);
        ModificationItem delModOp = new ModificationItem(3, new BasicAttribute("objectclass", ""));
        try {
            ctx.modifyAttributes(rdn, new ModificationItem[]{delModOp});
            Assert.fail((String)"deletion of objectclass should fail");
        }
        catch (SchemaViolationException e) {
        }
        catch (NoSuchAttributeException e) {
        }
        catch (InvalidAttributeValueException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ctx.destroySubcontext(rdn);
    }

    @Test
    public void testDeleteOclAttrWithTopPersonOrganizationalpersonInetorgpersonVariant() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        Attributes attrs = this.getInetOrgPersonAttributes("Bush", "Kate Bush");
        String rdn = "cn=Kate Bush";
        ctx.createSubcontext(rdn, attrs);
        ModificationItem delModOp = new ModificationItem(3, new BasicAttribute("objectclass"));
        try {
            ctx.modifyAttributes(rdn, new ModificationItem[]{delModOp});
            Assert.fail((String)"deletion of objectclass should fail");
        }
        catch (SchemaViolationException e) {
            // empty catch block
        }
        ctx.destroySubcontext(rdn);
    }

    @Test
    public void testRemoveObjectClassAndMandatoryAttribute() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRemoveIT.getLdapServer()).lookup(BASE);
        BasicAttributes tn = new BasicAttributes(true);
        tn.put(new BasicAttribute("objectClass", "krb5Principal", true));
        tn.put(new BasicAttribute("krb5PrincipalName", "test", true));
        ctx.modifyAttributes(RDN, 1, (Attributes)tn);
        Attributes attrs = new BasicAttributes(true);
        attrs.put(new BasicAttribute("objectClass", "krb5Principal", true));
        attrs.put(new BasicAttribute("krb5PrincipalName"));
        ctx.modifyAttributes(RDN, 3, attrs);
        attrs = ctx.getAttributes(RDN);
        Assert.assertNotNull((Object)attrs.get("objectClass"));
        Assert.assertFalse((boolean)attrs.get("objectClass").contains("krb5Principal"));
        Assert.assertNull((Object)attrs.get("krb5PrincipalName"));
        Assert.assertNotNull((Object)attrs.get("cn"));
        Assert.assertNotNull((Object)attrs.get("sn"));
    }
}

