/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.admin;

import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.administrative.AdministrativePoint;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.util.tree.DnNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="TestDS", enableAccessControl=true)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: ou=noAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: noAP1", "", "dn: ou=AAP1,ou=noAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP1", "administrativeRole: autonomousArea", "", "dn: ou=noAP2,ou=AAP1,ou=noAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: noAP2", "", "dn: ou=AAP2,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP2", "administrativeRole: autonomousArea", "", "dn: ou=noAP3,ou=AAP2,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: noAP3", "", "dn: ou=subAAP1,ou=noAP3,ou=AAP2,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: subAAP1", "administrativeRole: autonomousArea", "", "dn: ou=noAP4,ou=subAAP1,ou=noAP3,ou=AAP2,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: noAP4", ""})
public class AdministrativePointPersistentIT
extends AbstractLdapTestUnit {
    private static LdapConnection connection;
    private static SchemaManager schemaManager;

    @Before
    public void init() throws Exception {
        AdministrativePointPersistentIT.getService().setAccessControlEnabled(true);
        connection = IntegrationUtils.getAdminConnection((DirectoryService)AdministrativePointPersistentIT.getService());
        schemaManager = AdministrativePointPersistentIT.getService().getSchemaManager();
    }

    @After
    public void shutdown() throws Exception {
        connection.close();
    }

    private Attribute getAdminRole(String dn) throws Exception {
        Entry lookup = connection.lookup(dn, new String[]{"administrativeRole"});
        Assert.assertNotNull((Object)lookup);
        return lookup.get("administrativeRole");
    }

    @Test
    public void testPersistAutonomousArea() throws Exception {
        Assert.assertTrue((boolean)AdministrativePointPersistentIT.getLdapServer().isStarted());
        AdministrativePointPersistentIT.getLdapServer().stop();
        Assert.assertFalse((boolean)AdministrativePointPersistentIT.getLdapServer().isStarted());
        AdministrativePointPersistentIT.getLdapServer().getDirectoryService().shutdown();
        Assert.assertFalse((boolean)AdministrativePointPersistentIT.getLdapServer().getDirectoryService().isStarted());
        AdministrativePointPersistentIT.getLdapServer().getDirectoryService().startup();
        AdministrativePointPersistentIT.getLdapServer().start();
        schemaManager = AdministrativePointPersistentIT.getLdapServer().getDirectoryService().getSchemaManager();
        Assert.assertTrue((boolean)AdministrativePointPersistentIT.getService().isStarted());
        Assert.assertTrue((boolean)AdministrativePointPersistentIT.getLdapServer().getDirectoryService().isStarted());
        Assert.assertEquals((Object)"autonomousArea", (Object)this.getAdminRole("ou=AAP1,ou=noAP1,ou=system").getString());
        Assert.assertEquals((Object)"autonomousArea", (Object)this.getAdminRole("ou=AAP2,ou=system").getString());
        Assert.assertEquals((Object)"autonomousArea", (Object)this.getAdminRole("ou=subAAP1,ou=noAP3,ou=AAP2,ou=system").getString());
        DnNode acCache = AdministrativePointPersistentIT.getLdapServer().getDirectoryService().getAccessControlAPCache();
        DnNode caCache = AdministrativePointPersistentIT.getLdapServer().getDirectoryService().getCollectiveAttributeAPCache();
        DnNode teCache = AdministrativePointPersistentIT.getLdapServer().getDirectoryService().getTriggerExecutionAPCache();
        DnNode ssCache = AdministrativePointPersistentIT.getLdapServer().getDirectoryService().getSubschemaAPCache();
        AdministrativePoint aap1 = (AdministrativePoint)acCache.getElement(new Dn(schemaManager, new String[]{"ou=AAP1,ou=noAP1,ou=system"}));
        Assert.assertNotNull((Object)aap1);
        AdministrativePoint aap2 = (AdministrativePoint)acCache.getElement(new Dn(schemaManager, new String[]{"ou=AAP2,ou=system"}));
        Assert.assertNotNull((Object)aap2);
        AdministrativePoint subAap1 = (AdministrativePoint)acCache.getElement(new Dn(schemaManager, new String[]{"ou=subAAP1,ou=noAP3,ou=AAP2,ou=system"}));
        Assert.assertNotNull((Object)subAap1);
        aap1 = (AdministrativePoint)caCache.getElement(new Dn(schemaManager, new String[]{"ou=AAP1,ou=noAP1,ou=system"}));
        Assert.assertNotNull((Object)aap1);
        aap2 = (AdministrativePoint)caCache.getElement(new Dn(schemaManager, new String[]{"ou=AAP2,ou=system"}));
        Assert.assertNotNull((Object)aap2);
        subAap1 = (AdministrativePoint)caCache.getElement(new Dn(schemaManager, new String[]{"ou=subAAP1,ou=noAP3,ou=AAP2,ou=system"}));
        Assert.assertNotNull((Object)subAap1);
        aap1 = (AdministrativePoint)teCache.getElement(new Dn(schemaManager, new String[]{"ou=AAP1,ou=noAP1,ou=system"}));
        Assert.assertNotNull((Object)aap1);
        aap2 = (AdministrativePoint)teCache.getElement(new Dn(schemaManager, new String[]{"ou=AAP2,ou=system"}));
        Assert.assertNotNull((Object)aap2);
        subAap1 = (AdministrativePoint)teCache.getElement(new Dn(schemaManager, new String[]{"ou=subAAP1,ou=noAP3,ou=AAP2,ou=system"}));
        Assert.assertNotNull((Object)subAap1);
        aap1 = (AdministrativePoint)ssCache.getElement(new Dn(schemaManager, new String[]{"ou=AAP1,ou=noAP1,ou=system"}));
        Assert.assertNotNull((Object)aap1);
        aap2 = (AdministrativePoint)ssCache.getElement(new Dn(schemaManager, new String[]{"ou=AAP2,ou=system"}));
        Assert.assertNotNull((Object)aap2);
        subAap1 = (AdministrativePoint)ssCache.getElement(new Dn(schemaManager, new String[]{"ou=subAAP1,ou=noAP3,ou=AAP2,ou=system"}));
        Assert.assertNotNull((Object)subAap1);
    }
}

