/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.search;

import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: cn=active-directory, ou=schema", "objectclass: metaSchema", "objectclass: top", "cn: active-directory", "m-dependencies: core", "dn: ou=attributeTypes, cn=active-directory, ou=schema", "objectclass: organizationalUnit", "objectclass: top", "ou: attributeTypes", "dn: m-oid=1.1, ou=attributeTypes, cn=active-directory, ou=schema", "objectclass: metaAttributeType", "objectclass: metaTop", "objectclass: top", "m-oid: 1.1", "m-name: sAMAccountName", "m-syntax: 1.3.6.1.4.1.1466.115.121.1.15", "dn: m-oid=1.2, ou=attributeTypes, cn=active-directory, ou=schema", "objectclass: metaAttributeType", "objectclass: metaTop", "objectclass: top", "m-oid: 1.2", "m-name: pwdLastSet", "m-equality: integerMatch", "m-ordering: integerMatch", "m-syntax: 1.3.6.1.4.1.1466.115.121.1.27", "dn: m-oid=1.4, ou=attributeTypes, cn=active-directory, ou=schema", "objectclass: metaAttributeType", "objectclass: metaTop", "objectclass: top", "m-oid: 1.4", "m-name: useraccountcontrol", "m-syntax: 1.3.6.1.4.1.1466.115.121.1.27", "dn: m-oid=1.5, ou=attributeTypes, cn=active-directory, ou=schema", "objectclass: metaAttributeType", "objectclass: metaTop", "objectclass: top", "m-oid: 1.5", "m-name: SourceAD", "m-syntax: 1.3.6.1.4.1.1466.115.121.1.15", "m-length: 0", "dn: ou=comparators, cn=active-directory, ou=schema", "objectclass: organizationalUnit", "objectclass: top", "ou: comparators", "dn: ou=ditContentRules, cn=active-directory, ou=schema", "objectclass: organizationalUnit", "objectclass: top", "ou: ditContentRules", "dn: ou=ditStructureRules, cn=active-directory, ou=schema", "objectclass: organizationalUnit", "objectclass: top", "ou: ditStructureRules", "dn: ou=matchingRules, cn=active-directory, ou=schema", "objectclass: organizationalUnit", "objectclass: top", "ou: matchingRules", "dn: ou=nameForms, cn=active-directory, ou=schema", "objectclass: organizationalUnit", "objectclass: top", "ou: nameForms", "dn: ou=normalizers, cn=active-directory, ou=schema", "objectclass: organizationalUnit", "objectclass: top", "ou: normalizers", "dn: ou=objectClasses, cn=active-directory, ou=schema", "objectclass: organizationalUnit", "objectclass: top", "ou: objectClasses", "dn: m-oid=1.3, ou=objectClasses, cn=active-directory, ou=schema", "objectclass: metaObjectClass", "objectclass: metaTop", "objectclass: top", "m-oid: 1.3", "m-name: personActiveDirectory", "m-supObjectClass: person", "m-must: pwdLastSet", "m-must: sAMAccountName", "m-must: useraccountcontrol", "m-must: SourceAD", "dn: ou=syntaxCheckers, cn=active-directory, ou=schema", "objectclass: organizationalUnit", "objectclass: top", "ou: syntaxCheckers", "dn: ou=syntaxes, cn=active-directory, ou=schema", "objectclass: organizationalUnit", "objectclass: top", "ou: syntaxes"})
public class SchemaSearchIT
extends AbstractLdapTestUnit {
    private static final String DN = "cn=schema";
    private static final String FILTER = "(objectclass=subschema)";

    protected void checkForAttributes(Attributes attrs, String[] attrNames) {
        for (int i = 0; i < attrNames.length; ++i) {
            String attrName = attrNames[i];
            Assert.assertNotNull((String)("Check if attr " + attrName + " is present"), (Object)attrs.get(attrNames[i]));
        }
    }

    @Test
    public void testRequestOperationalAttributes() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)SchemaSearchIT.getLdapServer());
        SearchControls ctls = new SearchControls();
        String[] attrNames = new String[]{"creatorsName", "createTimestamp", "modifiersName", "modifyTimestamp"};
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(attrNames);
        NamingEnumeration<SearchResult> result = ctx.search(DN, FILTER, ctls);
        if (result.hasMore()) {
            SearchResult entry = result.next();
            this.checkForAttributes(entry.getAttributes(), attrNames);
        } else {
            Assert.fail((String)"entry cn=schema not found");
        }
        result.close();
    }

    @Test
    public void testRequestAllOperationalAttributes() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)SchemaSearchIT.getLdapServer());
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{"+"});
        NamingEnumeration<SearchResult> result = ctx.search(DN, FILTER, ctls);
        if (result.hasMore()) {
            SearchResult entry = result.next();
            String[] attrNames = new String[]{"creatorsName", "createTimestamp", "modifiersName", "modifyTimestamp"};
            this.checkForAttributes(entry.getAttributes(), attrNames);
        } else {
            Assert.fail((String)"entry cn=schema not found");
        }
        result.close();
    }

    @Test
    public void testSearchingNewSchemaElements() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)SchemaSearchIT.getLdapServer());
        BasicAttributes person = new BasicAttributes("objectClass", "top", true);
        person.get("objectClass").add("person");
        person.get("objectClass").add("personActiveDirectory");
        person.put("cn", "foobar");
        person.put("sn", "bar");
        person.put("pwdLastSet", "3");
        person.put("SourceAD", "blah");
        person.put("useraccountcontrol", "7");
        person.put("sAMAccountName", "foobar");
        ctx.createSubcontext("cn=foobar,ou=system", (Attributes)person);
        Attributes read = ctx.getAttributes("cn=foobar,ou=system");
        Assert.assertNotNull((Object)read);
        Assert.assertEquals((Object)"3", (Object)read.get("pwdLastSet").get());
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        NamingEnumeration<SearchResult> results = ctx.search("ou=system", "(pwdLastSet=3)", searchControls);
        Assert.assertTrue((boolean)results.hasMore());
        SearchResult result = results.next();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"cn=foobar", (Object)result.getName());
        Attributes attributes = result.getAttributes();
        Assert.assertEquals((Object)"3", (Object)attributes.get("pwdLastSet").get());
        results.close();
        results = ctx.search("ou=system", "(pwdLastSet=300)", searchControls);
        Assert.assertFalse((boolean)results.hasMore());
        results.close();
    }

    @Test
    public void testRequestWithoutManageDsaITControl() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)SchemaSearchIT.getLdapServer());
        ctx.addToEnvironment("java.naming.referral", "throw");
        SearchControls ctls = new SearchControls();
        String[] attrNames = new String[]{"objectClasses", "attributeTypes", "ldapSyntaxes", "matchingRules", "matchingRuleUse", "createTimestamp", "modifyTimestamp"};
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(attrNames);
        NamingEnumeration<SearchResult> result = ctx.search(DN, FILTER, ctls);
        if (result.hasMore()) {
            SearchResult entry = result.next();
            this.checkForAttributes(entry.getAttributes(), attrNames);
        } else {
            Assert.fail((String)"entry cn=schema not found");
        }
        result.close();
    }

    @Test
    public void testSubSchemaSubEntrySearch() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)SchemaSearchIT.getLdapServer());
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(0);
        searchControls.setReturningAttributes(new String[]{"objectClasses"});
        NamingEnumeration<SearchResult> results = ctx.search(DN, "(ObjectClass=*)", searchControls);
        Assert.assertTrue((boolean)results.hasMore());
        SearchResult result = results.next();
        Attributes entry = result.getAttributes();
        Attribute objectClasses = entry.get("objectClasses");
        NamingEnumeration<?> ocs = objectClasses.getAll();
        while (ocs.hasMore()) {
            String oc = (String)ocs.nextElement();
            if (!oc.contains("2.5.6.6")) continue;
            Assert.assertEquals((Object)"( 2.5.6.6 NAME 'person' DESC 'RFC2256: a person' SUP top STRUCTURAL MUST ( sn $ cn ) MAY ( userPassword $ telephoneNumber $ seeAlso $ description ) X-SCHEMA 'core' )", (Object)oc);
        }
        results.close();
    }
}

