/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.ldap.handlers.bind.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.plain.PlainMechanismHandler;
import org.apache.directory.server.ldap.handlers.extended.StoredProcedureExtendedOperationHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(allowAnonAccess=true, name="PasswordPolicyServiceIT-class", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\ndc: example\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")}, saslHost="localhost", saslMechanisms={@SaslMechanism(name="PLAIN", implClass=PlainMechanismHandler.class), @SaslMechanism(name="CRAM-MD5", implClass=CramMd5MechanismHandler.class), @SaslMechanism(name="DIGEST-MD5", implClass=DigestMd5MechanismHandler.class), @SaslMechanism(name="GSSAPI", implClass=GssapiMechanismHandler.class), @SaslMechanism(name="NTLM", implClass=NtlmMechanismHandler.class), @SaslMechanism(name="GSS-SPNEGO", implClass=NtlmMechanismHandler.class)}, extendedOpHandlers={StoredProcedureExtendedOperationHandler.class})
@Ignore(value="This test case is no loger useful cause we removed PasswordPolicyInterceptor, instead look at PasswordPolicyTest")
public class PasswordPolicyServiceIT
extends AbstractLdapTestUnit {
    private DirContext ctx;
    private DirContext users;

    @Before
    public void setUp() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + PasswordPolicyServiceIT.getLdapServer().getPort() + "/dc=example,dc=com");
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        this.ctx = new InitialDirContext(env);
        Attributes attrs = this.getOrgUnitAttributes("users");
        this.users = this.ctx.createSubcontext("ou=users", attrs);
    }

    @Test
    public void testLength() {
        Attributes attrs = this.getPersonAttributes("Nelson", "Horatio Nelson", "hnelson", "HN1");
        try {
            this.users.createSubcontext("uid=hnelson", attrs);
            Assert.fail((String)"Shouldn't have gotten here.");
        }
        catch (NamingException ne) {
            Assert.assertTrue((boolean)ne.getMessage().contains("length too short"));
            Assert.assertFalse((boolean)ne.getMessage().contains("insufficient character mix"));
            Assert.assertFalse((boolean)ne.getMessage().contains("contains portions of username"));
        }
    }

    @Test
    public void testCharacterMix() {
        Attributes attrs = this.getPersonAttributes("Nelson", "Horatio Nelson", "hnelson", "secret");
        try {
            this.users.createSubcontext("uid=hnelson", attrs);
            Assert.fail((String)"Shouldn't have gotten here.");
        }
        catch (NamingException ne) {
            Assert.assertFalse((boolean)ne.getMessage().contains("length too short"));
            Assert.assertTrue((boolean)ne.getMessage().contains("insufficient character mix"));
            Assert.assertFalse((boolean)ne.getMessage().contains("contains portions of username"));
        }
    }

    @Test
    public void testContainsUsername() {
        Attributes attrs = this.getPersonAttributes("Nelson", "Horatio Nelson", "hnelson", "A1nelson");
        try {
            this.users.createSubcontext("uid=hnelson", attrs);
            Assert.fail((String)"Shouldn't have gotten here.");
        }
        catch (NamingException ne) {
            Assert.assertFalse((boolean)ne.getMessage().contains("length too short"));
            Assert.assertFalse((boolean)ne.getMessage().contains("insufficient character mix"));
            Assert.assertTrue((boolean)ne.getMessage().contains("contains portions of username"));
        }
    }

    @Test
    public void testCharacterMixAndLength() {
        Attributes attrs = this.getPersonAttributes("Nelson", "Horatio Nelson", "hnelson", "hi");
        try {
            this.users.createSubcontext("uid=hnelson", attrs);
            Assert.fail((String)"Shouldn't have gotten here.");
        }
        catch (NamingException ne) {
            Assert.assertTrue((boolean)ne.getMessage().contains("length too short"));
            Assert.assertTrue((boolean)ne.getMessage().contains("insufficient character mix"));
            Assert.assertFalse((boolean)ne.getMessage().contains("contains portions of username"));
        }
    }

    @Test
    public void testLengthAndContainsUsername() {
        Attributes attrs = this.getPersonAttributes("Bush", "William Bush", "wbush", "bush1");
        try {
            this.users.createSubcontext("uid=wbush", attrs);
            Assert.fail((String)"Shouldn't have gotten here.");
        }
        catch (NamingException ne) {
            Assert.assertTrue((boolean)ne.getMessage().contains("length too short"));
            Assert.assertFalse((boolean)ne.getMessage().contains("insufficient character mix"));
            Assert.assertTrue((boolean)ne.getMessage().contains("contains portions of username"));
        }
    }

    @Test
    public void testCharacterMixAndContainsUsername() {
        Attributes attrs = this.getPersonAttributes("Nelson", "Horatio Nelson", "hnelson", "hnelson");
        try {
            this.users.createSubcontext("uid=hnelson", attrs);
            Assert.fail((String)"Shouldn't have gotten here.");
        }
        catch (NamingException ne) {
            Assert.assertFalse((boolean)ne.getMessage().contains("length too short"));
            Assert.assertTrue((boolean)ne.getMessage().contains("insufficient character mix"));
            Assert.assertTrue((boolean)ne.getMessage().contains("contains portions of username"));
        }
    }

    @Test
    public void testCharacterMixAndLengthAndContainsUsername() {
        Attributes attrs = this.getPersonAttributes("Bush", "William Bush", "wbush", "bush");
        try {
            this.users.createSubcontext("uid=wbush", attrs);
            Assert.fail((String)"Shouldn't have gotten here.");
        }
        catch (NamingException ne) {
            Assert.assertTrue((boolean)ne.getMessage().contains("length too short"));
            Assert.assertTrue((boolean)ne.getMessage().contains("insufficient character mix"));
            Assert.assertTrue((boolean)ne.getMessage().contains("contains portions of username"));
        }
    }

    @After
    public void tearDown() throws Exception {
        this.ctx.close();
        this.ctx = null;
    }

    protected Attributes getPersonAttributes(String sn, String cn, String uid, String userPassword) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute ocls = new BasicAttribute("objectClass");
        ocls.add("top");
        ocls.add("person");
        ocls.add("inetOrgPerson");
        attrs.put(ocls);
        attrs.put("cn", cn);
        attrs.put("sn", sn);
        attrs.put("uid", uid);
        attrs.put("userPassword", userPassword);
        return attrs;
    }

    protected Attributes getOrgUnitAttributes(String ou) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute ocls = new BasicAttribute("objectClass");
        ocls.add("top");
        ocls.add("organizationalUnit");
        attrs.put(ocls);
        attrs.put("ou", ou);
        return attrs;
    }
}

