/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ssl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.ldap.handlers.extended.StartTlsHandler;
import org.apache.directory.server.ssl.ReloadableSSLSocketFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateDS(allowAnonAccess=true, name="StartTlsIT-class")
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP"), @CreateTransport(protocol="LDAPS")}, extendedOpHandlers={StartTlsHandler.class})
public class StartTlsIT
extends AbstractLdapTestUnit {
    private static final Logger LOG = LoggerFactory.getLogger(StartTlsIT.class);
    private static final String[] CERT_IDS = new String[]{"userCertificate"};
    private static final int CONNECT_ITERATIONS = 10;
    private static final boolean VERBOSE = false;
    private File ksFile;
    boolean oldConfidentialityRequiredValue;

    @Before
    public void installKeyStoreWithCertificate() throws Exception {
        if (this.ksFile != null && this.ksFile.exists()) {
            this.ksFile.delete();
        }
        this.ksFile = File.createTempFile("testStore", "ks");
        CoreSession session = StartTlsIT.getLdapServer().getDirectoryService().getAdminSession();
        Entry entry = session.lookup(new Dn(new String[]{"uid=admin,ou=system"}), CERT_IDS);
        byte[] userCertificate = entry.get(CERT_IDS[0]).getBytes();
        Assert.assertNotNull((Object)userCertificate);
        ByteArrayInputStream in = new ByteArrayInputStream(userCertificate);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        Certificate cert = factory.generateCertificate(in);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        ks.setCertificateEntry("apacheds", cert);
        ks.store(new FileOutputStream(this.ksFile), "changeit".toCharArray());
        LOG.debug("Keystore file installed: {}", (Object)this.ksFile.getAbsolutePath());
        this.oldConfidentialityRequiredValue = StartTlsIT.getLdapServer().isConfidentialityRequired();
    }

    @After
    public void deleteKeyStore() throws Exception {
        if (this.ksFile != null && this.ksFile.exists()) {
            this.ksFile.delete();
        }
        LOG.debug("Keystore file deleted: {}", (Object)this.ksFile.getAbsolutePath());
        StartTlsIT.getLdapServer().setConfidentialityRequired(this.oldConfidentialityRequiredValue);
    }

    private void search(int ii, LdapContext securedContext) throws Exception {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        ArrayList<String> results = new ArrayList<String>();
        NamingEnumeration<SearchResult> ne = securedContext.search("ou=system", "(objectClass=*)", controls);
        while (ne.hasMore()) {
            String dn = ne.next().getNameInNamespace();
            results.add(dn);
        }
        ne.close();
        Assert.assertEquals((long)10L, (long)results.size());
        Assert.assertTrue((String)"Results must contain ou=system", (boolean)results.contains("ou=system"));
        Assert.assertTrue((String)"Results must contain uid=admin,ou=system", (boolean)results.contains("uid=admin,ou=system"));
        Assert.assertTrue((String)"Results must contain ou=users,ou=system", (boolean)results.contains("ou=users,ou=system"));
        Assert.assertTrue((String)"Results must contain ou=groups,ou=system", (boolean)results.contains("ou=groups,ou=system"));
        Assert.assertTrue((String)"Results must contain cn=Administrators,ou=groups,ou=system", (boolean)results.contains("cn=Administrators,ou=groups,ou=system"));
        Assert.assertTrue((String)"Results must contain ou=configuration,ou=system", (boolean)results.contains("ou=configuration,ou=system"));
        Assert.assertTrue((String)"Results must contain ou=partitions,ou=configuration,ou=system", (boolean)results.contains("ou=partitions,ou=configuration,ou=system"));
        Assert.assertTrue((String)"Results must contain ou=services,ou=configuration,ou=system", (boolean)results.contains("ou=services,ou=configuration,ou=system"));
        Assert.assertTrue((String)"Results must contain ou=interceptors,ou=configuration,ou=system", (boolean)results.contains("ou=interceptors,ou=configuration,ou=system"));
        Assert.assertTrue((String)"Results must contain prefNodeName=sysPrefRoot,ou=system", (boolean)results.contains("prefNodeName=sysPrefRoot,ou=system"));
    }

    @Test
    public void testStartTls() throws Exception {
        for (int ii = 0; ii < 10; ++ii) {
            System.setProperty("javax.net.ssl.trustStore", this.ksFile.getAbsolutePath());
            System.setProperty("javax.net.ssl.keyStore", this.ksFile.getAbsolutePath());
            System.setProperty("javax.net.ssl.keyStorePassword", "changeit");
            LOG.debug("testStartTls() test starting ... ");
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.principal", "uid=admin,ou=system");
            env.put("java.naming.security.credentials", "secret");
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.provider.url", "ldap://localhost:" + StartTlsIT.getLdapServer().getPort());
            LOG.debug("About to get initial context");
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            LOG.debug("About send startTls extended operation");
            StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
            LOG.debug("Extended operation issued");
            tls.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            LOG.debug("TLS negotion about to begin");
            tls.negotiate(ReloadableSSLSocketFactory.getDefault());
            this.search(ii, ctx);
            ctx.close();
        }
    }
}

