/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.replication;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.MockDirectoryService;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.replication.ReplicationConsumerConfig;
import org.apache.directory.server.ldap.replication.SyncReplConfiguration;
import org.apache.directory.server.ldap.replication.consumer.ReplicationConsumer;
import org.apache.directory.server.ldap.replication.provider.ReplicaEventLog;
import org.apache.directory.server.ldap.replication.provider.ReplicationRequestHandler;
import org.apache.directory.server.ldap.replication.provider.SyncReplRequestHandler;
import org.apache.directory.server.replication.MockSyncReplConsumer;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class StaleEventLogDetectionIT {
    private static LdapServer providerServer;
    private static SchemaManager schemaManager;
    private static CoreSession providerSession;
    private static AtomicInteger entryCount;
    private static final int INSERT_COUNT = 10;
    private static final int TOTAL_COUNT = 11;
    private static File cookiesDir;

    @BeforeClass
    public static void setUp() throws Exception {
        Class<?> justLoadToSetControlProperties = Class.forName(FrameworkRunner.class.getName());
        StaleEventLogDetectionIT.startProvider();
        for (int i = 0; i < 10; ++i) {
            Entry entry = StaleEventLogDetectionIT.createEntry();
            providerSession.add(entry);
        }
        cookiesDir = new File(FileUtils.getTempDirectory(), MockSyncReplConsumer.COOKIES_DIR_NAME);
    }

    @Before
    @After
    public void deleteCookies() throws IOException {
        if (cookiesDir.exists()) {
            FileUtils.cleanDirectory((File)cookiesDir);
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        providerServer.stop();
        providerServer.getDirectoryService().shutdown();
        FileUtils.deleteDirectory((File)providerServer.getDirectoryService().getInstanceLayout().getInstanceDirectory());
        FileUtils.deleteDirectory((File)cookiesDir);
    }

    private static Entry createEntry() throws Exception {
        String user = "user" + entryCount.incrementAndGet();
        String dn = "cn=" + user + ",dc=example,dc=com";
        DefaultEntry entry = new DefaultEntry(schemaManager, dn, new Object[]{"objectClass", "person", "cn", user, "sn", user});
        return entry;
    }

    @CreateDS(allowAnonAccess=true, name="provider-replication", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")}, contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\nobjectClass: domain\ndc: example"))})
    @CreateLdapServer(transports={@CreateTransport(port=16000, protocol="LDAP")})
    public static void startProvider() throws Exception {
        DirectoryService provDirService = DSAnnotationProcessor.getDirectoryService();
        providerServer = ServerAnnotationProcessor.getLdapServer((DirectoryService)provDirService);
        providerServer.setReplicationReqHandler((ReplicationRequestHandler)new SyncReplRequestHandler());
        providerServer.startReplicationProducer();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    schemaManager = providerServer.getDirectoryService().getSchemaManager();
                    providerSession = providerServer.getDirectoryService().getAdminSession();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
        t.join();
    }

    private boolean waitForSyncReplClient(ReplicationConsumer consumer, int expected) throws Exception {
        System.out.println("\nNbAdded every 100ms : ");
        boolean isFirst = true;
        for (int i = 0; i < 50; ++i) {
            int nbAdded = ((MockSyncReplConsumer)consumer).getNbAdded();
            if (isFirst) {
                isFirst = false;
            } else {
                System.out.print(", ");
            }
            System.out.print(nbAdded);
            if (nbAdded == expected) {
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    private ReplicationConsumer createConsumer() throws Exception {
        final MockSyncReplConsumer syncreplClient = new MockSyncReplConsumer();
        final SyncReplConfiguration config = new SyncReplConfiguration();
        config.setRemoteHost("localhost");
        config.setRemotePort(16000);
        config.setReplUserDn("uid=admin,ou=system");
        config.setReplUserPassword("secret".getBytes());
        config.setUseTls(false);
        config.setBaseDn("dc=example,dc=com");
        config.setRefreshInterval(1000L);
        syncreplClient.setConfig((ReplicationConsumerConfig)config);
        Assert.assertTrue((boolean)true);
        Runnable consumerTask = new Runnable(){

            @Override
            public void run() {
                try {
                    String baseDn = config.getBaseDn();
                    SearchRequestImpl searchRequest = new SearchRequestImpl();
                    searchRequest.setBase(new Dn(new String[]{baseDn}));
                    searchRequest.setFilter(config.getFilter());
                    searchRequest.setSizeLimit((long)config.getSearchSizeLimit());
                    searchRequest.setTimeLimit(config.getSearchTimeout());
                    searchRequest.setDerefAliases(config.getAliasDerefMode());
                    searchRequest.setScope(config.getSearchScope());
                    searchRequest.setTypesOnly(false);
                    searchRequest.addAttributes(config.getAttributes());
                    MockDirectoryService directoryService = new MockDirectoryService();
                    directoryService.setSchemaManager(schemaManager);
                    ((MockSyncReplConsumer)syncreplClient).init((DirectoryService)directoryService);
                    syncreplClient.connect(true);
                    syncreplClient.startSync();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Thread consumerThread = new Thread(consumerTask);
        consumerThread.setDaemon(true);
        consumerThread.start();
        return syncreplClient;
    }

    @Test
    public void testDeleteStaleEventLog() throws Exception {
        ReplicationConsumer consumer = this.createConsumer();
        Assert.assertTrue((boolean)this.waitForSyncReplClient(consumer, 11));
        consumer.stop();
        Thread.sleep(5000L);
        SyncReplRequestHandler syncreplHandler = (SyncReplRequestHandler)providerServer.getReplicationReqHandler();
        ReplicaEventLog log = (ReplicaEventLog)syncreplHandler.getReplicaLogMap().values().iterator().next();
        log.setMaxIdlePeriod(10L);
        syncreplHandler.getLogJanitor().setSleepTime(1000L);
        syncreplHandler.getLogJanitor().interrupt();
        File replDir = providerServer.getDirectoryService().getInstanceLayout().getReplDirectory();
        File logFile = new File(replDir, log.getName() + ".db");
        Assert.assertTrue((boolean)logFile.exists());
        Thread.sleep(10000L);
        Assert.assertFalse((boolean)logFile.exists());
    }

    static {
        entryCount = new AtomicInteger();
    }
}

