/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.modifydn;

import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NoPermissionException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="ModifyRdnIT-class", enableChangeLog=false)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class ModifyRdnIT
extends AbstractLdapTestUnit {
    private static final String BASE = "ou=system";

    private Attributes getPersonAttributes(String sn, String cn) throws Exception {
        Attributes attributes = LdifUtils.createJndiAttributes((Object[])new Object[]{"objectClass: top", "objectClass: person", "cn", cn, "sn", sn, "description", cn + " is a person."});
        return attributes;
    }

    private Attributes getOrganizationalUnitAttributes(String ou) throws Exception {
        Attributes attributes = LdifUtils.createJndiAttributes((Object[])new Object[]{"objectClass: top", "objectClass: organizationalUnit", "ou", ou, "description", ou + " is an organizational unit."});
        return attributes;
    }

    @Test
    public void testModifyRdnAndDeleteOld() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)ModifyRdnIT.getLdapServer());
        connection.loadSchema();
        String oldCn = "Myra Ellen Amos";
        String oldRdn = "cn=" + oldCn;
        String oldDn = oldRdn + ", " + BASE;
        DefaultEntry entry = new DefaultEntry(oldDn, new Object[]{"objectClass: top", "objectClass: person", "cn", oldCn, "sn: Amos", "description", oldCn + " is a person."});
        connection.add((Entry)entry);
        Entry tori = connection.lookup(oldDn);
        Assert.assertNotNull((Object)tori);
        Assert.assertTrue((boolean)tori.contains("cn", new String[]{"Myra Ellen Amos"}));
        String newCn = "Tori Amos";
        String newRdn = "cn=" + newCn;
        String newDn = newRdn + "," + BASE;
        connection.rename(oldDn, newRdn, true);
        Assert.assertNull((Object)connection.lookup(oldDn));
        tori = connection.lookup(newDn);
        Assert.assertNotNull((Object)tori);
        Assert.assertTrue((boolean)tori.contains("cn", new String[]{newCn}));
        Assert.assertFalse((boolean)tori.contains("cn", new String[]{oldCn}));
        Assert.assertEquals((long)1L, (long)tori.get("cn").size());
        connection.delete(newDn);
    }

    @Test
    public void testModifyRdnAndDontDeleteOldFalse() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        String oldCn = "Myra Ellen Amos";
        String oldRdn = "cn=" + oldCn;
        Attributes attributes = this.getPersonAttributes("Amos", oldCn);
        ctx.createSubcontext(oldRdn, attributes);
        String newCn = "Tori Amos";
        String newRdn = "cn=" + newCn;
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "False");
        ctx.rename(oldRdn, newRdn);
        try {
            ctx.lookup(oldRdn);
            Assert.fail((String)"Entry must not exist");
        }
        catch (NameNotFoundException ignored) {
            Assert.assertTrue((boolean)true);
        }
        DirContext tori = (DirContext)ctx.lookup(newRdn);
        Assert.assertNotNull((Object)tori);
        Attribute cn = tori.getAttributes("").get("cn");
        Assert.assertTrue((boolean)cn.contains(newCn));
        Assert.assertTrue((boolean)cn.contains(oldCn));
        Assert.assertEquals((long)2L, (long)cn.size());
        ctx.unbind(newRdn);
    }

    @Test
    public void testModifyRdnAndKeepOld() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        String oldCn = "Myra Ellen Amos";
        String oldRdn = "cn=" + oldCn;
        Attributes attributes = this.getPersonAttributes("Amos", oldCn);
        ctx.createSubcontext(oldRdn, attributes);
        String newCn = "Tori Amos";
        String newRdn = "cn=" + newCn;
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        ctx.rename(oldRdn, newRdn);
        try {
            ctx.lookup(oldRdn);
            Assert.fail((String)"Entry must not exist");
        }
        catch (NameNotFoundException ignored) {
            Assert.assertTrue((boolean)true);
        }
        DirContext tori = (DirContext)ctx.lookup(newRdn);
        Assert.assertNotNull((Object)tori);
        Attribute cn = tori.getAttributes("").get("cn");
        Assert.assertTrue((boolean)cn.contains(newCn));
        Assert.assertTrue((boolean)cn.contains(oldCn));
        Assert.assertEquals((long)2L, (long)cn.size());
        ctx.unbind(newRdn);
    }

    @Test
    public void testModifyRdnAndDeleteOldVariant() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        String oldCn = "Myra Ellen Amos";
        String oldRdn = "cn=" + oldCn;
        Attributes attributes = this.getPersonAttributes("Amos", oldCn);
        String alternateCn = "Myra E. Amos";
        Attribute cn = attributes.get("cn");
        cn.add(alternateCn);
        Assert.assertEquals((long)2L, (long)cn.size());
        ctx.createSubcontext(oldRdn, attributes);
        String newCn = "Tori Amos";
        String newRdn = "cn=" + newCn;
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "true");
        ctx.rename(oldRdn, newRdn);
        try {
            ctx.lookup(oldRdn);
            Assert.fail((String)"Entry must not exist");
        }
        catch (NameNotFoundException ignored) {
            Assert.assertTrue((boolean)true);
        }
        DirContext tori = (DirContext)ctx.lookup(newRdn);
        Assert.assertNotNull((Object)tori);
        cn = tori.getAttributes("").get("cn");
        Assert.assertTrue((boolean)cn.contains(newCn));
        Assert.assertTrue((!cn.contains(oldCn) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)cn.contains(alternateCn));
        Assert.assertEquals((long)2L, (long)cn.size());
        ctx.unbind(newRdn);
    }

    @Test
    public void testModifyRdnDifferentAttribute() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        String cnVal = "Tori Amos";
        String snVal = "Amos";
        String oldRdn = "cn=" + cnVal;
        Attributes attributes = this.getPersonAttributes(snVal, cnVal);
        ctx.createSubcontext(oldRdn, attributes);
        String newRdn = "sn=" + snVal;
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        ctx.rename(oldRdn, newRdn);
        try {
            ctx.lookup(oldRdn);
            Assert.fail((String)"Entry must not exist");
        }
        catch (NameNotFoundException ignored) {
            // empty catch block
        }
        DirContext tori = (DirContext)ctx.lookup(newRdn);
        Assert.assertNotNull((Object)tori);
        Attribute cn = tori.getAttributes("").get("cn");
        Assert.assertTrue((boolean)cn.contains(cnVal));
        Assert.assertEquals((String)"Number of cn occurences", (long)1L, (long)cn.size());
        Attribute sn = tori.getAttributes("").get("sn");
        Assert.assertTrue((boolean)sn.contains(snVal));
        Assert.assertEquals((String)"Number of sn occurences", (long)1L, (long)sn.size());
        ctx.unbind(newRdn);
    }

    @Test
    public void testModifyRdnDifferentAttributeDeleteOldFails() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        String cnVal = "Tori Amos";
        String snVal = "Amos";
        String oldRdn = "cn=" + cnVal;
        Attributes attributes = this.getPersonAttributes(snVal, cnVal);
        ctx.createSubcontext(oldRdn, attributes);
        String newRdn = "sn=" + snVal;
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "true");
        try {
            ctx.rename(oldRdn, newRdn);
            Assert.fail((String)"Rename must fail, mandatory attirbute cn can not be deleted.");
        }
        catch (SchemaViolationException ignored) {
            // empty catch block
        }
        ctx.unbind(oldRdn);
    }

    @Test
    public void testModifyRdnAndDeleteOldWithChild() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        String oldOu = "Writers";
        String oldRdn = "ou=" + oldOu;
        Attributes attributes = this.getOrganizationalUnitAttributes(oldOu);
        DirContext createdCtx = ctx.createSubcontext(oldRdn, attributes);
        String childCn = "Tori Amos";
        String childRdn = "cn=" + childCn;
        Attributes childAttributes = this.getPersonAttributes("Amos", childCn);
        createdCtx.createSubcontext(childRdn, childAttributes);
        String newOu = "Singers";
        String newRdn = "ou=" + newOu;
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "true");
        ctx.rename(oldRdn, newRdn);
        try {
            ctx.lookup(oldRdn);
            Assert.fail((String)"Entry must not exist");
        }
        catch (NameNotFoundException ignored) {
            Assert.assertTrue((boolean)true);
        }
        DirContext org = (DirContext)ctx.lookup(newRdn);
        Assert.assertNotNull((Object)org);
        Attribute ou = org.getAttributes("").get("ou");
        Assert.assertTrue((boolean)ou.contains(newOu));
        Assert.assertTrue((!ou.contains(oldOu) ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)ou.size());
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        searchControls.setReturningAttributes(new String[]{"objectClass"});
        NamingEnumeration<SearchResult> results = org.search("", "(objectClass=*)", searchControls);
        Assert.assertTrue((boolean)results.hasMore());
        results.next();
        Assert.assertTrue((!results.hasMore() ? 1 : 0) != 0);
        DirContext tori = (DirContext)org.lookup(childRdn);
        Assert.assertNotNull((Object)tori);
        ctx.unbind(childRdn + "," + newRdn);
        ctx.unbind(newRdn);
    }

    @Test
    @Ignore
    public void testModifyRdnWithEncodedNewRdn() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        String cnVal = "Tori Amos";
        String snVal = "Amos";
        String oldRdn = "cn=" + cnVal;
        Attributes attributes = this.getPersonAttributes(snVal, cnVal);
        ctx.createSubcontext(oldRdn, attributes);
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "true");
        String newRdn = "cn=\\C3\\A4\\+";
        ctx.rename(oldRdn, newRdn);
        try {
            ctx.lookup(oldRdn);
            Assert.fail((String)"Entry must not exist");
        }
        catch (NameNotFoundException ignored) {
            // empty catch block
        }
        DirContext newCtx = (DirContext)ctx.lookup(newRdn);
        Assert.assertNotNull((Object)newCtx);
        Assert.assertEquals((Object)("cn=\\C3\\A4\\+," + ctx.getNameInNamespace()), (Object)newCtx.getNameInNamespace());
        Attribute cn = newCtx.getAttributes("").get("cn");
        Assert.assertEquals((String)"Number of cn occurences", (long)1L, (long)cn.size());
        String expectedCn = new String(new byte[]{-61, -92, 43}, "UTF-8");
        Assert.assertTrue((boolean)cn.contains(expectedCn));
        ctx.unbind(newRdn);
    }

    @Test
    @Ignore
    public void testModifyRdnWithEscapedPoundNewRdn() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        String cnVal = "Tori Amos";
        String snVal = "Amos";
        String oldRdn = "cn=" + cnVal;
        Attributes attributes = this.getPersonAttributes(snVal, cnVal);
        ctx.createSubcontext(oldRdn, attributes);
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "true");
        String newRdn = "cn=\\23test";
        ctx.rename(oldRdn, newRdn);
        try {
            ctx.lookup(oldRdn);
            Assert.fail((String)"Entry must not exist");
        }
        catch (NameNotFoundException ignored) {
            // empty catch block
        }
        DirContext newCtx = (DirContext)ctx.lookup(newRdn);
        Assert.assertNotNull((Object)newCtx);
        Assert.assertEquals((Object)("cn=\\23test," + ctx.getNameInNamespace()), (Object)newCtx.getNameInNamespace());
        Attribute cn = newCtx.getAttributes("").get("cn");
        Assert.assertEquals((String)"Number of cn occurences", (long)1L, (long)cn.size());
        Assert.assertTrue((boolean)cn.contains("\\#test"));
        ctx.unbind(newRdn);
    }

    @Test
    public void testModifyMultiValuedRdnVariant1() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        Attributes attributes = this.createPerson("cn");
        String oldRdn = this.getRdn(attributes, "cn");
        String newRdn = this.getRdn(attributes, "cn", "sn");
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        ctx.rename(oldRdn, newRdn);
        DirContext newCtx = (DirContext)ctx.lookup(newRdn);
        Assert.assertNotNull((Object)newCtx);
        Attribute cnAttr = newCtx.getAttributes("").get("cn");
        Assert.assertEquals((long)1L, (long)cnAttr.size());
        Assert.assertTrue((boolean)cnAttr.contains("Tori Amos"));
        Attribute snAttr = newCtx.getAttributes("").get("sn");
        Assert.assertEquals((long)1L, (long)snAttr.size());
        Assert.assertTrue((boolean)snAttr.contains("Amos"));
        Attribute descriptionAttr = newCtx.getAttributes("").get("description");
        Assert.assertEquals((long)1L, (long)descriptionAttr.size());
        ctx.unbind(newRdn);
    }

    @Test
    public void testModifyMultiValuedRdnVariant2() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        Attributes attributes = this.createPerson("cn");
        String oldRdn = this.getRdn(attributes, "cn");
        String newRdn = this.getRdn(attributes, "cn", "sn");
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "true");
        ctx.rename(oldRdn, newRdn);
        DirContext newCtx = (DirContext)ctx.lookup(newRdn);
        Assert.assertNotNull((Object)newCtx);
        Attribute cnAttr = newCtx.getAttributes("").get("cn");
        Assert.assertEquals((long)1L, (long)cnAttr.size());
        Assert.assertTrue((boolean)cnAttr.contains("Tori Amos"));
        Attribute snAttr = newCtx.getAttributes("").get("sn");
        Assert.assertEquals((long)1L, (long)snAttr.size());
        Assert.assertTrue((boolean)snAttr.contains("Amos"));
        Attribute descriptionAttr = newCtx.getAttributes("").get("description");
        Assert.assertEquals((long)1L, (long)descriptionAttr.size());
        ctx.unbind(newRdn);
    }

    @Test
    public void testModifyMultiValuedRdnVariant3() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        Attributes attributes = this.createPerson("description");
        String oldRdn = this.getRdn(attributes, "description");
        String newRdn = this.getRdn(attributes, "cn", "sn");
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        ctx.rename(oldRdn, newRdn);
        DirContext newCtx = (DirContext)ctx.lookup(newRdn);
        Assert.assertNotNull((Object)newCtx);
        Attribute cnAttr = newCtx.getAttributes("").get("cn");
        Assert.assertEquals((long)1L, (long)cnAttr.size());
        Assert.assertTrue((boolean)cnAttr.contains("Tori Amos"));
        Attribute snAttr = newCtx.getAttributes("").get("sn");
        Assert.assertEquals((long)1L, (long)snAttr.size());
        Assert.assertTrue((boolean)snAttr.contains("Amos"));
        Attribute descriptionAttr = newCtx.getAttributes("").get("description");
        Assert.assertEquals((long)1L, (long)descriptionAttr.size());
        ctx.unbind(newRdn);
    }

    @Test
    public void testModifyMultiValuedRdnVariant4() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        Attributes attributes = this.createPerson("description");
        String oldRdn = this.getRdn(attributes, "description");
        String newRdn = this.getRdn(attributes, "cn", "sn");
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "true");
        ctx.rename(oldRdn, newRdn);
        DirContext newCtx = (DirContext)ctx.lookup(newRdn);
        Assert.assertNotNull((Object)newCtx);
        Attribute cnAttr = newCtx.getAttributes("").get("cn");
        Assert.assertEquals((long)1L, (long)cnAttr.size());
        Assert.assertTrue((boolean)cnAttr.contains("Tori Amos"));
        Attribute snAttr = newCtx.getAttributes("").get("sn");
        Assert.assertEquals((long)1L, (long)snAttr.size());
        Assert.assertTrue((boolean)snAttr.contains("Amos"));
        Attribute descriptionAttr = newCtx.getAttributes("").get("description");
        Assert.assertNull((Object)descriptionAttr);
        ctx.unbind(newRdn);
    }

    @Test
    public void testModifyMultiValuedRdnVariant5() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        Attributes attributes = this.createPerson("cn");
        attributes.put("telephoneNumber", "12345");
        String oldRdn = this.getRdn(attributes, "cn");
        String newRdn = this.getRdn(attributes, "sn", "telephoneNumber");
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        ctx.rename(oldRdn, newRdn);
        DirContext newCtx = (DirContext)ctx.lookup(newRdn);
        Assert.assertNotNull((Object)newCtx);
        Attribute cnAttr = newCtx.getAttributes("").get("cn");
        Assert.assertEquals((long)1L, (long)cnAttr.size());
        Assert.assertTrue((boolean)cnAttr.contains("Tori Amos"));
        Attribute snAttr = newCtx.getAttributes("").get("sn");
        Assert.assertEquals((long)1L, (long)snAttr.size());
        Assert.assertTrue((boolean)snAttr.contains("Amos"));
        Attribute descriptionAttr = newCtx.getAttributes("").get("description");
        Assert.assertEquals((long)1L, (long)descriptionAttr.size());
        Attribute telephoneNumberAttr = newCtx.getAttributes("").get("telephoneNumber");
        Assert.assertEquals((long)1L, (long)telephoneNumberAttr.size());
        Assert.assertTrue((boolean)telephoneNumberAttr.contains("12345"));
        ctx.unbind(newRdn);
    }

    @Test
    public void testModifyMultiValuedRdnVariant6() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        Attributes attributes = this.createPerson("cn");
        attributes.put("telephoneNumber", "12345");
        String oldRdn = this.getRdn(attributes, "cn");
        String newRdn = this.getRdn(attributes, "sn", "telephoneNumber");
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "true");
        try {
            ctx.rename(oldRdn, newRdn);
            Assert.fail((String)"Rename must fail, cn can not be deleted from a person.");
        }
        catch (SchemaViolationException ignored) {
            // empty catch block
        }
        try {
            ctx.lookup(newRdn);
            Assert.fail((String)"Previous rename failed as expected, entry must not exist");
        }
        catch (NameNotFoundException ignored) {
            // empty catch block
        }
        DirContext oldCtx = (DirContext)ctx.lookup(oldRdn);
        Assert.assertNotNull((Object)oldCtx);
        Attribute cnAttr = oldCtx.getAttributes("").get("cn");
        Assert.assertEquals((long)1L, (long)cnAttr.size());
        Assert.assertTrue((boolean)cnAttr.contains("Tori Amos"));
        Attribute snAttr = oldCtx.getAttributes("").get("sn");
        Assert.assertEquals((long)1L, (long)snAttr.size());
        Assert.assertTrue((boolean)snAttr.contains("Amos"));
        Attribute descriptionAttr = oldCtx.getAttributes("").get("description");
        Assert.assertEquals((long)1L, (long)descriptionAttr.size());
        ctx.unbind(oldRdn);
    }

    @Test
    public void testModifyMultiValuedRdnVariant7() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        Attributes attributes = this.createPerson("cn", "sn");
        String oldRdn = this.getRdn(attributes, "cn", "sn");
        String newRdn = this.getRdn(attributes, "cn");
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        ctx.rename(oldRdn, newRdn);
        DirContext newCtx = (DirContext)ctx.lookup(newRdn);
        Assert.assertNotNull((Object)newCtx);
        Attribute cnAttr = newCtx.getAttributes("").get("cn");
        Assert.assertEquals((long)1L, (long)cnAttr.size());
        Assert.assertTrue((boolean)cnAttr.contains("Tori Amos"));
        Attribute snAttr = newCtx.getAttributes("").get("sn");
        Assert.assertEquals((long)1L, (long)snAttr.size());
        Assert.assertTrue((boolean)snAttr.contains("Amos"));
        Attribute descriptionAttr = newCtx.getAttributes("").get("description");
        Assert.assertEquals((long)1L, (long)descriptionAttr.size());
        ctx.unbind(newRdn);
    }

    @Test
    public void testModifyMultiValuedRdnVariant8() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        Attributes attributes = this.createPerson("cn", "sn");
        String oldRdn = this.getRdn(attributes, "cn", "sn");
        String newRdn = this.getRdn(attributes, "cn");
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "true");
        try {
            ctx.rename(oldRdn, newRdn);
            Assert.fail((String)"Rename must fail, cn can not be deleted from a person.");
        }
        catch (SchemaViolationException ignored) {
            // empty catch block
        }
        try {
            ctx.lookup(newRdn);
            Assert.fail((String)"Previous rename failed as expected, entry must not exist");
        }
        catch (NameNotFoundException ignored) {
            // empty catch block
        }
        DirContext oldCtx = (DirContext)ctx.lookup(oldRdn);
        Assert.assertNotNull((Object)oldCtx);
        Attribute cnAttr = oldCtx.getAttributes("").get("cn");
        Assert.assertEquals((long)1L, (long)cnAttr.size());
        Assert.assertTrue((boolean)cnAttr.contains("Tori Amos"));
        Attribute snAttr = oldCtx.getAttributes("").get("sn");
        Assert.assertEquals((long)1L, (long)snAttr.size());
        Assert.assertTrue((boolean)snAttr.contains("Amos"));
        Attribute descriptionAttr = oldCtx.getAttributes("").get("description");
        Assert.assertEquals((long)1L, (long)descriptionAttr.size());
        ctx.unbind(oldRdn);
    }

    @Test
    public void testModifyRdnOperationalAttribute() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        Attributes attributes = this.createPerson("cn");
        String oldRdn = this.getRdn(attributes, "cn");
        String createTimestamp = (String)ctx.getAttributes(oldRdn, new String[]{"createTimestamp"}).get("createTimestamp").get();
        String newRdn = "createTimestamp=" + createTimestamp;
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        ctx.rename(oldRdn, newRdn);
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "true");
        try {
            ctx.rename(newRdn, oldRdn);
            Assert.fail((String)"Rename must fail, operational attribute createTimestamp can not be deleted.");
        }
        catch (NoPermissionException ignored) {
            // empty catch block
        }
        ctx.unbind(newRdn);
    }

    @Test
    public void testModifyRdnObjectClassAttribute() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        Attributes attributes = this.createPerson("cn");
        String oldRdn = this.getRdn(attributes, "cn");
        String newRdn = "objectClass=person";
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        ctx.rename(oldRdn, newRdn);
        ctx.addToEnvironment("java.naming.ldap.deleteRDN", "true");
        try {
            ctx.rename(newRdn, oldRdn);
            Assert.fail((String)"Rename must fail, structural objectClass person can not be deleted.");
        }
        catch (SchemaViolationException ignored) {
            // empty catch block
        }
        ctx.unbind(newRdn);
    }

    private String getRdn(Attributes attributes, String ... rdnTypes) throws Exception {
        String rdn = "";
        for (String type : rdnTypes) {
            rdn = rdn + type + "=" + attributes.get(type).get() + "+";
        }
        rdn = rdn.substring(0, rdn.length() - 1);
        return rdn;
    }

    private Attributes createPerson(String ... rdnTypes) throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyRdnIT.getLdapServer()).lookup(BASE);
        Attributes attributes = LdifUtils.createJndiAttributes((Object[])new Object[]{"objectClass: top", "objectClass: person", "cn: Tori Amos", "sn: Amos", "description: Tori Amos is a person."});
        String rdn = this.getRdn(attributes, rdnTypes);
        ctx.createSubcontext(rdn, attributes);
        return attributes;
    }
}

