/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.modify;

import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: cn=Tori Amos,ou=system", "objectClass: inetOrgPerson", "objectClass: organizationalPerson", "objectClass: person", "objectClass: top", "description: an American singer-songwriter", "cn: Tori Amos", "sn: Amos", "dn: cn=Debbie Harry,ou=system", "objectClass: inetOrgPerson", "objectClass: organizationalPerson", "objectClass: person", "objectClass: top", "cn: Debbie Harry", "sn: Harry"})
public class ModifyMultipleChangesIT
extends AbstractLdapTestUnit {
    private static final String BASE = "ou=system";
    private static final String RDN_TORI_AMOS = "cn=Tori Amos";

    protected Attributes getPersonAttributes(String sn, String cn) {
        BasicAttributes attributes = new BasicAttributes(true);
        BasicAttribute attribute = new BasicAttribute("objectClass");
        attribute.add("top");
        attribute.add("person");
        attribute.add("organizationalperson");
        attribute.add("inetorgperson");
        attributes.put(attribute);
        attributes.put("cn", cn);
        attributes.put("sn", sn);
        return attributes;
    }

    @Test
    public void testAddNewAttributeValues() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyMultipleChangesIT.getLdapServer()).lookup(BASE);
        String[] newValues = new String[]{"1234567890", "999999999"};
        Attribute attr = new BasicAttribute("telephoneNumber");
        attr.add(newValues[0]);
        attr.add(newValues[1]);
        Attributes attrs = new BasicAttributes(true);
        attrs.put(attr);
        ctx.modifyAttributes(RDN_TORI_AMOS, 1, attrs);
        attrs = ctx.getAttributes(RDN_TORI_AMOS);
        attr = attrs.get("telephoneNumber");
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((Object)"telephoneNumber", (Object)attr.getID());
        Assert.assertTrue((boolean)attr.contains(newValues[0]));
        Assert.assertTrue((boolean)attr.contains(newValues[1]));
        Assert.assertEquals((long)newValues.length, (long)attr.size());
    }

    @Test
    public void testAttributeValueMultiMofificationDIRSERVER_636() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyMultipleChangesIT.getLdapServer()).lookup(BASE);
        Attributes attrs = this.getPersonAttributes("Bush", "Kate Bush");
        String rdn = "cn=Kate Bush";
        ctx.createSubcontext(rdn, attrs);
        String[] descriptions = new String[]{"Kate Bush is a British singer-songwriter.", "She has become one of the most influential female artists of the twentieth century."};
        BasicAttribute desc1 = new BasicAttribute("description");
        desc1.add(descriptions[0]);
        desc1.add(descriptions[1]);
        ModificationItem addModOp = new ModificationItem(1, desc1);
        BasicAttribute desc2 = new BasicAttribute("description");
        desc2.add(descriptions[1]);
        ModificationItem delModOp = new ModificationItem(3, desc2);
        ctx.modifyAttributes(rdn, new ModificationItem[]{addModOp, delModOp});
        SearchControls sctls = new SearchControls();
        sctls.setSearchScope(2);
        String filter = "(cn=*Bush)";
        String base = "";
        NamingEnumeration<SearchResult> enm = ctx.search(base, filter, sctls);
        Assert.assertTrue((boolean)enm.hasMore());
        while (enm.hasMore()) {
            SearchResult sr = enm.next();
            attrs = sr.getAttributes();
            Attribute desc = sr.getAttributes().get("description");
            Assert.assertEquals((long)1L, (long)desc.size());
            Assert.assertTrue((boolean)desc.contains(descriptions[0]));
        }
        ctx.destroySubcontext(rdn);
    }
}

