/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.lookup;

import java.util.Hashtable;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.util.JndiUtils;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class LookupPerfIT
extends AbstractLdapTestUnit {
    @Test
    public void testLookupPerfAPI() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)LookupPerfIT.getLdapServer());
        Entry entry = connection.lookup("uid=admin,ou=system");
        Assert.assertNotNull((Object)entry);
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < 50; ++i) {
            for (int j = 0; j < 10000; ++j) {
                entry = connection.lookup("uid=admin,ou=system");
            }
            System.out.print(".");
        }
        long t1 = System.currentTimeMillis();
        System.out.println("Delta : " + (t1 - t0));
        connection.close();
    }

    public static LdapContext getWiredContext(LdapServer ldapServer, Control[] controls) throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + ldapServer.getPort());
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        return new InitialLdapContext(env, JndiUtils.toJndiControls((LdapApiService)ldapServer.getDirectoryService().getLdapCodecService(), (Control[])controls));
    }

    @Test
    @Ignore
    public void testLookupPerfJNDI() throws Exception {
        LdapContext ctx = LookupPerfIT.getWiredContext(ldapServer, null);
        Attributes result = ctx.getAttributes("uid=admin,ou=system");
        Assert.assertNotNull((Object)result);
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < 50; ++i) {
            for (int j = 0; j < 10000; ++j) {
                ctx.getAttributes("uid=admin,ou=system");
            }
            System.out.print(".");
        }
        long t1 = System.currentTimeMillis();
        System.out.println("Delta : " + (t1 - t0));
        ctx.close();
    }
}

