/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.extended;

import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicy;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyErrorEnum;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyImpl;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyDecorator;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyRequestImpl;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyResponse;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddRequestImpl;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.authn.ppolicy.CheckQualityEnum;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyConfiguration;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authn.ppolicy.PpolicyConfigContainer;
import org.apache.directory.server.core.hash.Sha512PasswordHashingInterceptor;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.extended.PwdModifyHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")}, extendedOpHandlers={PwdModifyHandler.class}, allowAnonymousAccess=true)
@CreateDS(enableChangeLog=false, name="PasswordPolicyTest", additionalInterceptors={Sha512PasswordHashingInterceptor.class})
public class PwdModifyIT
extends AbstractLdapTestUnit {
    private static final LdapApiService codec = LdapApiServiceFactory.getSingleton();
    private static final PasswordPolicyDecorator PP_REQ_CTRL = new PasswordPolicyDecorator(codec, (PasswordPolicy)new PasswordPolicyImpl());
    private PasswordPolicyConfiguration policyConfig;

    private PasswordPolicy getPwdRespCtrl(Response resp) throws Exception {
        Control control = (Control)resp.getControls().get(PP_REQ_CTRL.getOid());
        if (control == null) {
            return null;
        }
        return (PasswordPolicy)((PasswordPolicyDecorator)control).getDecorated();
    }

    private void addUser(LdapConnection adminConnection, String user, Object password) throws Exception {
        DefaultEntry userEntry = new DefaultEntry("cn=" + user + ",ou=system", new Object[]{"ObjectClass: top", "ObjectClass: person", "cn", user, "sn", user + "_sn", "userPassword", password});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = adminConnection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNull((Object)respCtrl);
    }

    private void checkBind(LdapConnection connection, Dn userDn, String password, int nbIterations, String expectedMessage) throws Exception {
        for (int i = 0; i < nbIterations; ++i) {
            try {
                connection.bind(userDn, password);
                continue;
            }
            catch (LdapAuthenticationException le) {
                Assert.assertEquals((Object)expectedMessage, (Object)le.getMessage());
            }
        }
    }

    private void safeCloseConnections(LdapConnection ... connections) {
        for (LdapConnection connection : connections) {
            if (connection == null) continue;
            try {
                connection.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Before
    public void setPwdPolicy() throws LdapException {
        this.policyConfig = new PasswordPolicyConfiguration();
        this.policyConfig.setPwdMaxAge(110);
        this.policyConfig.setPwdFailureCountInterval(30);
        this.policyConfig.setPwdMaxFailure(3);
        this.policyConfig.setPwdLockout(true);
        this.policyConfig.setPwdLockoutDuration(0);
        this.policyConfig.setPwdMinLength(5);
        this.policyConfig.setPwdInHistory(5);
        this.policyConfig.setPwdExpireWarning(600);
        this.policyConfig.setPwdGraceAuthNLimit(5);
        this.policyConfig.setPwdCheckQuality(CheckQualityEnum.CHECK_REJECT);
        PpolicyConfigContainer policyContainer = new PpolicyConfigContainer();
        policyContainer.setDefaultPolicy(this.policyConfig);
        AuthenticationInterceptor authenticationInterceptor = (AuthenticationInterceptor)PwdModifyIT.getService().getInterceptor(InterceptorEnum.AUTHENTICATION_INTERCEPTOR.getName());
        authenticationInterceptor.setPwdPolicies(policyContainer);
    }

    @Test
    public void testModifyOwnPasswordConnected() throws Exception {
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        this.addUser(adminConnection, "User1", "secret1");
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)PwdModifyIT.getLdapServer(), (String)"cn=user1,ou=system", (String)"secret1");
        userConnection.setTimeOut(0L);
        PasswordModifyRequestImpl pwdModifyRequest = new PasswordModifyRequestImpl();
        pwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"secret1Bis"));
        PasswordModifyResponse pwdModifyResponse = (PasswordModifyResponse)userConnection.extended((ExtendedRequest)pwdModifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)pwdModifyResponse.getLdapResult().getResultCode());
        userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User1,ou=system", (String)"secret1Bis");
        Entry entry = userConnection.lookup("cn=User1,ou=system");
        Assert.assertNotNull((Object)entry);
        userConnection.close();
        adminConnection.close();
    }

    @Test
    public void testModifyUserPasswordAnonymous() throws Exception {
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        this.addUser(adminConnection, "User2", "secret2");
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User2,ou=system", (String)"secret2");
        Entry entry = userConnection.lookup("cn=User2,ou=system");
        Assert.assertNotNull((Object)entry);
        userConnection.close();
        LdapConnection anonymousConnection = IntegrationUtils.getAnonymousNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        anonymousConnection.setTimeOut(0L);
        PasswordModifyRequestImpl pwdModifyRequest = new PasswordModifyRequestImpl();
        pwdModifyRequest.setUserIdentity(Strings.getBytesUtf8((String)"cn=User2,ou=system"));
        pwdModifyRequest.setOldPassword(Strings.getBytesUtf8((String)"secret2"));
        pwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"secret2Bis"));
        PasswordModifyResponse pwdModifyResponse = (PasswordModifyResponse)anonymousConnection.extended((ExtendedRequest)pwdModifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)pwdModifyResponse.getLdapResult().getResultCode());
        userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User2,ou=system", (String)"secret2Bis");
        entry = userConnection.lookup("cn=User2,ou=system");
        Assert.assertNotNull((Object)entry);
        userConnection.close();
        anonymousConnection.close();
        adminConnection.close();
    }

    @Test
    public void testModifyUserPasswordAnonymousPPActivated() throws Exception {
        this.policyConfig.setPwdCheckQuality(CheckQualityEnum.CHECK_ACCEPT);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        this.addUser(adminConnection, "User3", "secret3");
        Dn userDn = new Dn(new String[]{"cn=User3,ou=system"});
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User3,ou=system", (String)"secret3");
        Entry entry = userConnection.lookup("cn=User3,ou=system");
        Assert.assertNotNull((Object)entry);
        userConnection.close();
        this.checkBind(userConnection, userDn, "badPassword", 2, "INVALID_CREDENTIALS: Bind failed: ERR_229 Cannot authenticate user cn=User3,ou=system");
        LdapConnection anonymousConnection = IntegrationUtils.getAnonymousNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        anonymousConnection.setTimeOut(0L);
        PasswordModifyRequestImpl pwdModifyRequest = new PasswordModifyRequestImpl();
        pwdModifyRequest.setUserIdentity(Strings.getBytesUtf8((String)"cn=User3,ou=system"));
        pwdModifyRequest.setOldPassword(Strings.getBytesUtf8((String)"secret3"));
        pwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"secret3Bis"));
        PasswordModifyResponse pwdModifyResponse = (PasswordModifyResponse)anonymousConnection.extended((ExtendedRequest)pwdModifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)pwdModifyResponse.getLdapResult().getResultCode());
        userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User3,ou=system", (String)"secret3Bis");
        entry = userConnection.lookup("cn=User3,ou=system");
        Assert.assertNotNull((Object)entry);
        this.checkBind(userConnection, userDn, "badPassword", 2, "INVALID_CREDENTIALS: Bind failed: ERR_229 Cannot authenticate user cn=User3,ou=system");
        userConnection.close();
        anonymousConnection.close();
        adminConnection.close();
    }

    @Test
    public void testAdminModifyPassword() throws Exception {
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        this.addUser(adminConnection, "User4", "secret4");
        PasswordModifyRequestImpl pwdModifyRequest = new PasswordModifyRequestImpl();
        pwdModifyRequest.setUserIdentity(Strings.getBytesUtf8((String)"cn=User4,ou=system"));
        pwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"secret4Bis"));
        PasswordModifyResponse pwdModifyResponse = (PasswordModifyResponse)adminConnection.extended((ExtendedRequest)pwdModifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)pwdModifyResponse.getLdapResult().getResultCode());
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User4,ou=system", (String)"secret4Bis");
        Entry entry = userConnection.lookup("cn=User4,ou=system");
        Assert.assertNotNull((Object)entry);
        userConnection.close();
        adminConnection.close();
    }

    @Test
    public void testAdminModifyPasswordBadUser() throws Exception {
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        this.addUser(adminConnection, "User5", "secret5");
        PasswordModifyRequestImpl pwdModifyRequest = new PasswordModifyRequestImpl();
        pwdModifyRequest.setUserIdentity(Strings.getBytesUtf8((String)"cn=baduser,ou=system"));
        pwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"secret5Bis"));
        PasswordModifyResponse pwdModifyResponse = (PasswordModifyResponse)adminConnection.extended((ExtendedRequest)pwdModifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.NO_SUCH_OBJECT, (Object)pwdModifyResponse.getLdapResult().getResultCode());
        Assert.assertEquals((Object)"Cannot find an entry for DN cn=baduser,ou=system", (Object)pwdModifyResponse.getLdapResult().getDiagnosticMessage());
        adminConnection.close();
    }

    @Test
    public void testAdminGenPassword() throws Exception {
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        this.addUser(adminConnection, "User6", "secret6");
        PasswordModifyRequestImpl pwdModifyRequest = new PasswordModifyRequestImpl();
        pwdModifyRequest.setUserIdentity(Strings.getBytesUtf8((String)"cn=User6,ou=system"));
        PasswordModifyResponse pwdModifyResponse = (PasswordModifyResponse)adminConnection.extended((ExtendedRequest)pwdModifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.UNWILLING_TO_PERFORM, (Object)pwdModifyResponse.getLdapResult().getResultCode());
        adminConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyPasswordTooSoon() throws Exception {
        LdapConnection adminConnection = null;
        LdapConnection userConnection = null;
        int minAge = this.policyConfig.getPwdMinAge();
        try {
            this.policyConfig.setPwdMinAge(1000);
            adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
            this.addUser(adminConnection, "User7", "secret7");
            Entry userEntry = adminConnection.lookup("cn=User7,ou=system", new String[]{"*", "+"});
            Attribute attribute = userEntry.get("pwdHistory");
            Assert.assertEquals((long)1L, (long)attribute.size());
            PasswordModifyRequestImpl pwdModifyRequest = null;
            PasswordModifyResponse pwdModifyResponse = null;
            try {
                userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)PwdModifyIT.getLdapServer(), (String)"cn=User7,ou=system", (String)"secret7");
                pwdModifyRequest = new PasswordModifyRequestImpl();
                pwdModifyRequest.setUserIdentity(Strings.getBytesUtf8((String)"cn=User7,ou=system"));
                pwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"secret4Bis"));
                pwdModifyResponse = (PasswordModifyResponse)userConnection.extended((ExtendedRequest)pwdModifyRequest);
                Assert.assertNotEquals((Object)ResultCodeEnum.SUCCESS, (Object)pwdModifyResponse.getLdapResult().getResultCode());
            }
            catch (Throwable throwable) {
                this.safeCloseConnections(userConnection);
                throw throwable;
            }
            this.safeCloseConnections(userConnection);
            pwdModifyRequest = new PasswordModifyRequestImpl();
            pwdModifyRequest.setUserIdentity(Strings.getBytesUtf8((String)"cn=User7,ou=system"));
            pwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"secret4Bis"));
            pwdModifyResponse = (PasswordModifyResponse)adminConnection.extended((ExtendedRequest)pwdModifyRequest);
            Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)pwdModifyResponse.getLdapResult().getResultCode());
            userEntry = adminConnection.lookup("cn=User7,ou=system", new String[]{"*", "+"});
            attribute = userEntry.get("pwdHistory");
            Assert.assertEquals((long)2L, (long)attribute.size());
            userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User7,ou=system", (String)"secret4Bis");
            Entry entry = userConnection.lookup("cn=User7,ou=system");
            Assert.assertNotNull((Object)entry);
        }
        catch (Throwable throwable) {
            this.policyConfig.setPwdMinAge(minAge);
            this.safeCloseConnections(userConnection, adminConnection);
            throw throwable;
        }
        this.policyConfig.setPwdMinAge(minAge);
        this.safeCloseConnections(userConnection, adminConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyUserPasswordWithPasswordPolicyControl() throws Exception {
        this.policyConfig.setPwdCheckQuality(CheckQualityEnum.CHECK_ACCEPT);
        this.policyConfig.setPwdMinLength(5);
        this.policyConfig.setPwdMinAge(5);
        LdapConnection adminConnection = null;
        LdapConnection userConnection = null;
        try {
            adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
            adminConnection.setTimeOut(Long.MAX_VALUE);
            this.addUser(adminConnection, "UserXY", "secret3");
            Dn userDn = new Dn(new String[]{"cn=UserXY,ou=system"});
            userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)userDn.toString(), (String)"secret3");
            PasswordPolicyDecorator passwordPolicyRequestControl = new PasswordPolicyDecorator(LdapApiServiceFactory.getSingleton(), (PasswordPolicy)new PasswordPolicyImpl());
            PasswordModifyRequestImpl selfPwdModifyRequest = new PasswordModifyRequestImpl();
            selfPwdModifyRequest.setUserIdentity(Dn.getBytes((Dn)userDn));
            selfPwdModifyRequest.setOldPassword(Strings.getBytesUtf8((String)"secret3"));
            selfPwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"1234567"));
            selfPwdModifyRequest.addControl((Control)passwordPolicyRequestControl);
            PasswordModifyResponse pwdModifyResponse = (PasswordModifyResponse)userConnection.extended((ExtendedRequest)selfPwdModifyRequest);
            Assert.assertEquals((Object)ResultCodeEnum.CONSTRAINT_VIOLATION, (Object)pwdModifyResponse.getLdapResult().getResultCode());
            Control passwordPolicyResponseControl = pwdModifyResponse.getControl(passwordPolicyRequestControl.getOid());
            Assert.assertNotNull((Object)passwordPolicyResponseControl);
            Assert.assertEquals((Object)PasswordPolicyErrorEnum.PASSWORD_TOO_YOUNG, (Object)((PasswordPolicy)((PasswordPolicyDecorator)passwordPolicyResponseControl).getDecorated()).getResponse().getPasswordPolicyError());
            this.addUser(adminConnection, "UserZZ", "secret4");
            Dn otherUserDn = new Dn(new String[]{"cn=UserZZ,ou=system"});
            PasswordModifyRequestImpl pwdModifyRequest = new PasswordModifyRequestImpl();
            pwdModifyRequest.setUserIdentity(Dn.getBytes((Dn)otherUserDn));
            pwdModifyRequest.setOldPassword(Strings.getBytesUtf8((String)"secret4"));
            pwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"1234567"));
            pwdModifyResponse = (PasswordModifyResponse)userConnection.extended((ExtendedRequest)pwdModifyRequest);
            Assert.assertEquals((Object)ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS, (Object)pwdModifyResponse.getLdapResult().getResultCode());
        }
        finally {
            adminConnection.close();
            userConnection.close();
        }
    }

    @Test
    public void testModifyPasswordStoredAsHash() throws Exception {
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        byte[] password = "secret1".getBytes();
        byte[] credHash = PasswordUtil.createStoragePassword((byte[])password, (LdapSecurityConstants)LdapSecurityConstants.HASH_METHOD_SHA256);
        this.addUser(adminConnection, "User11", credHash);
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)PwdModifyIT.getLdapServer(), (String)"cn=user11,ou=system", (String)"secret1");
        userConnection.setTimeOut(0L);
        PasswordModifyRequestImpl pwdModifyRequest = new PasswordModifyRequestImpl();
        pwdModifyRequest.setOldPassword(password);
        pwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"secret1Bis"));
        PasswordModifyResponse pwdModifyResponse = (PasswordModifyResponse)userConnection.extended((ExtendedRequest)pwdModifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)pwdModifyResponse.getLdapResult().getResultCode());
        userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User11,ou=system", (String)"secret1Bis");
        userConnection.loadSchema();
        Entry entry = userConnection.lookup("cn=User11,ou=system", SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Assert.assertNotNull((Object)entry);
        Attribute at = entry.get("userPassword");
        Assert.assertEquals((Object)LdapSecurityConstants.HASH_METHOD_SHA512, (Object)PasswordUtil.findAlgorithm((byte[])at.getBytes()));
        userConnection.close();
        adminConnection.close();
    }
}

