/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.bind;

import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.CreateAuthenticator;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.authn.DelegatingAuthenticator;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.ldap.handlers.extended.StartTlsHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(allowAnonAccess=true, name="DelegatedAuthIT-class", authenticators={@CreateAuthenticator(type=DelegatingAuthenticator.class, delegateHost="localhost", delegatePort=10201, delegateSsl=false, delegateTls=true)})
@ApplyLdifs(value={"dn: uid=emmanuel,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: emmanuel", "cn: Emmanuel Lecharny", "sn: Lecharny", "userPassword: sesame"})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=10200)}, allowAnonymousAccess=true)
public class DelegatedAuthOverTlsIT
extends AbstractLdapTestUnit {
    @CreateDS(allowAnonAccess=true, name="DelegatedAuthIT-method")
    @ApplyLdifs(value={"dn: uid=antoine,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: antoine", "cn: Antoine Levy-Lambert", "sn: Levy-Lambert", "userPassword: secret"})
    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=10201)}, extendedOpHandlers={StartTlsHandler.class})
    @Test
    public void testDelegatedTlsAuthentication() throws Exception {
        Assert.assertTrue((boolean)DelegatedAuthOverTlsIT.getService().isStarted());
        Assert.assertEquals((Object)"DelegatedAuthIT-method", (Object)DelegatedAuthOverTlsIT.getService().getInstanceId());
        LdapNetworkConnection ldapConnection = new LdapNetworkConnection("localhost", 10200);
        ldapConnection.setTimeOut(0L);
        ldapConnection.bind("uid=antoine,ou=users,ou=system", "secret");
        Assert.assertTrue((boolean)ldapConnection.isAuthenticated());
        ldapConnection.unBind();
        try {
            ldapConnection.bind("uid=antoine,ou=users,ou=system", "sesame");
            Assert.fail();
        }
        catch (LdapAuthenticationException lae) {
            Assert.assertTrue((boolean)true);
        }
        ldapConnection.unBind();
        ldapConnection.close();
    }
}

