/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.bind;

import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.CreateAuthenticator;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.authn.DelegatingAuthenticator;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(allowAnonAccess=true, name="DelegatedAuthIT-class", authenticators={@CreateAuthenticator(type=DelegatingAuthenticator.class, delegateHost="localhost", delegatePort=10201, delegateSsl=false)})
@ApplyLdifs(value={"dn: uid=emmanuel,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: emmanuel", "cn: Emmanuel Lecharny", "sn: Lecharny", "userPassword: sesame"})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=10200)}, allowAnonymousAccess=true)
public class DelegatedAuthIT
extends AbstractLdapTestUnit {
    @CreateDS(allowAnonAccess=true, name="DelegatedAuthIT-method")
    @ApplyLdifs(value={"dn: uid=antoine,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: antoine", "cn: Antoine Levy-Lambert", "sn: Levy-Lambert", "userPassword: secret"})
    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=10201)})
    @Test
    public void testDelegatedAuthentication() throws Exception {
        Assert.assertTrue((boolean)DelegatedAuthIT.getService().isStarted());
        Assert.assertEquals((Object)"DelegatedAuthIT-method", (Object)DelegatedAuthIT.getService().getInstanceId());
        LdapNetworkConnection ldapConnection = new LdapNetworkConnection("localhost", 10200);
        ldapConnection.setTimeOut(0L);
        ldapConnection.bind("uid=antoine,ou=users,ou=system", "secret");
        Assert.assertTrue((boolean)ldapConnection.isAuthenticated());
        ldapConnection.unBind();
        try {
            ldapConnection.bind("uid=antoine,ou=users,ou=system", "sesame");
            Assert.fail();
        }
        catch (LdapAuthenticationException lae) {
            Assert.assertTrue((boolean)true);
        }
        ldapConnection.unBind();
        try {
            ldapConnection.bind("uid=ivanhoe,ou=users,ou=system", "secret");
            Assert.fail();
        }
        catch (Exception exc) {
            Assert.assertTrue((boolean)true);
        }
        ldapConnection.unBind();
        ldapConnection.close();
    }

    @CreateDS(allowAnonAccess=true, name="DelegatedAuthIT-MultipleAuthenticators-method")
    @ApplyLdifs(value={"dn: uid=antoine,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: antoine", "cn: Antoine Levy-Lambert", "sn: Levy-Lambert", "userPassword: secret"})
    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=10201)}, allowAnonymousAccess=true)
    @Test
    public void testMultipleAuthenticators() throws Exception {
        Assert.assertTrue((boolean)DelegatedAuthIT.getService().isStarted());
        Assert.assertEquals((Object)"DelegatedAuthIT-MultipleAuthenticators-method", (Object)DelegatedAuthIT.getService().getInstanceId());
        LdapNetworkConnection ldapConnection = new LdapNetworkConnection("localhost", 10200);
        ldapConnection.setTimeOut(0L);
        ldapConnection.bind("uid=emmanuel,ou=users,ou=system", "sesame");
        Assert.assertTrue((boolean)ldapConnection.isAuthenticated());
        ldapConnection.unBind();
        try {
            ldapConnection.bind("uid=emmanuel,ou=users,ou=system", "crypto");
            Assert.fail();
        }
        catch (LdapAuthenticationException lae) {
            Assert.assertTrue((boolean)true);
        }
        ldapConnection.unBind();
        ldapConnection.bind();
        Assert.assertTrue((boolean)ldapConnection.isAuthenticated());
        ldapConnection.unBind();
        ldapConnection.bind("uid=antoine,ou=users,ou=system", "secret");
        Assert.assertTrue((boolean)ldapConnection.isAuthenticated());
        ldapConnection.unBind();
        try {
            ldapConnection.bind("uid=antoine,ou=users,ou=system", "sesame");
        }
        catch (LdapAuthenticationException lae) {
            Assert.assertTrue((boolean)true);
        }
        ldapConnection.unBind();
        try {
            try {
                ldapConnection.bind("uid=ivanhoe,ou=users,ou=system", "secret");
            }
            catch (LdapAuthenticationException lae) {
                Assert.assertTrue((boolean)true);
            }
            ldapConnection.unBind();
        }
        catch (Exception exc) {
            Assert.assertTrue((boolean)true);
        }
        ldapConnection.close();
    }
}

