/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.add;

import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@CreateDS(name="AddPerfDS", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\ndc: example\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="cn")})}, enableChangeLog=false)
public class AddPerfIT
extends AbstractLdapTestUnit {
    @Test
    public void testAddPerf() throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", AddPerfIT.getLdapServer().getPort());
        Dn dn = new Dn(new String[]{"cn=test,dc=example,dc=com"});
        DefaultEntry entry = new DefaultEntry(AddPerfIT.getService().getSchemaManager(), dn, new Object[]{"ObjectClass: top", "ObjectClass: person", "sn: TEST", "cn: test"});
        connection.bind("uid=admin,ou=system", "secret");
        connection.add((Entry)entry);
        int nbIterations = 15000;
        long t0 = System.currentTimeMillis();
        long t00 = 0L;
        long tt0 = System.currentTimeMillis();
        for (int i = 0; i < nbIterations; ++i) {
            if (i % 100 == 0) {
                long tt1 = System.currentTimeMillis();
                System.out.println(i + ", " + (tt1 - tt0));
                tt0 = tt1;
            }
            if (i == 5000) {
                t00 = System.currentTimeMillis();
            }
            String name = "test" + i;
            dn = new Dn(new String[]{"cn=" + name + ",dc=example,dc=com"});
            entry = new DefaultEntry(AddPerfIT.getService().getSchemaManager(), dn, new Object[]{"ObjectClass: top", "ObjectClass: person", "sn", name.toUpperCase(), "cn", name});
            long ttt0 = System.nanoTime();
            connection.add((Entry)entry);
            long ttt1 = System.nanoTime();
        }
        long t1 = System.currentTimeMillis();
        Long deltaWarmed = t1 - t00;
        System.out.println("Delta : " + deltaWarmed + "( " + (long)((nbIterations - 5000) * 1000) / deltaWarmed + " per s ) /" + (t1 - t0));
        int nbFound = 0;
        long t2 = System.currentTimeMillis();
        EntryCursor result = connection.search("dc=example,dc=com", "(sn=test123*)", SearchScope.SUBTREE, new String[]{"*"});
        while (result.next()) {
            Entry res = (Entry)result.get();
            System.out.println(res.getDn());
            ++nbFound;
        }
        result.close();
        long t3 = System.currentTimeMillis();
        System.out.println("Delta search : " + (t3 - t2) + " for " + nbFound + " entries");
        connection.close();
    }
}

