/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.admin;

import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-AC", "administrativeRole: accessControlSpecificArea", "", "dn: ou=SAP-CA,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CA", "administrativeRole: collectiveAttributeSpecificArea", "", "dn: ou=AAP,ou=SAP-CA,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=IAP-CA,ou=AAP,ou=SAP-CA,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CA", "administrativeRole: collectiveAttributeInnerArea", "", "dn: ou=IAP-AC,ou=AAP,ou=SAP-CA,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-AC", "administrativeRole: accessControlInnerArea", "", "dn: ou=IAP-TE,ou=AAP,ou=SAP-CA,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-TE", "administrativeRole: triggerExecutionInnerArea", "", "dn: ou=AAP,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=AAP,ou=AAP,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=SAP-AC,ou=AAP,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-AC", "administrativeRole: accessControlSpecificArea", "", "dn: ou=SAP-CA,ou=AAP,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CA", "administrativeRole: collectiveAttributeSpecificArea", "", "dn: ou=IAP-AC,ou=AAP,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-AC", "administrativeRole: accessControlInnerArea", "", "dn: ou=IAP-CA,ou=AAP,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CA", "administrativeRole: collectiveAttributeInnerArea", "", "dn: ou=AAP,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=AAP,ou=AAP,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=AAP,ou=AAP,ou=AAP,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=SAP-CA,ou=AAP,ou=AAP,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CA", "administrativeRole: collectiveAttributeSpecificArea", "", "dn: ou=IAP-CA,ou=AAP,ou=AAP,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CA", "administrativeRole: collectiveAttributeInnerArea", "", "dn: ou=AAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP1", "administrativeRole: autonomousArea", "", "dn: ou=AAP,ou=AAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=SAP-CA,ou=AAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CA", "administrativeRole: collectiveAttributeSpecificArea", "", "", "dn: ou=IAP-CA,ou=AAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CA", "administrativeRole: collectiveAttributeInnerArea", ""})
public class AdministrativePointModifyDelIT
extends AbstractLdapTestUnit {
    private static LdapConnection connection;
    private static SchemaManager schemaManager;

    @Before
    public void init() throws Exception {
        connection = IntegrationUtils.getAdminConnection((DirectoryService)AdministrativePointModifyDelIT.getService());
        schemaManager = AdministrativePointModifyDelIT.getLdapServer().getDirectoryService().getSchemaManager();
    }

    @After
    public void shutdown() throws Exception {
        connection.close();
    }

    private Attribute getAdminRole(String dn) throws Exception {
        Entry lookup = connection.lookup(dn, new String[]{"administrativeRole"});
        Assert.assertNotNull((Object)lookup);
        return lookup.get("administrativeRole");
    }

    @Test
    @Ignore
    public void testModifyRemoveAAP() throws Exception {
        Assert.assertTrue((boolean)AdministrativePointModifyDelIT.getLdapServer().isStarted());
        DefaultModification modification = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, (Attribute)new DefaultAttribute("administrativeRole"));
        try {
            connection.modify("ou=AAP,ou=SAP-CA,ou=SAP-AC,ou=system", new Modification[]{modification});
            Assert.fail();
        }
        catch (LdapUnwillingToPerformException lutpe) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testDeleteSAP() throws Exception {
        Assert.assertTrue((boolean)AdministrativePointModifyDelIT.getLdapServer().isStarted());
    }

    @Test
    public void testDeleteIAP() throws Exception {
        Assert.assertTrue((boolean)AdministrativePointModifyDelIT.getLdapServer().isStarted());
    }
}

