/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.replication;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.TrustManager;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.controls.SyncDoneValue;
import org.apache.directory.api.ldap.extras.controls.SyncInfoValue;
import org.apache.directory.api.ldap.extras.controls.SyncModifyDnType;
import org.apache.directory.api.ldap.extras.controls.SyncStateTypeEnum;
import org.apache.directory.api.ldap.extras.controls.SyncStateValue;
import org.apache.directory.api.ldap.extras.controls.SynchronizationModeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncInfoValueDecorator;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueDecorator;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.ConnectionClosedEventListener;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.ldap.client.api.future.SearchFuture;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.ldap.LdapProtocolUtils;
import org.apache.directory.server.ldap.replication.ReplicationConsumerConfig;
import org.apache.directory.server.ldap.replication.SyncReplConfiguration;
import org.apache.directory.server.ldap.replication.consumer.ReplicationConsumer;
import org.apache.directory.server.ldap.replication.consumer.ReplicationStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSyncReplConsumer
implements ConnectionClosedEventListener,
ReplicationConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(MockSyncReplConsumer.class);
    private static final Logger CONSUMER_LOG = LoggerFactory.getLogger((String)Loggers.CONSUMER_LOG.getName());
    private LdapApiService ldapCodecService = LdapApiServiceFactory.getSingleton();
    private SyncReplConfiguration config;
    private volatile boolean stop = false;
    private final Object mutex = new Object();
    private byte[] syncCookie;
    private LdapNetworkConnection connection;
    private SearchRequest searchRequest;
    private SchemaManager schemaManager;
    private File cookieFile;
    private boolean disconnected;
    private AtomicInteger nbAdded = new AtomicInteger(0);
    private File cookieDir;
    public static String COOKIES_DIR_NAME = "cookies";
    private static final String[] MOD_IGNORE_AT = new String[]{"entryUUID", "entryCSN", "modifiersName", "modifyTimestamp", "createTimestamp", "creatorsName", "entryParentId"};
    private RefresherThread refreshThread;
    private byte[] lastSavedCookie;
    private static final PresenceNode ENTRY_UUID_PRESENCE_FILTER = new PresenceNode("entryUUID");
    private static final Set<AttributeTypeOptions> ENTRY_UUID_ATOP_SET = new HashSet<AttributeTypeOptions>();
    private List<Modification> cookieModLst;
    private static AttributeType COOKIE_AT_TYPE;
    private static AttributeType ENTRY_UUID_AT;

    public SyncReplConfiguration getConfig() {
        return this.config;
    }

    public void init(DirectoryService directoryService) throws Exception {
        this.schemaManager = directoryService.getSchemaManager();
        ENTRY_UUID_AT = this.schemaManager.lookupAttributeTypeRegistry("entryUUID");
        COOKIE_AT_TYPE = this.schemaManager.lookupAttributeTypeRegistry("ads-replCookie");
        ENTRY_UUID_ATOP_SET.add(new AttributeTypeOptions(ENTRY_UUID_AT));
        DefaultAttribute cookieAttr = new DefaultAttribute(COOKIE_AT_TYPE);
        DefaultModification cookieMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)cookieAttr);
        this.cookieModLst = new ArrayList<Modification>(1);
        this.cookieModLst.add((Modification)cookieMod);
        this.cookieDir = new File(System.getProperty("java.io.tmpdir") + "/" + COOKIES_DIR_NAME);
        this.cookieDir.mkdirs();
        this.prepareSyncSearchRequest();
    }

    public boolean connect() {
        block7: {
            try {
                String providerHost = this.config.getRemoteHost();
                int port = this.config.getRemotePort();
                if (this.connection == null) {
                    this.connection = new LdapNetworkConnection(providerHost, port);
                    this.connection.setTimeOut(-1L);
                    if (this.config.isUseTls()) {
                        this.connection.getConfig().setTrustManagers(new TrustManager[]{this.config.getTrustManager()});
                        this.connection.startTls();
                    }
                    this.connection.addConnectionClosedEventListener((ConnectionClosedEventListener)this);
                }
                if (this.connection.connect()) {
                    CONSUMER_LOG.info("Consumer {} connected to producer {}", (Object)this.config.getReplicaId(), (Object)this.config.getProducer());
                    try {
                        this.connection.bind(this.config.getReplUserDn(), Strings.utf8ToString((byte[])this.config.getReplUserPassword()));
                        this.disconnected = false;
                        return true;
                    }
                    catch (LdapException le) {
                        CONSUMER_LOG.warn("Failed to bind to the producer {} with the given bind Dn {}", (Object)this.config.getProducer(), (Object)this.config.getReplUserDn());
                        LOG.warn("Failed to bind to the server with the given bind Dn {}", (Object)this.config.getReplUserDn());
                        LOG.warn("", (Throwable)le);
                        this.disconnected = true;
                        break block7;
                    }
                }
                CONSUMER_LOG.warn("Consumer {} cannot connect to producer {}", (Object)this.config.getReplicaId(), (Object)this.config.getProducer());
                this.disconnected = true;
                return false;
            }
            catch (Exception e) {
                CONSUMER_LOG.error("Failed to connect to the server {}, cause : {}", (Object)this.config.getProducer(), (Object)e.getMessage());
                LOG.error("Failed to connect to the server {}, cause : {}", (Object)this.config.getProducer(), (Object)e.getMessage());
                this.disconnected = true;
            }
        }
        return false;
    }

    public void prepareSyncSearchRequest() throws LdapException {
        String baseDn = this.config.getBaseDn();
        this.searchRequest = new SearchRequestImpl();
        this.searchRequest.setBase(new Dn(new String[]{baseDn}));
        this.searchRequest.setFilter(this.config.getFilter());
        this.searchRequest.setSizeLimit((long)this.config.getSearchSizeLimit());
        this.searchRequest.setTimeLimit(this.config.getSearchTimeout());
        this.searchRequest.setDerefAliases(this.config.getAliasDerefMode());
        this.searchRequest.setScope(this.config.getSearchScope());
        this.searchRequest.setTypesOnly(false);
        this.searchRequest.addAttributes(this.config.getAttributes());
    }

    public ResultCodeEnum handleSearchDone(SearchResultDone searchDone) {
        LOG.debug("///////////////// handleSearchDone //////////////////");
        SyncDoneValue ctrl = (SyncDoneValue)searchDone.getControls().get("1.3.6.1.4.1.4203.1.9.1.3");
        if (ctrl != null && ctrl.getCookie() != null) {
            this.syncCookie = ctrl.getCookie();
            LOG.debug("assigning cookie from sync done value control: " + Strings.utf8ToString((byte[])this.syncCookie));
            this.storeCookie();
        }
        LOG.debug("//////////////// END handleSearchDone//////////////////////");
        return searchDone.getLdapResult().getResultCode();
    }

    public void handleSearchReference(SearchResultReference searchRef) {
    }

    public void handleSearchResult(SearchResultEntry syncResult) {
        LOG.debug("------------- starting handleSearchResult ------------");
        SyncStateValue syncStateCtrl = (SyncStateValue)syncResult.getControl("1.3.6.1.4.1.4203.1.9.1.2");
        try {
            Entry remoteEntry = syncResult.getEntry();
            if (syncStateCtrl.getCookie() != null) {
                this.syncCookie = syncStateCtrl.getCookie();
                LOG.debug("assigning the cookie from sync state value control: " + Strings.utf8ToString((byte[])this.syncCookie));
            }
            SyncStateTypeEnum state = syncStateCtrl.getSyncStateType();
            LOG.debug("state name {}", (Object)state.name());
            if (LOG.isDebugEnabled()) {
                LOG.debug("entryUUID = {}", (Object)Strings.uuidToString((byte[])syncStateCtrl.getEntryUUID()));
            }
            switch (state) {
                case ADD: {
                    LOG.debug("adding entry with dn {}, {}", (Object)remoteEntry.getDn().getName(), (Object)remoteEntry);
                    this.nbAdded.getAndIncrement();
                    break;
                }
                case MODIFY: {
                    LOG.debug("modifying entry with dn {}", (Object)remoteEntry.getDn().getName());
                    this.modify(remoteEntry);
                    break;
                }
                case MODDN: {
                    String entryUuid = Strings.uuidToString((byte[])syncStateCtrl.getEntryUUID());
                    this.applyModDnOperation(remoteEntry, entryUuid);
                    break;
                }
                case DELETE: {
                    LOG.debug("deleting entry with dn {}", (Object)remoteEntry.getDn().getName());
                    this.deleteRecursive(remoteEntry.getDn(), null);
                    break;
                }
                case PRESENT: {
                    LOG.debug("entry present {}", (Object)remoteEntry);
                }
            }
            if (syncStateCtrl.getCookie() != null) {
                this.storeCookie();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        LOG.debug("------------- Ending handleSearchResult ------------");
    }

    public void handleSyncInfo(IntermediateResponse syncInfoResp) {
        try {
            LOG.debug("............... inside handleSyncInfo ...............");
            byte[] syncInfoBytes = syncInfoResp.getResponseValue();
            if (syncInfoBytes == null) {
                return;
            }
            SyncInfoValueDecorator decorator = new SyncInfoValueDecorator(this.ldapCodecService);
            SyncInfoValue syncInfoValue = (SyncInfoValue)decorator.decode(syncInfoBytes);
            byte[] cookie = syncInfoValue.getCookie();
            int replicaId = -1;
            if (cookie != null) {
                LOG.debug("setting the cookie from the sync info: " + Strings.utf8ToString((byte[])cookie));
                this.syncCookie = cookie;
                String cookieString = Strings.utf8ToString((byte[])this.syncCookie);
                replicaId = LdapProtocolUtils.getReplicaId((String)cookieString);
            }
            LOG.info("refreshDeletes: " + syncInfoValue.isRefreshDeletes());
            List uuidList = syncInfoValue.getSyncUUIDs();
            if (syncInfoValue.isRefreshDeletes()) {
                this.deleteEntries(uuidList, false);
            } else {
                this.deleteEntries(uuidList, true);
            }
            LOG.info("refreshDone: " + syncInfoValue.isRefreshDone());
            this.storeCookie();
        }
        catch (Exception de) {
            LOG.error("Failed to handle syncinfo message", (Throwable)de);
        }
        LOG.debug(".................... END handleSyncInfo ...............");
    }

    public void connectionClosed() {
        if (this.disconnected) {
            return;
        }
        boolean connected = false;
        while (!connected) {
            try {
                Thread.sleep(this.config.getRefreshInterval());
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while sleeping before trying to reconnect", (Throwable)e);
            }
            LOG.debug("Trying to reconnect");
            connected = this.connect();
        }
        this.startSync();
    }

    public ReplicationStatusEnum startSync() {
        this.readCookie();
        if (this.config.isRefreshNPersist()) {
            try {
                LOG.debug("==================== Refresh And Persist ==========");
                return this.doSyncSearch(SynchronizationModeEnum.REFRESH_AND_PERSIST, false);
            }
            catch (Exception e) {
                LOG.error("Failed to sync with refreshAndPersist mode", (Throwable)e);
                return ReplicationStatusEnum.DISCONNECTED;
            }
        }
        return this.doRefreshOnly();
    }

    private ReplicationStatusEnum doRefreshOnly() {
        while (!this.stop) {
            LOG.debug("==================== Refresh Only ==========");
            try {
                this.doSyncSearch(SynchronizationModeEnum.REFRESH_ONLY, false);
                LOG.info("--------------------- Sleep for a little while ------------------");
                this.mutex.wait(this.config.getRefreshInterval());
                LOG.debug("--------------------- syncing again ------------------");
            }
            catch (InterruptedException ie) {
                LOG.warn("refresher thread interrupted");
                return ReplicationStatusEnum.DISCONNECTED;
            }
            catch (Exception e) {
                LOG.error("Failed to sync with refresh only mode", (Throwable)e);
                return ReplicationStatusEnum.DISCONNECTED;
            }
        }
        return ReplicationStatusEnum.STOPPED;
    }

    public void setConfig(ReplicationConsumerConfig config) {
        this.config = (SyncReplConfiguration)config;
    }

    public void ping() {
        block6: {
            boolean connected;
            boolean bl = connected = !this.disconnected;
            if (this.disconnected) {
                connected = this.connect();
            }
            if (connected) {
                CONSUMER_LOG.debug("PING : The consumer {} is alive", (Object)this.config.getReplicaId());
                try {
                    Entry baseDn = this.connection.lookup(this.config.getBaseDn(), new String[]{"1.1"});
                    if (baseDn == null) {
                        CONSUMER_LOG.debug("Cannot fetch '{}' from provider for consumer {}", (Object)this.config.getBaseDn(), (Object)this.config.getReplicaId());
                        break block6;
                    }
                    CONSUMER_LOG.debug("Fetched '{}' from provider for consumer {}", (Object)this.config.getBaseDn(), (Object)this.config.getReplicaId());
                }
                catch (LdapException le) {
                    this.disconnect();
                }
            } else {
                CONSUMER_LOG.debug("PING : The consumer {} cannot be connected", (Object)this.config.getReplicaId());
            }
        }
    }

    public boolean connect(boolean now) {
        boolean connected = false;
        if (now) {
            connected = this.connect();
        }
        while (!connected) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.warn("Consumer {} Interrupted while trying to reconnect to the provider {}", (Object)this.config.getReplicaId(), (Object)this.config.getProducer());
            }
            connected = this.connect();
        }
        return connected;
    }

    public void stop() {
        if (!this.disconnected) {
            this.disconnect();
            this.nbAdded.getAndSet(0);
        }
    }

    public String getId() {
        return String.valueOf(this.getConfig().getReplicaId());
    }

    private ReplicationStatusEnum doSyncSearch(SynchronizationModeEnum syncType, boolean reloadHint) throws Exception {
        SyncRequestValueDecorator syncReq = new SyncRequestValueDecorator(this.ldapCodecService);
        syncReq.setMode(syncType);
        syncReq.setReloadHint(reloadHint);
        if (this.syncCookie != null) {
            LOG.debug("searching with searchRequest, cookie '{}'", (Object)Strings.utf8ToString((byte[])this.syncCookie));
            syncReq.setCookie(this.syncCookie);
        }
        this.searchRequest.addControl((Control)syncReq);
        SearchFuture sf = this.connection.searchAsync(this.searchRequest);
        Response resp = sf.get();
        while (!(resp instanceof SearchResultDone || sf.isCancelled() || this.disconnected)) {
            if (resp instanceof SearchResultEntry) {
                this.handleSearchResult((SearchResultEntry)resp);
            } else if (resp instanceof SearchResultReference) {
                this.handleSearchReference((SearchResultReference)resp);
            } else if (resp instanceof IntermediateResponse) {
                this.handleSyncInfo((IntermediateResponse)resp);
            }
            resp = sf.get();
        }
        ResultCodeEnum resultCode = this.handleSearchDone((SearchResultDone)resp);
        LOG.debug("sync operation returned result code {}", (Object)resultCode);
        if (resultCode == ResultCodeEnum.NO_SUCH_OBJECT) {
            LOG.warn("given replication base Dn {} is not found on provider", (Object)this.config.getBaseDn());
            LOG.warn("disconnecting the consumer running in refreshAndPersist mode from the provider");
            this.disconnect();
            return ReplicationStatusEnum.DISCONNECTED;
        }
        if (resultCode == ResultCodeEnum.E_SYNC_REFRESH_REQUIRED) {
            LOG.info("unable to perform the content synchronization cause E_SYNC_REFRESH_REQUIRED");
            try {
                this.deleteRecursive(new Dn(new String[]{this.config.getBaseDn()}), null);
            }
            catch (Exception e) {
                LOG.error("Failed to delete the replica base as part of handling E_SYNC_REFRESH_REQUIRED, disconnecting the consumer", (Throwable)e);
                this.disconnect();
            }
            this.removeCookie();
            return ReplicationStatusEnum.REFRESH_REQUIRED;
        }
        return ReplicationStatusEnum.DISCONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.disconnected = true;
        if (this.connection == null) {
            return;
        }
        if (this.connection.isConnected()) {
            try {
                if (this.refreshThread != null) {
                    this.refreshThread.stopRefreshing();
                }
                this.connection.unBind();
                LOG.info("Unbound from the server {}", (Object)this.config.getRemoteHost());
                this.connection.close();
                LOG.info("Connection closed for the server {}", (Object)this.config.getRemoteHost());
                this.connection = null;
            }
            catch (Exception e) {
                LOG.error("Failed to close the connection", (Throwable)e);
            }
            finally {
                this.storeCookie();
                this.syncCookie = null;
            }
        }
    }

    private void storeCookie() {
        if (this.syncCookie == null) {
            return;
        }
        if (this.lastSavedCookie != null && Arrays.equals(this.syncCookie, this.lastSavedCookie)) {
            return;
        }
        try {
            if (this.cookieFile == null) {
                this.cookieFile = new File(this.cookieDir, String.valueOf(LdapProtocolUtils.getReplicaId((String)new String(this.syncCookie))));
            }
            FileOutputStream fout = new FileOutputStream(this.cookieFile);
            fout.write(this.syncCookie.length);
            fout.write(this.syncCookie);
            fout.close();
            this.lastSavedCookie = new byte[this.syncCookie.length];
            System.arraycopy(this.syncCookie, 0, this.lastSavedCookie, 0, this.syncCookie.length);
            LOG.debug("stored the cookie");
        }
        catch (Exception e) {
            LOG.error("Failed to store the cookie", (Throwable)e);
        }
    }

    private void readCookie() {
        try {
            if (this.cookieFile != null && this.cookieFile.exists() && this.cookieFile.length() > 0L) {
                FileInputStream fin = new FileInputStream(this.cookieFile);
                this.syncCookie = new byte[fin.read()];
                fin.read(this.syncCookie);
                fin.close();
                this.lastSavedCookie = new byte[this.syncCookie.length];
                System.arraycopy(this.syncCookie, 0, this.lastSavedCookie, 0, this.syncCookie.length);
                LOG.debug("read the cookie from file: " + Strings.utf8ToString((byte[])this.syncCookie));
            }
        }
        catch (Exception e) {
            LOG.error("Failed to read the cookie", (Throwable)e);
        }
    }

    public void removeCookie() {
        if (this.cookieFile.exists() && this.cookieFile.length() > 0L) {
            boolean deleted = this.cookieFile.delete();
            LOG.info("deleted cookie file {}", (Object)deleted);
        }
        LOG.info("resetting sync cookie");
        this.syncCookie = null;
        this.lastSavedCookie = null;
    }

    private void applyModDnOperation(Entry remoteEntry, String entryUuid) throws Exception {
        LOG.debug("MODDN for entry {}, new entry : {}", (Object)entryUuid, (Object)remoteEntry);
        SyncModifyDnType modDnType = null;
        String filter = "(entryUuid=" + entryUuid + ")";
        EntryCursor cursor = this.connection.search(Dn.ROOT_DSE, filter, SearchScope.SUBTREE, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry localEntry = (Entry)cursor.get();
        Dn localDn = localEntry.getDn();
        Dn remoteDn = remoteEntry.getDn();
        Dn localParentDn = localDn.getParent();
        Dn remoteParentDn = remoteDn.getParent();
        Rdn localRdn = localDn.getRdn();
        Rdn remoteRdn = remoteDn.getRdn();
        if (localRdn.equals((Object)remoteRdn)) {
            modDnType = SyncModifyDnType.MOVE;
        }
        if (localParentDn.equals((Object)remoteParentDn)) {
            modDnType = SyncModifyDnType.RENAME;
        }
        if (modDnType == null) {
            modDnType = SyncModifyDnType.MOVE_AND_RENAME;
        }
        boolean deleteOldRdn = remoteEntry.contains(localRdn.getNormType(), new Value[]{localRdn.getNormValue()});
        switch (modDnType) {
            case MOVE: {
                LOG.debug("moving {} to the new parent {}", (Object)localDn, (Object)remoteParentDn);
                break;
            }
            case RENAME: {
                LOG.debug("renaming the Dn {} with new Rdn {} and deleteOldRdn flag set to {}", (Object[])new String[]{localDn.getName(), remoteRdn.getName(), String.valueOf(deleteOldRdn)});
                break;
            }
            case MOVE_AND_RENAME: {
                LOG.debug("moveAndRename on the Dn {} with new newParent Dn {}, new Rdn {} and deleteOldRdn flag set to {}", (Object[])new String[]{localDn.getName(), remoteParentDn.getName(), remoteRdn.getName(), String.valueOf(deleteOldRdn)});
            }
        }
    }

    private void modify(Entry remoteEntry) throws Exception {
    }

    public void deleteEntries(List<byte[]> uuidList, boolean isRefreshPresent) throws Exception {
        int i;
        if (uuidList == null || uuidList.isEmpty()) {
            return;
        }
        for (byte[] uuid : uuidList) {
            LOG.info("uuid: {}", (Object)Strings.uuidToString((byte[])uuid));
        }
        if (isRefreshPresent) {
            LOG.debug("refresh present syncinfo list has {} UUIDs", (Object)uuidList.size());
            this._deleteEntries_(uuidList, isRefreshPresent);
            return;
        }
        int NODE_LIMIT = 10;
        int count = uuidList.size() / NODE_LIMIT;
        int startIndex = 0;
        for (i = 0; i < count; ++i) {
            startIndex = i * NODE_LIMIT;
            this._deleteEntries_(uuidList.subList(startIndex, startIndex + NODE_LIMIT), isRefreshPresent);
        }
        if (uuidList.size() % NODE_LIMIT != 0) {
            if (count > 0) {
                startIndex = i * NODE_LIMIT;
            }
            this._deleteEntries_(uuidList.subList(startIndex, uuidList.size()), isRefreshPresent);
        }
    }

    private void _deleteEntries_(List<byte[]> limitedUuidList, boolean isRefreshPresent) throws Exception {
        Object filter = null;
        int size = limitedUuidList.size();
        if (size == 1) {
            String uuid = Strings.uuidToString((byte[])limitedUuidList.get(0));
            filter = new EqualityNode("entryUUID", (Value)new StringValue(uuid));
            if (isRefreshPresent) {
                filter = new NotNode((ExprNode)filter);
            }
        } else {
            filter = isRefreshPresent ? new AndNode() : new OrNode();
            for (int i = 0; i < size; ++i) {
                String uuid = Strings.uuidToString((byte[])limitedUuidList.get(i));
                EqualityNode uuidEqNode = new EqualityNode("entryUUID", (Value)new StringValue(uuid));
                if (isRefreshPresent) {
                    uuidEqNode = new NotNode((ExprNode)uuidEqNode);
                    filter.addNode((ExprNode)uuidEqNode);
                    continue;
                }
                ((OrNode)filter).addNode((ExprNode)uuidEqNode);
            }
        }
        Dn dn = new Dn(this.schemaManager, new String[]{this.config.getBaseDn()});
    }

    private void deleteRecursive(Dn rootDn, Map<Dn, EntryFilteringCursor> cursorMap) throws Exception {
        LOG.debug("searching for {}", (Object)rootDn.getName());
        Object cursor = null;
        try {
            if (cursorMap == null) {
                cursorMap = new HashMap<Dn, EntryFilteringCursor>();
            }
        }
        catch (Exception e) {
            String msg = "Failed to delete child entries under the Dn " + rootDn.getName();
            LOG.error(msg, (Throwable)e);
            throw e;
        }
    }

    public int getNbAdded() {
        return this.nbAdded.get();
    }

    public void resetNbAdded() {
        this.nbAdded.getAndSet(0);
    }

    private class RefresherThread
    extends Thread {
        public RefresherThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!MockSyncReplConsumer.this.stop) {
                LOG.debug("==================== Refresh Only ==========");
                try {
                    MockSyncReplConsumer.this.doSyncSearch(SynchronizationModeEnum.REFRESH_ONLY, false);
                    LOG.info("--------------------- Sleep for a little while ------------------");
                    MockSyncReplConsumer.this.mutex.wait(MockSyncReplConsumer.this.config.getRefreshInterval());
                    LOG.debug("--------------------- syncing again ------------------");
                }
                catch (InterruptedException ie) {
                    LOG.warn("refresher thread interrupted");
                }
                catch (Exception e) {
                    LOG.error("Failed to sync with refresh only mode", (Throwable)e);
                }
            }
        }

        public void stopRefreshing() {
            MockSyncReplConsumer.this.stop = true;
            MockSyncReplConsumer.this.mutex.notify();
        }
    }
}

