/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.extended;

import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicy;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyImpl;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyDecorator;
import org.apache.directory.api.ldap.extras.extended.PwdModifyRequestImpl;
import org.apache.directory.api.ldap.extras.extended.PwdModifyResponse;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddRequestImpl;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.authn.ppolicy.CheckQualityEnum;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyConfiguration;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authn.ppolicy.PpolicyConfigContainer;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.extended.PwdModifyHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")}, extendedOpHandlers={PwdModifyHandler.class}, allowAnonymousAccess=true)
@CreateDS(enableChangeLog=false, name="PasswordPolicyTest")
public class PwdModifyIT
extends AbstractLdapTestUnit {
    private static final LdapApiService codec = LdapApiServiceFactory.getSingleton();
    private static final PasswordPolicyDecorator PP_REQ_CTRL = new PasswordPolicyDecorator(codec, (PasswordPolicy)new PasswordPolicyImpl());
    private PasswordPolicyConfiguration policyConfig;

    private PasswordPolicy getPwdRespCtrl(Response resp) throws Exception {
        Control control = (Control)resp.getControls().get(PP_REQ_CTRL.getOid());
        if (control == null) {
            return null;
        }
        return (PasswordPolicy)((PasswordPolicyDecorator)control).getDecorated();
    }

    private void addUser(LdapConnection adminConnection, String user, Object password) throws Exception {
        DefaultEntry userEntry = new DefaultEntry("cn=" + user + ",ou=system", new Object[]{"ObjectClass: top", "ObjectClass: person", "cn", user, "sn", user + "_sn", "userPassword", password});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = adminConnection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNull((Object)respCtrl);
    }

    private void checkBind(LdapConnection connection, Dn userDn, String password, int nbIterations, String expectedMessage) throws Exception {
        for (int i = 0; i < nbIterations; ++i) {
            try {
                connection.bind(userDn, password);
                continue;
            }
            catch (LdapAuthenticationException le) {
                Assert.assertEquals((Object)expectedMessage, (Object)le.getMessage());
            }
        }
    }

    @Before
    public void setPwdPolicy() throws LdapException {
        this.policyConfig = new PasswordPolicyConfiguration();
        this.policyConfig.setPwdMaxAge(110);
        this.policyConfig.setPwdFailureCountInterval(30);
        this.policyConfig.setPwdMaxFailure(3);
        this.policyConfig.setPwdLockout(true);
        this.policyConfig.setPwdLockoutDuration(0);
        this.policyConfig.setPwdMinLength(5);
        this.policyConfig.setPwdInHistory(5);
        this.policyConfig.setPwdExpireWarning(600);
        this.policyConfig.setPwdGraceAuthNLimit(5);
        this.policyConfig.setPwdCheckQuality(CheckQualityEnum.CHECK_REJECT);
        PpolicyConfigContainer policyContainer = new PpolicyConfigContainer();
        policyContainer.setDefaultPolicy(this.policyConfig);
        AuthenticationInterceptor authenticationInterceptor = (AuthenticationInterceptor)PwdModifyIT.getService().getInterceptor(InterceptorEnum.AUTHENTICATION_INTERCEPTOR.getName());
        authenticationInterceptor.setPwdPolicies(policyContainer);
    }

    @Test
    public void testModifyOwnPasswordConnected() throws Exception {
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        this.addUser(adminConnection, "User", "secret");
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)PwdModifyIT.getLdapServer(), (String)"cn=user,ou=system", (String)"secret");
        userConnection.setTimeOut(0L);
        PwdModifyRequestImpl pwdModifyRequest = new PwdModifyRequestImpl();
        pwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"secretBis"));
        PwdModifyResponse pwdModifyResponse = (PwdModifyResponse)userConnection.extended((ExtendedRequest)pwdModifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)pwdModifyResponse.getLdapResult().getResultCode());
        userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User,ou=system", (String)"secretBis");
        Entry entry = userConnection.lookup("cn=User,ou=system");
        Assert.assertNotNull((Object)entry);
        userConnection.close();
        adminConnection.close();
    }

    @Test
    public void testModifyUserPasswordAnonymous() throws Exception {
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        this.addUser(adminConnection, "User1", "secret1");
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User1,ou=system", (String)"secret1");
        Entry entry = userConnection.lookup("cn=User1,ou=system");
        Assert.assertNotNull((Object)entry);
        userConnection.close();
        LdapConnection anonymousConnection = IntegrationUtils.getAnonymousNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        anonymousConnection.setTimeOut(0L);
        PwdModifyRequestImpl pwdModifyRequest = new PwdModifyRequestImpl();
        pwdModifyRequest.setUserIdentity(Strings.getBytesUtf8((String)"cn=User1,ou=system"));
        pwdModifyRequest.setOldPassword(Strings.getBytesUtf8((String)"secret1"));
        pwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"secret1Bis"));
        PwdModifyResponse pwdModifyResponse = (PwdModifyResponse)anonymousConnection.extended((ExtendedRequest)pwdModifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)pwdModifyResponse.getLdapResult().getResultCode());
        userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User1,ou=system", (String)"secret1Bis");
        entry = userConnection.lookup("cn=User1,ou=system");
        Assert.assertNotNull((Object)entry);
        userConnection.close();
        anonymousConnection.close();
        adminConnection.close();
    }

    @Test
    public void testModifyUserPasswordAnonymousPPActivated() throws Exception {
        this.policyConfig.setPwdCheckQuality(CheckQualityEnum.CHECK_ACCEPT);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        this.addUser(adminConnection, "User2", "secret2");
        Dn userDn = new Dn(new String[]{"cn=User2,ou=system"});
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User2,ou=system", (String)"secret2");
        Entry entry = userConnection.lookup("cn=User2,ou=system");
        Assert.assertNotNull((Object)entry);
        userConnection.close();
        this.checkBind(userConnection, userDn, "badPassword", 2, "INVALID_CREDENTIALS: Bind failed: ERR_229 Cannot authenticate user cn=User2,ou=system");
        LdapConnection anonymousConnection = IntegrationUtils.getAnonymousNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        anonymousConnection.setTimeOut(0L);
        PwdModifyRequestImpl pwdModifyRequest = new PwdModifyRequestImpl();
        pwdModifyRequest.setUserIdentity(Strings.getBytesUtf8((String)"cn=User2,ou=system"));
        pwdModifyRequest.setOldPassword(Strings.getBytesUtf8((String)"secret2"));
        pwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"secret2Bis"));
        PwdModifyResponse pwdModifyResponse = (PwdModifyResponse)anonymousConnection.extended((ExtendedRequest)pwdModifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)pwdModifyResponse.getLdapResult().getResultCode());
        userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User2,ou=system", (String)"secret2Bis");
        entry = userConnection.lookup("cn=User2,ou=system");
        Assert.assertNotNull((Object)entry);
        this.checkBind(userConnection, userDn, "badPassword", 2, "INVALID_CREDENTIALS: Bind failed: ERR_229 Cannot authenticate user cn=User2,ou=system");
        userConnection.close();
        anonymousConnection.close();
        adminConnection.close();
    }

    @Test
    public void testAdminModifyPassword() throws Exception {
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PwdModifyIT.getLdapServer());
        this.addUser(adminConnection, "User3", "secret3");
        PwdModifyRequestImpl pwdModifyRequest = new PwdModifyRequestImpl();
        pwdModifyRequest.setUserIdentity(Strings.getBytesUtf8((String)"cn=User3,ou=system"));
        pwdModifyRequest.setNewPassword(Strings.getBytesUtf8((String)"secret3Bis"));
        PwdModifyResponse pwdModifyResponse = (PwdModifyResponse)adminConnection.extended((ExtendedRequest)pwdModifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)pwdModifyResponse.getLdapResult().getResultCode());
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)"cn=User3,ou=system", (String)"secret3Bis");
        Entry entry = userConnection.lookup("cn=User3,ou=system");
        Assert.assertNotNull((Object)entry);
        userConnection.close();
        adminConnection.close();
    }
}

