/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.dsml.engine;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.directory.api.dsmlv2.Dsmlv2ResponseParser;
import org.apache.directory.api.dsmlv2.engine.Dsmlv2Engine;
import org.apache.directory.api.dsmlv2.reponse.BatchResponseDsml;
import org.apache.directory.api.dsmlv2.reponse.SearchResponse;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="Dsmlv2EngineTest-DS")
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class Dsmlv2EngineIT
extends AbstractLdapTestUnit {
    private LdapConnection connection;
    private Dsmlv2Engine engine;

    @Before
    public void setup() {
        this.connection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        this.engine = new Dsmlv2Engine(this.connection, "uid=admin,ou=system", "secret");
    }

    @After
    public void unbind() throws Exception {
        this.connection.unBind();
        this.connection.close();
    }

    @Test
    public void testEngineWithSearchRequest() throws Exception {
        InputStream dsmlIn = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("dsml-search-req.xml");
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        this.engine.processDSML(dsmlIn, (OutputStream)byteOut);
        Dsmlv2ResponseParser respParser = new Dsmlv2ResponseParser(LdapApiServiceFactory.getSingleton());
        respParser.setInput(byteOut.toString());
        respParser.parseAllResponses();
        BatchResponseDsml batchResp = respParser.getBatchResponse();
        Assert.assertNotNull((Object)batchResp);
        SearchResponse searchResp = (SearchResponse)batchResp.getCurrentResponse().getDecorated();
        Assert.assertEquals((long)5L, (long)searchResp.getSearchResultEntryList().size());
    }

    @Test
    public void testEngineWithSearchResponseInSoapEnvelope() throws Exception {
        InputStream dsmlIn = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("dsml-search-req.xml");
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        this.engine.setGenerateSoapResp(true);
        this.engine.processDSML(dsmlIn, (OutputStream)byteOut);
        this.engine.setGenerateSoapResp(false);
        String resp = byteOut.toString();
        Dsmlv2ResponseParser respParser = new Dsmlv2ResponseParser(LdapApiServiceFactory.getSingleton());
        respParser.setInput(resp);
        respParser.parseAllResponses();
        BatchResponseDsml batchResp = respParser.getBatchResponse();
        Assert.assertNotNull((Object)batchResp);
        SearchResponse searchResp = (SearchResponse)batchResp.getCurrentResponse().getDecorated();
        Assert.assertEquals((long)5L, (long)searchResp.getSearchResultEntryList().size());
    }
}

