/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.search;

import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.DelayInducingInterceptor;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: ou=actors,ou=system", "objectClass: top", "objectClass: organizationalUnit", "ou: actors", "dn: uid=jblack,ou=actors,ou=system", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: uidObject", "uid: jblack", "ou: comedy", "ou: adventure", "cn: Jack Black", "userPassword: secret", "sn: Black", "dn: uid=bpitt,ou=actors,ou=system", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: uidObject", "uid: bpitt", "ou: drama", "ou: adventure", "userPassword: secret", "cn: Brad Pitt", "sn: Pitt", "dn: uid=gcloony,ou=actors,ou=system", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: uidObject", "uid: gcloony", "ou: drama", "userPassword: secret", "cn: Goerge Cloony", "sn: Cloony", "dn: uid=jnewbie,ou=actors,ou=system", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: uidObject", "uid: jnewbie", "userPassword: secret", "cn: Joe Newbie", "sn: Newbie"})
public class SearchLimitsIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private int oldMaxTimeLimit;
    private long oldMaxSizeLimit;
    private DelayInducingInterceptor delayInterceptor;

    @Before
    public void setUp() throws Exception {
        this.oldMaxTimeLimit = SearchLimitsIT.getLdapServer().getMaxTimeLimit();
        this.oldMaxSizeLimit = SearchLimitsIT.getLdapServer().getMaxSizeLimit();
        this.delayInterceptor = new DelayInducingInterceptor();
        SearchLimitsIT.getLdapServer().getDirectoryService().addFirst((Interceptor)this.delayInterceptor);
    }

    @After
    public void tearDown() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxTimeLimit(this.oldMaxTimeLimit);
        SearchLimitsIT.getLdapServer().setMaxSizeLimit(this.oldMaxSizeLimit);
        SearchLimitsIT.getLdapServer().getDirectoryService().remove(this.delayInterceptor.getName());
    }

    @Test(expected=TimeLimitExceededException.class)
    public void testRequestConstrainedUnlimitByConfiguration() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxTimeLimit(0);
        this.delayInterceptor.setDelayMillis(500L);
        this.getActorsWithLimit("(objectClass=*)", 499, 0L);
    }

    @Test(expected=TimeLimitExceededException.class)
    public void testRequestConstrainedLessThanConfiguration() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxTimeLimit(10000);
        this.delayInterceptor.setDelayMillis(500L);
        this.getActorsWithLimit("(objectClass=*)", 499, 0L);
    }

    @Test(expected=TimeLimitExceededException.class)
    public void testRequestConstrainedGreaterThanConfiguration() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxTimeLimit(1);
        this.delayInterceptor.setDelayMillis(1100L);
        this.getActorsWithLimit("(objectClass=*)", 100000, 0L);
    }

    @Test
    public void testRequestUnlimitedConfigurationLimited() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxTimeLimit(1);
        this.delayInterceptor.setDelayMillis(500L);
        this.getActorsWithLimit("(objectClass=*)", 0, 0L);
    }

    @Test(expected=TimeLimitExceededException.class)
    public void testNonAdminRequestUnlimitedConfigurationLimited() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxTimeLimit(1);
        this.delayInterceptor.setDelayMillis(500L);
        this.getActorsWithLimitNonAdmin("(objectClass=*)", 0, 0L);
    }

    @Test(expected=SizeLimitExceededException.class)
    public void testRequestConstrainedUnlimitByConfigurationSize() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxSizeLimit(0L);
        this.getActorsWithLimit("(objectClass=*)", 0, 1L);
    }

    @Test(expected=SizeLimitExceededException.class)
    public void testRequestConstrainedLessThanConfigurationSize() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxSizeLimit(10000L);
        this.getActorsWithLimit("(objectClass=*)", 0, 1L);
    }

    @Test
    public void testRequestConstrainedGreaterThanConfigurationSize() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxSizeLimit(1L);
        Set<String> set = this.getActorsWithLimit("(objectClass=*)", 0, 100000L);
        Assert.assertEquals((long)4L, (long)set.size());
    }

    @Test(expected=SizeLimitExceededException.class)
    public void testNonAdminRequestConstrainedGreaterThanConfigurationSize() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxSizeLimit(1L);
        this.getActorsWithLimitNonAdmin("(objectClass=*)", 0, 100000L);
    }

    @Test
    public void testRequestUnlimitedConfigurationLimitedSize() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxSizeLimit(1L);
        Set<String> set = this.getActorsWithLimit("(objectClass=*)", 0, 0L);
        Assert.assertEquals((long)4L, (long)set.size());
    }

    @Test(expected=SizeLimitExceededException.class)
    public void testNonAdminRequestUnlimitedConfigurationLimitedSize() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxSizeLimit(1L);
        this.getActorsWithLimitNonAdmin("(objectClass=*)", 0, 0L);
    }

    @Test(expected=SizeLimitExceededException.class)
    public void testRequestConstraintedLessThanExpectedSize() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxSizeLimit(0L);
        this.getActorsWithLimit("(objectClass=*)", 0, 3L);
    }

    @Test
    public void testRequestConstraintedEqualToExpectedSize() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxSizeLimit(0L);
        Set<String> set = this.getActorsWithLimit("(objectClass=*)", 0, 4L);
        Assert.assertEquals((long)4L, (long)set.size());
    }

    @Test
    public void testRequestConstraintedGreaterThanExpectedSize() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxSizeLimit(0L);
        Set<String> set = this.getActorsWithLimit("(objectClass=*)", 0, 5L);
        Assert.assertEquals((long)4L, (long)set.size());
    }

    @Test
    public void testRequestObjectScopeAndSizeLimit() throws Exception {
        SearchLimitsIT.getLdapServer().setMaxSizeLimit(0L);
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)SearchLimitsIT.getLdapServer());
        String filter = "(objectClass=*)";
        SearchControls controls = new SearchControls();
        controls.setTimeLimit(0);
        controls.setCountLimit(1L);
        controls.setSearchScope(0);
        NamingEnumeration<SearchResult> namingEnumeration = ctx.search("ou=actors,ou=system", filter, controls);
        Assert.assertTrue((boolean)namingEnumeration.hasMore());
        namingEnumeration.next();
        Assert.assertFalse((boolean)namingEnumeration.hasMore());
    }

    private Set<String> getActorsWithLimit(String filter, int timeLimitMillis, long sizeLimit) throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)SearchLimitsIT.getLdapServer());
        HashSet<String> results = new HashSet<String>();
        SearchControls controls = new SearchControls();
        controls.setTimeLimit(timeLimitMillis);
        controls.setCountLimit(sizeLimit);
        controls.setSearchScope(1);
        NamingEnumeration<SearchResult> namingEnumeration = ctx.search("ou=actors,ou=system", filter, controls);
        while (namingEnumeration.hasMore()) {
            results.add(namingEnumeration.next().getNameInNamespace());
        }
        return results;
    }

    private Set<String> getActorsWithLimitNonAdmin(String filter, int timeLimitMillis, long sizeLimit) throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)SearchLimitsIT.getLdapServer(), (String)"uid=jblack,ou=actors,ou=system", (String)"secret");
        HashSet<String> results = new HashSet<String>();
        SearchControls controls = new SearchControls();
        controls.setTimeLimit(timeLimitMillis);
        controls.setCountLimit(sizeLimit);
        controls.setSearchScope(1);
        NamingEnumeration<SearchResult> namingEnumeration = ctx.search("ou=actors,ou=system", filter, controls);
        while (namingEnumeration.hasMore()) {
            results.add(namingEnumeration.next().getNameInNamespace());
        }
        return results;
    }
}

