/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.bind;

import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPUrl;
import org.apache.commons.lang.ArrayUtils;
import org.apache.directory.api.asn1.util.Asn1StringUtils;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.api.ldap.util.JndiUtils;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.handlers.bind.SimpleMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.extended.StoredProcedureExtendedOperationHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(allowAnonAccess=true, name="MiscBindIT-class", partitions={@CreatePartition(name="example", suffix="dc=aPache,dc=org", contextEntry=@ContextEntry(entryLdif="dn: dc=aPache,dc=org\ndc: aPache\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class MiscBindIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private boolean oldAnnonymousAccess;

    @Before
    public void init() throws Exception {
        MiscBindIT.getLdapServer().addExtendedOperationHandler((ExtendedOperationHandler)new StoredProcedureExtendedOperationHandler());
        HashMap<String, Object> mechanismHandlerMap = new HashMap<String, Object>();
        mechanismHandlerMap.put("PLAIN", new SimpleMechanismHandler());
        CramMd5MechanismHandler cramMd5MechanismHandler = new CramMd5MechanismHandler();
        mechanismHandlerMap.put("CRAM-MD5", cramMd5MechanismHandler);
        DigestMd5MechanismHandler digestMd5MechanismHandler = new DigestMd5MechanismHandler();
        mechanismHandlerMap.put("DIGEST-MD5", digestMd5MechanismHandler);
        GssapiMechanismHandler gssapiMechanismHandler = new GssapiMechanismHandler();
        mechanismHandlerMap.put("GSSAPI", gssapiMechanismHandler);
        NtlmMechanismHandler ntlmMechanismHandler = new NtlmMechanismHandler();
        mechanismHandlerMap.put("NTLM", ntlmMechanismHandler);
        mechanismHandlerMap.put("GSS-SPNEGO", ntlmMechanismHandler);
        MiscBindIT.getLdapServer().setSaslMechanismHandlers(mechanismHandlerMap);
        this.oldAnnonymousAccess = MiscBindIT.getLdapServer().getDirectoryService().isAllowAnonymousAccess();
    }

    @After
    public void revertAnonnymous() {
        MiscBindIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(this.oldAnnonymousAccess);
    }

    @Test
    public void testDisableAnonymousBinds() throws Exception {
        MiscBindIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(false);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ldap://localhost:" + MiscBindIT.getLdapServer().getPort() + "/ou=system");
        env.put("java.naming.security.authentication", "none");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        try {
            new InitialDirContext(env);
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            LDAPUrl url = new LDAPUrl("localhost", MiscBindIT.getLdapServer().getPort(), "ou=system", new String[]{"vendorName"}, 0, "(ObjectClass=*)");
            LDAPConnection.search((LDAPUrl)url);
            Assert.fail();
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
    }

    @Test
    public void testEnableAnonymousBindsOnRootDse() throws Exception {
        MiscBindIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(true);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ldap://localhost:" + MiscBindIT.getLdapServer().getPort() + "/");
        env.put("java.naming.security.authentication", "none");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        InitialDirContext ctx = new InitialDirContext(env);
        SearchControls cons = new SearchControls();
        cons.setSearchScope(0);
        NamingEnumeration<SearchResult> list = ctx.search("", "(objectClass=*)", cons);
        SearchResult result = null;
        if (list.hasMore()) {
            result = list.next();
        }
        Assert.assertFalse((boolean)list.hasMore());
        list.close();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"", (Object)result.getName().trim());
    }

    @Test
    public void testAnonymousBindsEnabledBaseSearch() throws Exception {
        MiscBindIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(true);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ldap://localhost:" + MiscBindIT.getLdapServer().getPort() + "/");
        env.put("java.naming.security.authentication", "none");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        InitialDirContext ctx = new InitialDirContext(env);
        SearchControls cons = new SearchControls();
        cons.setSearchScope(0);
        NamingEnumeration<SearchResult> list = ctx.search("dc=apache,dc=org", "(objectClass=*)", cons);
        SearchResult result = null;
        if (list.hasMore()) {
            result = list.next();
        }
        Assert.assertFalse((boolean)list.hasMore());
        list.close();
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getAttributes().get("dc"));
    }

    @Test
    public void testAdminAccessBug() throws Exception {
        MiscBindIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(true);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ldap://localhost:" + MiscBindIT.getLdapServer().getPort());
        env.put("java.naming.ldap.version", "3");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        BasicAttributes attributes = new BasicAttributes(true);
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add("top");
        objectClass.add("organizationalUnit");
        attributes.put(objectClass);
        attributes.put("ou", "blah");
        InitialDirContext ctx = new InitialDirContext(env);
        ctx.createSubcontext("ou=blah,ou=system", (Attributes)attributes);
        SearchControls controls = new SearchControls();
        controls.setSearchScope(0);
        controls.setReturningAttributes(new String[]{"+"});
        NamingEnumeration<SearchResult> list = ctx.search("ou=blah,ou=system", "(objectClass=*)", controls);
        SearchResult result = list.next();
        list.close();
        Attribute creatorsName = result.getAttributes().get("creatorsName");
        Assert.assertEquals((Object)"", (Object)creatorsName.get());
        ctx.destroySubcontext("ou=blah,ou=system");
    }

    @Test
    public void testUserAuthOnMixedCaseSuffix() throws Exception {
        MiscBindIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(true);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ldap://localhost:" + MiscBindIT.getLdapServer().getPort() + "/dc=aPache,dc=org");
        env.put("java.naming.ldap.version", "3");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        InitialDirContext ctx = new InitialDirContext(env);
        Attributes attrs = ctx.getAttributes("");
        Assert.assertTrue((boolean)attrs.get("dc").get().equals("aPache"));
        BasicAttributes user = new BasicAttributes("cn", "Kate Bush", true);
        BasicAttribute oc = new BasicAttribute("objectClass");
        oc.add("top");
        oc.add("person");
        oc.add("organizationalPerson");
        oc.add("inetOrgPerson");
        user.put(oc);
        user.put("sn", "Bush");
        user.put("userPassword", "Aerial");
        ctx.createSubcontext("cn=Kate Bush", (Attributes)user);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.credentials", "Aerial");
        env.put("java.naming.security.principal", "cn=Kate Bush,dc=aPache,dc=org");
        InitialDirContext userCtx = new InitialDirContext(env);
        Assert.assertNotNull((Object)userCtx);
        ctx.destroySubcontext("cn=Kate Bush");
    }

    @Test
    public void testFailureWithUnsupportedControl() throws Exception {
        OpaqueControl unsupported = new OpaqueControl("1.1.1.1");
        unsupported.setCritical(true);
        MiscBindIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(true);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ldap://localhost:" + MiscBindIT.getLdapServer().getPort() + "/ou=system");
        env.put("java.naming.ldap.version", "3");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        BasicAttributes user = new BasicAttributes("cn", "Kate Bush", true);
        BasicAttribute oc = new BasicAttribute("objectClass");
        oc.add("top");
        oc.add("person");
        oc.add("organizationalPerson");
        oc.add("inetOrgPerson");
        user.put(oc);
        user.put("sn", "Bush");
        user.put("userPassword", "Aerial");
        ctx.setRequestControls(JndiUtils.toJndiControls((LdapApiService)MiscBindIT.getLdapServer().getDirectoryService().getLdapCodecService(), (Control[])new Control[]{unsupported}));
        try {
            ctx.createSubcontext("cn=Kate Bush", (Attributes)user);
            Assert.fail();
        }
        catch (OperationNotSupportedException e) {
            // empty catch block
        }
        unsupported.setCritical(false);
        ctx.setRequestControls(JndiUtils.toJndiControls((LdapApiService)MiscBindIT.getLdapServer().getDirectoryService().getLdapCodecService(), (Control[])new Control[]{unsupported}));
        DirContext kate = ctx.createSubcontext("cn=Kate Bush", (Attributes)user);
        Assert.assertNotNull((Object)kate);
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)Asn1StringUtils.getBytesUtf8((String)"Aerial"), (Object)kate.getAttributes("").get("userPassword").get()));
        ctx.destroySubcontext("cn=Kate Bush");
    }
}

