/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.modify;

import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(enableChangeLog=true, name="ModifyReplaceIT-class")
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP"), @CreateTransport(protocol="LDAPS")})
@ApplyLdifs(value={"dn: cn=Kate Bush,ou=system", "objectClass: top", "objectClass: person", "sn: Bush", "cn: Kate Bush", "dn: cn=Kim Wilde,ou=system", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson ", "objectClass: inetOrgPerson ", "sn: Wilde", "cn: Kim Wilde"})
public class ModifyReplaceIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final String BASE = "ou=system";

    @Test
    public void testReplaceToRemoveNotPresentAttribute() throws Exception {
        DirContext sysRoot = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyReplaceIT.getLdapServer()).lookup(BASE);
        String rdn = "cn=Kate Bush";
        BasicAttribute attr = new BasicAttribute("description");
        ModificationItem item = new ModificationItem(2, attr);
        sysRoot.modifyAttributes(rdn, new ModificationItem[]{item});
        SearchControls sctls = new SearchControls();
        sctls.setSearchScope(2);
        String filter = "(sn=Bush)";
        String base = "";
        NamingEnumeration<SearchResult> enm = sysRoot.search(base, filter, sctls);
        while (enm.hasMore()) {
            SearchResult sr = enm.next();
            Attribute cn = sr.getAttributes().get("cn");
            Assert.assertNotNull((Object)cn);
            Assert.assertTrue((boolean)cn.contains("Kate Bush"));
            Attribute desc = sr.getAttributes().get("description");
            Assert.assertNull((Object)desc);
        }
    }

    @Test
    public void testReplaceToAddNotPresentAttribute() throws Exception {
        DirContext sysRoot = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyReplaceIT.getLdapServer()).lookup(BASE);
        String rdn = "cn=Kate Bush";
        BasicAttribute attr = new BasicAttribute("description", "added description");
        ModificationItem item = new ModificationItem(2, attr);
        sysRoot.modifyAttributes(rdn, new ModificationItem[]{item});
        SearchControls sctls = new SearchControls();
        sctls.setSearchScope(2);
        String filter = "(sn=Bush)";
        String base = "";
        NamingEnumeration<SearchResult> enm = sysRoot.search(base, filter, sctls);
        while (enm.hasMore()) {
            SearchResult sr = enm.next();
            Attribute cn = sr.getAttributes().get("cn");
            Assert.assertNotNull((Object)cn);
            Assert.assertTrue((boolean)cn.contains("Kate Bush"));
            Attribute desc = sr.getAttributes().get("description");
            Assert.assertNotNull((Object)desc);
            Assert.assertTrue((boolean)desc.contains("added description"));
            Assert.assertEquals((long)1L, (long)desc.size());
        }
    }

    @Test
    public void testReplaceNonExistingAttribute() throws Exception {
        DirContext sysRoot = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyReplaceIT.getLdapServer()).lookup(BASE);
        String rdn = "cn=Kate Bush";
        BasicAttribute attr = new BasicAttribute("numberOfOctaves");
        ModificationItem item = new ModificationItem(2, attr);
        try {
            sysRoot.modifyAttributes(rdn, new ModificationItem[]{item});
            Assert.fail();
        }
        catch (InvalidAttributeIdentifierException iaie) {
            Assert.assertTrue((boolean)true);
        }
        SearchControls sctls = new SearchControls();
        sctls.setSearchScope(2);
        String filter = "(sn=Bush)";
        String base = "";
        NamingEnumeration<SearchResult> enm = sysRoot.search(base, filter, sctls);
        while (enm.hasMore()) {
            SearchResult sr = enm.next();
            Attribute cn = sr.getAttributes().get("cn");
            Assert.assertNotNull((Object)cn);
            Assert.assertTrue((boolean)cn.contains("Kate Bush"));
        }
    }

    @Test
    public void testReplaceNonExistingAttributeManyMods() throws Exception {
        DirContext sysRoot = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyReplaceIT.getLdapServer()).lookup(BASE);
        String rdn = "cn=Kate Bush";
        BasicAttribute attr = new BasicAttribute("numberOfOctaves");
        ModificationItem item = new ModificationItem(2, attr);
        BasicAttribute attr2 = new BasicAttribute("description", "blah blah blah");
        ModificationItem item2 = new ModificationItem(1, attr2);
        try {
            sysRoot.modifyAttributes(rdn, new ModificationItem[]{item, item2});
            Assert.fail();
        }
        catch (InvalidAttributeIdentifierException iaie) {
            Assert.assertTrue((boolean)true);
        }
        SearchControls sctls = new SearchControls();
        sctls.setSearchScope(2);
        String filter = "(sn=Bush)";
        String base = "";
        NamingEnumeration<SearchResult> enm = sysRoot.search(base, filter, sctls);
        while (enm.hasMore()) {
            SearchResult sr = enm.next();
            Attribute cn = sr.getAttributes().get("cn");
            Assert.assertNotNull((Object)cn);
            Assert.assertTrue((boolean)cn.contains("Kate Bush"));
        }
    }

    @Test
    public void testReplaceNonExistingIndexedAttribute() throws Exception {
        DirContext sysRoot = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyReplaceIT.getLdapServer()).lookup(BASE);
        String rdn = "cn=Kim Wilde";
        BasicAttribute attr = new BasicAttribute("ou", "test");
        ModificationItem item = new ModificationItem(2, attr);
        sysRoot.modifyAttributes(rdn, new ModificationItem[]{item});
        SearchControls sctls = new SearchControls();
        sctls.setSearchScope(2);
        String filter = "(sn=Wilde)";
        String base = "";
        NamingEnumeration<SearchResult> enm = sysRoot.search(base, filter, sctls);
        while (enm.hasMore()) {
            SearchResult sr = enm.next();
            Attribute ou = sr.getAttributes().get("ou");
            Assert.assertNotNull((Object)ou);
            Assert.assertTrue((boolean)ou.contains("test"));
        }
    }

    @Test
    public void testReplaceCaseOfAttributeDescription() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyReplaceIT.getLdapServer()).lookup(BASE);
        String rdn = "cn=Kate Bush";
        String newValue = "2345678901";
        Attributes attrs = new BasicAttributes("telephoneNumber", newValue, false);
        ctx.modifyAttributes(rdn, 2, attrs);
        attrs = ctx.getAttributes(rdn);
        Attribute attr = attrs.get("telephoneNumber");
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((Object)"telephoneNumber", (Object)attr.getID());
        Assert.assertTrue((boolean)attr.contains(newValue));
        Assert.assertEquals((long)1L, (long)attr.size());
    }

    @Test
    public void testReplaceAttributeNotInOC() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyReplaceIT.getLdapServer()).lookup(BASE);
        String rdn = "cn=Kate Bush";
        String newValue = "Test";
        BasicAttributes attrs = new BasicAttributes("ou", newValue, false);
        try {
            ctx.modifyAttributes(rdn, 2, (Attributes)attrs);
            Assert.fail((String)"Should get a SchemaViolationException");
        }
        catch (SchemaViolationException sve) {
            Assert.assertTrue((boolean)true);
        }
    }
}

