/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.modify;

import javax.naming.ReferralException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.controls.ManageDsaITImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.operations.compare.CompareIT;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: uid=akarasulu,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: akarasulu", "cn: Alex Karasulu", "sn: karasulu", "dn: ou=Computers,uid=akarasulu,ou=users,ou=system", "objectClass: organizationalUnit", "objectClass: top", "ou: computers", "description: Computers for Alex", "seeAlso: ou=Machines,uid=akarasulu,ou=users,ou=system", "dn: uid=akarasuluref,ou=users,ou=system", "objectClass: extensibleObject", "objectClass: referral", "objectClass: top", "uid: akarasuluref", "ref: ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://foo:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://bar:10389/uid=akarasulu,ou=users,ou=system"})
public class ModifyReferralIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final Logger LOG = LoggerFactory.getLogger(CompareIT.class);

    @Test
    public void testOnReferralWithManageDsaITControl() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)ModifyReferralIT.getLdapServer());
        ManageDsaITImpl manageDSAIT = new ManageDsaITImpl();
        manageDSAIT.setCritical(true);
        ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
        modifyRequest.setName(new Dn(new String[]{"uid=akarasuluref,ou=users,ou=system"}));
        modifyRequest.add("description", new String[]{"referral to akarasulu"});
        modifyRequest.addControl((Control)manageDSAIT);
        conn.modify((ModifyRequest)modifyRequest);
        Assert.assertTrue((boolean)conn.compare("uid=akarasuluref,ou=users,ou=system", "description", "referral to akarasulu"));
        conn.close();
    }

    @Test
    public void testOnReferral() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)ModifyReferralIT.getLdapServer());
        ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
        modifyRequest.setName(new Dn(new String[]{"uid=akarasuluref,ou=users,ou=system"}));
        modifyRequest.add("description", new String[]{"referral to akarasulu"});
        ModifyResponse modifyResponse = conn.modify((ModifyRequest)modifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.REFERRAL, (Object)modifyResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)modifyResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://localhost:10389/uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)modifyResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://foo:10389/uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)modifyResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://bar:10389/uid=akarasulu,ou=users,ou=system"));
        conn.close();
    }

    @Test
    public void testThrowOnReferralWithJndi() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)ModifyReferralIT.getLdapServer());
        BasicAttribute attr = new BasicAttribute("description", "referral to akarasulu");
        ModificationItem mod = new ModificationItem(1, attr);
        try {
            ctx.modifyAttributes("uid=akarasuluref,ou=users,ou=system", new ModificationItem[]{mod});
        }
        catch (ReferralException e) {
            Assert.assertEquals((Object)"ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", (Object)e.getReferralInfo());
        }
        ctx.close();
    }

    @Test
    public void testAncestorReferral() throws Exception {
        LOG.debug("");
        LdapConnection conn = ServerIntegrationUtils.getWiredConnection((LdapServer)ModifyReferralIT.getLdapServer());
        ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
        modifyRequest.setName(new Dn(new String[]{"ou=Computers,uid=akarasuluref,ou=users,ou=system"}));
        modifyRequest.add("ou", new String[]{"Machines"});
        ModifyResponse modifyResponse = conn.modify((ModifyRequest)modifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.REFERRAL, (Object)modifyResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)modifyResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://localhost:10389/ou=Computers,uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)modifyResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://foo:10389/ou=Computers,uid=akarasulu,ou=users,ou=system"));
        Assert.assertTrue((boolean)modifyResponse.getLdapResult().getReferral().getLdapUrls().contains("ldap://bar:10389/ou=Computers,uid=akarasulu,ou=users,ou=system"));
        conn.close();
    }
}

