/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.ldapsdk;

import javax.naming.ReferralException;
import javax.naming.ldap.LdapContext;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSearchConstraints;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.util.Strings;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: uid=akarasulu,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: akarasulu", "cn: Alex Karasulu", "sn: karasulu", "dn: ou=Computers,uid=akarasulu,ou=users,ou=system", "objectClass: organizationalUnit", "objectClass: top", "ou: computers", "description: Computers for Alex", "seeAlso: ou=Machines,uid=akarasulu,ou=users,ou=system", "dn: uid=akarasuluref,ou=users,ou=system", "objectClass: uidObject", "objectClass: referral", "objectClass: top", "uid: akarasuluref", "ref: ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://foo:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://bar:10389/uid=akarasulu,ou=users,ou=system", "dn: uid=elecharny,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: elecharny", "cn: Emmanuel Lecharny", "sn: lecharny"})
public class ModifyDnReferralIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final Logger LOG = LoggerFactory.getLogger(ModifyDnReferralIT.class);

    @Test
    public void testOnReferralWithManageDsaITControl() throws Exception {
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)ModifyDnReferralIT.getLdapServer());
        LDAPSearchConstraints constraints = new LDAPSearchConstraints();
        constraints.setClientControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, Strings.EMPTY_BYTES));
        constraints.setServerControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, Strings.EMPTY_BYTES));
        conn.setConstraints((LDAPConstraints)constraints);
        conn.rename("uid=akarasuluref,ou=users,ou=system", "uid=ref", true, (LDAPConstraints)constraints);
        LDAPEntry entry = conn.read("uid=ref,ou=users,ou=system", constraints);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"uid=ref,ou=users,ou=system", (Object)entry.getDN());
        conn.disconnect();
    }

    @Test
    public void testNewSuperiorOnReferralWithManageDsaITControl() throws Exception {
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)ModifyDnReferralIT.getLdapServer());
        LDAPSearchConstraints constraints = new LDAPSearchConstraints();
        constraints.setClientControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, Strings.EMPTY_BYTES));
        constraints.setServerControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, Strings.EMPTY_BYTES));
        conn.setConstraints((LDAPConstraints)constraints);
        try {
            conn.rename("uid=elecharny,ou=users,ou=system", "uid=newuser", "uid=akarasuluref,ou=users,ou=system", true, (LDAPConstraints)constraints);
        }
        catch (LDAPException le) {
            Assert.assertEquals((long)71L, (long)le.getLDAPResultCode());
        }
        conn.disconnect();
    }

    @Test
    public void testOnReferral() throws Exception {
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)ModifyDnReferralIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        constraints.setReferrals(false);
        conn.setConstraints(constraints);
        LDAPResponseListener listener = null;
        LDAPResponse response = null;
        listener = conn.rename("uid=akarasuluref,ou=users,ou=system", "uid=ref", true, null, constraints);
        response = listener.getResponse();
        Assert.assertEquals((long)ResultCodeEnum.REFERRAL.getValue(), (long)response.getResultCode());
        Assert.assertEquals((Object)"ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[0]);
        Assert.assertEquals((Object)"ldap://foo:10389/uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[1]);
        Assert.assertEquals((Object)"ldap://bar:10389/uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[2]);
        conn.disconnect();
    }

    @Test
    public void testNewSupierorOnReferral() throws Exception {
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)ModifyDnReferralIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        constraints.setReferrals(false);
        conn.setConstraints(constraints);
        try {
            conn.rename("uid=elecharny,ou=users,ou=system", "uid=ref", "uid=akarasuluref,ou=users,ou=system", true, constraints);
        }
        catch (LDAPException e) {
            Assert.assertEquals((long)71L, (long)e.getLDAPResultCode());
        }
        conn.disconnect();
    }

    @Test
    public void testThrowOnReferralWithJndi() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)ModifyDnReferralIT.getLdapServer());
        try {
            ctx.rename("uid=akarasuluref,ou=users,ou=system", "uid=ref,ou=users,ou=system");
            Assert.fail((String)"Should never get here due to ModifyDN failure on ReferralException");
        }
        catch (ReferralException e) {
            Assert.assertEquals((Object)"ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", (Object)e.getReferralInfo());
        }
        ctx.close();
    }

    @Test
    public void testAncestorReferral() throws Exception {
        LOG.debug("");
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)ModifyDnReferralIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        conn.setConstraints(constraints);
        LDAPResponseListener listener = null;
        LDAPResponse response = null;
        listener = conn.rename("ou=Computers,uid=akarasuluref,ou=users,ou=system", "ou=Machines", true, null, constraints);
        response = listener.getResponse();
        Assert.assertEquals((long)ResultCodeEnum.REFERRAL.getValue(), (long)response.getResultCode());
        Assert.assertEquals((Object)"ldap://localhost:10389/ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[0]);
        Assert.assertEquals((Object)"ldap://foo:10389/ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[1]);
        Assert.assertEquals((Object)"ldap://bar:10389/ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[2]);
        conn.disconnect();
    }

    @Test
    public void testNewSuperiorAncestorReferral() throws Exception {
        LOG.debug("");
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)ModifyDnReferralIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        conn.setConstraints(constraints);
        try {
            conn.rename("uid=elecharny,ou=users,ou=system", "ou=Machines", "ou=Computers,uid=akarasuluref,ou=users,ou=system", true, constraints);
            Assert.fail((String)"Should never get here to affectsMultipleDSA error result code");
        }
        catch (LDAPException e) {
            Assert.assertEquals((long)71L, (long)e.getLDAPResultCode());
        }
        conn.disconnect();
    }
}

