/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class ReloadableSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory delegate;

    public static SSLSocketFactory getDefault() {
        return new ReloadableSSLSocketFactory();
    }

    public ReloadableSSLSocketFactory() {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init((KeyStore)null);
            TrustManager[] trustManagers = factory.getTrustManagers();
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustManagers, null);
            this.delegate = sc.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private SSLSocketFactory getDelegate() {
        return this.delegate;
    }

    public String[] getDefaultCipherSuites() {
        return this.getDelegate().getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.getDelegate().getSupportedCipherSuites();
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        try {
            return this.getDelegate().createSocket(s, host, port, autoClose);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        try {
            return this.getDelegate().createSocket(host, port);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        try {
            return this.getDelegate().createSocket(host, port);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        try {
            return this.getDelegate().createSocket(host, port, localHost, localPort);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        try {
            return this.getDelegate().createSocket(address, port, localAddress, localPort);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

